/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom.nvtristrip;

import com.jme.util.geom.nvtristrip.EdgeInfo;
import com.jme.util.geom.nvtristrip.EdgeInfoVec;
import com.jme.util.geom.nvtristrip.FaceInfo;
import com.jme.util.geom.nvtristrip.FaceInfoVec;
import com.jme.util.geom.nvtristrip.IntVec;
import com.jme.util.geom.nvtristrip.StripInfo;
import com.jme.util.geom.nvtristrip.StripInfoVec;
import com.jme.util.geom.nvtristrip.StripStartInfo;
import com.jme.util.geom.nvtristrip.VertexCache;
import java.util.HashSet;
import java.util.logging.Logger;

class Stripifier {
    private static final Logger logger = Logger.getLogger(Stripifier.class.getName());
    public static int CACHE_INEFFICIENCY = 6;
    IntVec indices = new IntVec();
    int cacheSize;
    int minStripLength;
    float meshJump;
    boolean bFirstTimeResetPoint;

    Stripifier() {
    }

    static EdgeInfo findEdgeInfo(EdgeInfoVec edgeInfoVec, int n, int n2) {
        EdgeInfo edgeInfo = edgeInfoVec.at(n);
        while (edgeInfo != null) {
            if (edgeInfo.m_v0 == n) {
                if (edgeInfo.m_v1 == n2) {
                    return edgeInfo;
                }
                edgeInfo = edgeInfo.m_nextV0;
                continue;
            }
            if (edgeInfo.m_v0 == n2) {
                return edgeInfo;
            }
            edgeInfo = edgeInfo.m_nextV1;
        }
        return null;
    }

    static FaceInfo findOtherFace(EdgeInfoVec edgeInfoVec, int n, int n2, FaceInfo faceInfo) {
        EdgeInfo edgeInfo = Stripifier.findEdgeInfo(edgeInfoVec, n, n2);
        if (edgeInfo == null && n == n2) {
            return null;
        }
        return edgeInfo.m_face0 == faceInfo ? edgeInfo.m_face1 : edgeInfo.m_face0;
    }

    static boolean alreadyExists(FaceInfo faceInfo, FaceInfoVec faceInfoVec) {
        for (int i = 0; i < faceInfoVec.size(); ++i) {
            FaceInfo faceInfo2 = faceInfoVec.at(i);
            if (faceInfo2.m_v0 != faceInfo.m_v0 || faceInfo2.m_v1 != faceInfo.m_v1 || faceInfo2.m_v2 != faceInfo.m_v2) continue;
            return true;
        }
        return false;
    }

    void buildStripifyInfo(FaceInfoVec faceInfoVec, EdgeInfoVec edgeInfoVec, int n) {
        int n2;
        int n3 = this.indices.size();
        faceInfoVec.reserve(n3 / 3);
        for (n2 = 0; n2 < n + 1; ++n2) {
            edgeInfoVec.add(null);
        }
        n2 = n3 / 3;
        int n4 = 0;
        boolean[] blArray = new boolean[3];
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            boolean bl = true;
            blArray[0] = false;
            blArray[1] = false;
            blArray[2] = false;
            int n7 = this.indices.get(n4++);
            if (Stripifier.isDegenerate(n7, n6 = this.indices.get(n4++), n5 = this.indices.get(n4++))) continue;
            FaceInfo faceInfo = new FaceInfo(n7, n6, n5);
            EdgeInfo edgeInfo = Stripifier.findEdgeInfo(edgeInfoVec, n7, n6);
            if (edgeInfo == null) {
                bl = false;
                edgeInfo = new EdgeInfo(n7, n6);
                edgeInfo.m_nextV0 = edgeInfoVec.at(n7);
                edgeInfo.m_nextV1 = edgeInfoVec.at(n6);
                edgeInfoVec.set(n7, edgeInfo);
                edgeInfoVec.set(n6, edgeInfo);
                edgeInfo.m_face0 = faceInfo;
            } else if (edgeInfo.m_face1 != null) {
                logger.info("BuildStripifyInfo: > 2 triangles on an edge" + n7 + "," + n6 + "... uncertain consequences\n");
            } else {
                edgeInfo.m_face1 = faceInfo;
                blArray[0] = true;
            }
            EdgeInfo edgeInfo2 = Stripifier.findEdgeInfo(edgeInfoVec, n6, n5);
            if (edgeInfo2 == null) {
                bl = false;
                edgeInfo2 = new EdgeInfo(n6, n5);
                edgeInfo2.m_nextV0 = edgeInfoVec.at(n6);
                edgeInfo2.m_nextV1 = edgeInfoVec.at(n5);
                edgeInfoVec.set(n6, edgeInfo2);
                edgeInfoVec.set(n5, edgeInfo2);
                edgeInfo2.m_face0 = faceInfo;
            } else if (edgeInfo2.m_face1 != null) {
                logger.info("BuildStripifyInfo: > 2 triangles on an edge" + n6 + "," + n5 + "... uncertain consequences\n");
            } else {
                edgeInfo2.m_face1 = faceInfo;
                blArray[1] = true;
            }
            EdgeInfo edgeInfo3 = Stripifier.findEdgeInfo(edgeInfoVec, n5, n7);
            if (edgeInfo3 == null) {
                bl = false;
                edgeInfo3 = new EdgeInfo(n5, n7);
                edgeInfo3.m_nextV0 = edgeInfoVec.at(n5);
                edgeInfo3.m_nextV1 = edgeInfoVec.at(n7);
                edgeInfoVec.set(n5, edgeInfo3);
                edgeInfoVec.set(n7, edgeInfo3);
                edgeInfo3.m_face0 = faceInfo;
            } else if (edgeInfo3.m_face1 != null) {
                logger.info("BuildStripifyInfo: > 2 triangles on an edge" + n5 + "," + n7 + "... uncertain consequences\n");
            } else {
                edgeInfo3.m_face1 = faceInfo;
                blArray[2] = true;
            }
            if (bl) {
                if (!Stripifier.alreadyExists(faceInfo, faceInfoVec)) {
                    faceInfoVec.add(faceInfo);
                    continue;
                }
                if (blArray[0]) {
                    edgeInfo.m_face1 = null;
                }
                if (blArray[1]) {
                    edgeInfo2.m_face1 = null;
                }
                if (!blArray[2]) continue;
                edgeInfo3.m_face1 = null;
                continue;
            }
            faceInfoVec.add(faceInfo);
        }
    }

    static boolean isDegenerate(FaceInfo faceInfo) {
        if (faceInfo.m_v0 == faceInfo.m_v1) {
            return true;
        }
        if (faceInfo.m_v0 == faceInfo.m_v2) {
            return true;
        }
        return faceInfo.m_v1 == faceInfo.m_v2;
    }

    static boolean isDegenerate(int n, int n2, int n3) {
        if (n == n2) {
            return true;
        }
        if (n == n3) {
            return true;
        }
        return n2 == n3;
    }

    static int getNextIndex(IntVec intVec, FaceInfo faceInfo) {
        int n = intVec.size();
        int n2 = intVec.get(n - 2);
        int n3 = intVec.get(n - 1);
        int n4 = faceInfo.m_v0;
        int n5 = faceInfo.m_v1;
        int n6 = faceInfo.m_v2;
        if (n4 != n2 && n4 != n3) {
            if (n5 != n2 && n5 != n3 || n6 != n2 && n6 != n3) {
                logger.info("GetNextIndex: Triangle doesn't have all of its vertices\n");
                logger.info("GetNextIndex: Duplicate triangle probably got us derailed\n");
            }
            return n4;
        }
        if (n5 != n2 && n5 != n3) {
            if (n4 != n2 && n4 != n3 || n6 != n2 && n6 != n3) {
                logger.info("GetNextIndex: Triangle doesn't have all of its vertices\n");
                logger.info("GetNextIndex: Duplicate triangle probably got us derailed\n");
            }
            return n5;
        }
        if (n6 != n2 && n6 != n3) {
            if (n4 != n2 && n4 != n3 || n5 != n2 && n5 != n3) {
                logger.info("GetNextIndex: Triangle doesn't have all of its vertices\n");
                logger.info("GetNextIndex: Duplicate triangle probably got us derailed\n");
            }
            return n6;
        }
        if (n4 == n5 || n4 == n6) {
            return n4;
        }
        if (n5 == n4 || n5 == n6) {
            return n5;
        }
        if (n6 == n4 || n6 == n5) {
            return n6;
        }
        return -1;
    }

    static int findStartPoint(FaceInfoVec faceInfoVec, EdgeInfoVec edgeInfoVec) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < faceInfoVec.size(); ++i) {
            int n3 = 0;
            if (Stripifier.findOtherFace(edgeInfoVec, faceInfoVec.at((int)i).m_v0, faceInfoVec.at((int)i).m_v1, faceInfoVec.at(i)) == null) {
                ++n3;
            }
            if (Stripifier.findOtherFace(edgeInfoVec, faceInfoVec.at((int)i).m_v1, faceInfoVec.at((int)i).m_v2, faceInfoVec.at(i)) == null) {
                ++n3;
            }
            if (Stripifier.findOtherFace(edgeInfoVec, faceInfoVec.at((int)i).m_v2, faceInfoVec.at((int)i).m_v0, faceInfoVec.at(i)) == null) {
                ++n3;
            }
            if (n3 <= n) continue;
            n = n3;
            n2 = i;
        }
        if (n == 0) {
            return -1;
        }
        return n2;
    }

    FaceInfo findGoodResetPoint(FaceInfoVec faceInfoVec, EdgeInfoVec edgeInfoVec) {
        FaceInfo faceInfo = null;
        if (faceInfo == null) {
            int n;
            int n2 = faceInfoVec.size();
            if (this.bFirstTimeResetPoint) {
                n = Stripifier.findStartPoint(faceInfoVec, edgeInfoVec);
                this.bFirstTimeResetPoint = false;
            } else {
                n = (int)(((float)n2 - 1.0f) * this.meshJump);
            }
            if (n == -1) {
                n = (int)(((float)n2 - 1.0f) * this.meshJump);
            }
            int n3 = n;
            do {
                if (faceInfoVec.at((int)n3).m_stripId < 0) {
                    faceInfo = faceInfoVec.at(n3);
                    break;
                }
                if (++n3 < n2) continue;
                n3 = 0;
            } while (n3 != n);
            this.meshJump += 0.1f;
            if (this.meshJump > 1.0f) {
                this.meshJump = 0.05f;
            }
        }
        return faceInfo;
    }

    static int getUniqueVertexInB(FaceInfo faceInfo, FaceInfo faceInfo2) {
        int n = faceInfo2.m_v0;
        if (n != faceInfo.m_v0 && n != faceInfo.m_v1 && n != faceInfo.m_v2) {
            return n;
        }
        int n2 = faceInfo2.m_v1;
        if (n2 != faceInfo.m_v0 && n2 != faceInfo.m_v1 && n2 != faceInfo.m_v2) {
            return n2;
        }
        int n3 = faceInfo2.m_v2;
        if (n3 != faceInfo.m_v0 && n3 != faceInfo.m_v1 && n3 != faceInfo.m_v2) {
            return n3;
        }
        return -1;
    }

    static void getSharedVertices(FaceInfo faceInfo, FaceInfo faceInfo2, int[] nArray) {
        int n;
        int n2;
        nArray[0] = -1;
        nArray[1] = -1;
        int n3 = faceInfo2.m_v0;
        if (n3 == faceInfo.m_v0 || n3 == faceInfo.m_v1 || n3 == faceInfo.m_v2) {
            if (nArray[0] == -1) {
                nArray[0] = n3;
            } else {
                nArray[1] = n3;
                return;
            }
        }
        if ((n2 = faceInfo2.m_v1) == faceInfo.m_v0 || n2 == faceInfo.m_v1 || n2 == faceInfo.m_v2) {
            if (nArray[0] == -1) {
                nArray[0] = n2;
            } else {
                nArray[1] = n2;
                return;
            }
        }
        if ((n = faceInfo2.m_v2) == faceInfo.m_v0 || n == faceInfo.m_v1 || n == faceInfo.m_v2) {
            if (nArray[0] == -1) {
                nArray[0] = n;
            } else {
                nArray[1] = n;
                return;
            }
        }
    }

    static void commitStrips(StripInfoVec stripInfoVec, StripInfoVec stripInfoVec2) {
        int n = stripInfoVec2.size();
        for (int i = 0; i < n; ++i) {
            StripInfo stripInfo = stripInfoVec2.at(i);
            stripInfo.m_experimentId = -1;
            stripInfoVec.add(stripInfo);
            FaceInfoVec faceInfoVec = stripInfoVec2.at((int)i).m_faces;
            int n2 = faceInfoVec.size();
            for (int j = 0; j < n2; ++j) {
                stripInfo.markTriangle(faceInfoVec.at(j));
            }
        }
    }

    static boolean nextIsCW(int n) {
        return n % 2 == 0;
    }

    static void updateCacheFace(VertexCache vertexCache, FaceInfo faceInfo) {
        if (!vertexCache.inCache(faceInfo.m_v0)) {
            vertexCache.addEntry(faceInfo.m_v0);
        }
        if (!vertexCache.inCache(faceInfo.m_v1)) {
            vertexCache.addEntry(faceInfo.m_v1);
        }
        if (!vertexCache.inCache(faceInfo.m_v2)) {
            vertexCache.addEntry(faceInfo.m_v2);
        }
    }

    static void updateCacheStrip(VertexCache vertexCache, StripInfo stripInfo) {
        for (int i = 0; i < stripInfo.m_faces.size(); ++i) {
            if (!vertexCache.inCache(stripInfo.m_faces.at((int)i).m_v0)) {
                vertexCache.addEntry(stripInfo.m_faces.at((int)i).m_v0);
            }
            if (!vertexCache.inCache(stripInfo.m_faces.at((int)i).m_v1)) {
                vertexCache.addEntry(stripInfo.m_faces.at((int)i).m_v1);
            }
            if (vertexCache.inCache(stripInfo.m_faces.at((int)i).m_v2)) continue;
            vertexCache.addEntry(stripInfo.m_faces.at((int)i).m_v2);
        }
    }

    static float calcNumHitsStrip(VertexCache vertexCache, StripInfo stripInfo) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stripInfo.m_faces.size(); ++i) {
            if (vertexCache.inCache(stripInfo.m_faces.at((int)i).m_v0)) {
                ++n;
            }
            if (vertexCache.inCache(stripInfo.m_faces.at((int)i).m_v1)) {
                ++n;
            }
            if (vertexCache.inCache(stripInfo.m_faces.at((int)i).m_v2)) {
                ++n;
            }
            ++n2;
        }
        return (float)n / (float)n2;
    }

    static float avgStripSize(StripInfoVec stripInfoVec) {
        int n = 0;
        int n2 = stripInfoVec.size();
        for (int i = 0; i < n2; ++i) {
            StripInfo stripInfo = stripInfoVec.at(i);
            n += stripInfo.m_faces.size();
            n -= stripInfo.m_numDegenerates;
        }
        return (float)n / (float)n2;
    }

    static int calcNumHitsFace(VertexCache vertexCache, FaceInfo faceInfo) {
        int n = 0;
        if (vertexCache.inCache(faceInfo.m_v0)) {
            ++n;
        }
        if (vertexCache.inCache(faceInfo.m_v1)) {
            ++n;
        }
        if (vertexCache.inCache(faceInfo.m_v2)) {
            ++n;
        }
        return n;
    }

    static int numNeighbors(FaceInfo faceInfo, EdgeInfoVec edgeInfoVec) {
        int n = 0;
        if (Stripifier.findOtherFace(edgeInfoVec, faceInfo.m_v0, faceInfo.m_v1, faceInfo) != null) {
            ++n;
        }
        if (Stripifier.findOtherFace(edgeInfoVec, faceInfo.m_v1, faceInfo.m_v2, faceInfo) != null) {
            ++n;
        }
        if (Stripifier.findOtherFace(edgeInfoVec, faceInfo.m_v2, faceInfo.m_v0, faceInfo) != null) {
            ++n;
        }
        return n;
    }

    static boolean isCW(FaceInfo faceInfo, int n, int n2) {
        if (faceInfo.m_v0 == n) {
            return faceInfo.m_v1 == n2;
        }
        if (faceInfo.m_v1 == n) {
            return faceInfo.m_v2 == n2;
        }
        return faceInfo.m_v0 == n2;
    }

    static boolean faceContainsIndex(FaceInfo faceInfo, int n) {
        return faceInfo.m_v0 == n || faceInfo.m_v1 == n || faceInfo.m_v2 == n;
    }

    static boolean findTraversal(FaceInfoVec faceInfoVec, EdgeInfoVec edgeInfoVec, StripInfo stripInfo, StripStartInfo stripStartInfo) {
        int n = stripInfo.m_startInfo.m_toV1 ? stripInfo.m_startInfo.m_startEdge.m_v1 : stripInfo.m_startInfo.m_startEdge.m_v0;
        FaceInfo faceInfo = null;
        EdgeInfo edgeInfo = edgeInfoVec.at(n);
        while (edgeInfo != null) {
            FaceInfo faceInfo2 = edgeInfo.m_face0;
            FaceInfo faceInfo3 = edgeInfo.m_face1;
            if (faceInfo2 != null && !stripInfo.isInStrip(faceInfo2) && faceInfo3 != null && !stripInfo.isMarked(faceInfo3)) {
                faceInfo = faceInfo3;
                break;
            }
            if (faceInfo3 != null && !stripInfo.isInStrip(faceInfo3) && faceInfo2 != null && !stripInfo.isMarked(faceInfo2)) {
                faceInfo = faceInfo2;
                break;
            }
            edgeInfo = edgeInfo.m_v0 == n ? edgeInfo.m_nextV0 : edgeInfo.m_nextV1;
        }
        stripStartInfo.m_startFace = faceInfo;
        stripStartInfo.m_startEdge = edgeInfo;
        if (edgeInfo != null) {
            stripStartInfo.m_toV1 = stripInfo.sharesEdge(stripStartInfo.m_startFace, edgeInfoVec) ? edgeInfo.m_v0 == n : edgeInfo.m_v1 == n;
        }
        return stripStartInfo.m_startFace != null;
    }

    void removeSmallStrips(StripInfoVec stripInfoVec, StripInfoVec stripInfoVec2, FaceInfoVec faceInfoVec) {
        faceInfoVec.clear();
        stripInfoVec2.clear();
        FaceInfoVec faceInfoVec2 = new FaceInfoVec();
        for (int i = 0; i < stripInfoVec.size(); ++i) {
            if (stripInfoVec.at((int)i).m_faces.size() < this.minStripLength) {
                for (int j = 0; j < stripInfoVec.at((int)i).m_faces.size(); ++j) {
                    faceInfoVec2.add(stripInfoVec.at((int)i).m_faces.at(j));
                }
                continue;
            }
            stripInfoVec2.add(stripInfoVec.at(i));
        }
        boolean[] blArray = new boolean[faceInfoVec2.size()];
        VertexCache vertexCache = new VertexCache(this.cacheSize);
        int n = -1;
        int n2 = -9999;
        while (true) {
            n = -1;
            for (int i = 0; i < faceInfoVec2.size(); ++i) {
                int n3;
                if (blArray[i] || (n3 = Stripifier.calcNumHitsFace(vertexCache, faceInfoVec2.at(i))) <= n) continue;
                n = n3;
                n2 = i;
            }
            if ((float)n == -1.0f) break;
            blArray[n2] = true;
            Stripifier.updateCacheFace(vertexCache, faceInfoVec2.at(n2));
            faceInfoVec.add(faceInfoVec2.at(n2));
        }
    }

    int createStrips(StripInfoVec stripInfoVec, IntVec intVec, boolean bl) {
        int n = 0;
        FaceInfo faceInfo = new FaceInfo(0, 0, 0);
        int n2 = stripInfoVec.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            StripInfo stripInfo = stripInfoVec.at(i);
            int n5 = stripInfo.m_faces.size();
            FaceInfo faceInfo2 = new FaceInfo(stripInfo.m_faces.at((int)0).m_v0, stripInfo.m_faces.at((int)0).m_v1, stripInfo.m_faces.at((int)0).m_v2);
            if (n5 > 1) {
                int n6;
                n4 = Stripifier.getUniqueVertexInB(stripInfo.m_faces.at(1), faceInfo2);
                if (n4 == faceInfo2.m_v1) {
                    n6 = faceInfo2.m_v0;
                    faceInfo2.m_v0 = faceInfo2.m_v1;
                    faceInfo2.m_v1 = n6;
                } else if (n4 == faceInfo2.m_v2) {
                    int n7 = faceInfo2.m_v0;
                    faceInfo2.m_v0 = faceInfo2.m_v2;
                    faceInfo2.m_v2 = n7;
                }
                if (n5 > 2) {
                    int n8;
                    if (Stripifier.isDegenerate(stripInfo.m_faces.at(1))) {
                        n6 = stripInfo.m_faces.at((int)1).m_v1;
                        if (faceInfo2.m_v1 == n6) {
                            n8 = faceInfo2.m_v1;
                            faceInfo2.m_v1 = faceInfo2.m_v2;
                            faceInfo2.m_v2 = n8;
                        }
                    } else {
                        int[] nArray = new int[2];
                        Stripifier.getSharedVertices(stripInfo.m_faces.at(2), faceInfo2, nArray);
                        if (nArray[0] == faceInfo2.m_v1 && nArray[1] == -1) {
                            n8 = faceInfo2.m_v1;
                            faceInfo2.m_v1 = faceInfo2.m_v2;
                            faceInfo2.m_v2 = n8;
                        }
                    }
                }
            }
            if (i == 0 || !bl) {
                if (!Stripifier.isCW(stripInfo.m_faces.at(0), faceInfo2.m_v0, faceInfo2.m_v1)) {
                    intVec.add(faceInfo2.m_v0);
                }
            } else {
                intVec.add(faceInfo2.m_v0);
                if (Stripifier.nextIsCW(intVec.size() - n3) != Stripifier.isCW(stripInfo.m_faces.at(0), faceInfo2.m_v0, faceInfo2.m_v1)) {
                    intVec.add(faceInfo2.m_v0);
                }
            }
            intVec.add(faceInfo2.m_v0);
            intVec.add(faceInfo2.m_v1);
            intVec.add(faceInfo2.m_v2);
            faceInfo.set(faceInfo2);
            for (int j = 1; j < n5; ++j) {
                n4 = Stripifier.getUniqueVertexInB(faceInfo, stripInfo.m_faces.at(j));
                if (n4 != -1) {
                    intVec.add(n4);
                    faceInfo.m_v0 = faceInfo.m_v1;
                    faceInfo.m_v1 = faceInfo.m_v2;
                    faceInfo.m_v2 = n4;
                    continue;
                }
                intVec.add(stripInfo.m_faces.at((int)j).m_v2);
                faceInfo.m_v0 = stripInfo.m_faces.at((int)j).m_v0;
                faceInfo.m_v1 = stripInfo.m_faces.at((int)j).m_v1;
                faceInfo.m_v2 = stripInfo.m_faces.at((int)j).m_v2;
            }
            if (bl) {
                if (i != n2 - 1) {
                    intVec.add(faceInfo.m_v2);
                }
            } else {
                intVec.add(-1);
                ++n3;
                ++n;
            }
            faceInfo.m_v0 = faceInfo.m_v1;
            faceInfo.m_v1 = faceInfo.m_v2;
            faceInfo.m_v2 = faceInfo.m_v2;
        }
        if (bl) {
            n = 1;
        }
        return n;
    }

    void findAllStrips(StripInfoVec stripInfoVec, FaceInfoVec faceInfoVec, EdgeInfoVec edgeInfoVec, int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (!bl) {
            int n5;
            Object object;
            StripInfo stripInfo;
            int n6;
            int n7;
            ++n4;
            StripInfoVec[] stripInfoVecArray = new StripInfoVec[n * 6];
            for (n7 = 0; n7 < stripInfoVecArray.length; ++n7) {
                stripInfoVecArray[n7] = new StripInfoVec();
            }
            n7 = 0;
            HashSet<FaceInfo> hashSet = new HashSet<FaceInfo>();
            for (n6 = 0; n6 < n; ++n6) {
                FaceInfo faceInfo = this.findGoodResetPoint(faceInfoVec, edgeInfoVec);
                if (faceInfo == null) {
                    bl = true;
                    break;
                }
                if (hashSet.contains(faceInfo)) continue;
                hashSet.add(faceInfo);
                EdgeInfo edgeInfo = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v0, faceInfo.m_v1);
                stripInfo = new StripInfo(new StripStartInfo(faceInfo, edgeInfo, true), n3++, n2++);
                stripInfoVecArray[n7++].add(stripInfo);
                object = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v0, faceInfo.m_v1);
                StripInfo stripInfo2 = new StripInfo(new StripStartInfo(faceInfo, (EdgeInfo)object, false), n3++, n2++);
                stripInfoVecArray[n7++].add(stripInfo2);
                EdgeInfo edgeInfo2 = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v1, faceInfo.m_v2);
                StripInfo stripInfo3 = new StripInfo(new StripStartInfo(faceInfo, edgeInfo2, true), n3++, n2++);
                stripInfoVecArray[n7++].add(stripInfo3);
                EdgeInfo edgeInfo3 = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v1, faceInfo.m_v2);
                StripInfo stripInfo4 = new StripInfo(new StripStartInfo(faceInfo, edgeInfo3, false), n3++, n2++);
                stripInfoVecArray[n7++].add(stripInfo4);
                EdgeInfo edgeInfo4 = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v2, faceInfo.m_v0);
                StripInfo stripInfo5 = new StripInfo(new StripStartInfo(faceInfo, edgeInfo4, true), n3++, n2++);
                stripInfoVecArray[n7++].add(stripInfo5);
                EdgeInfo edgeInfo5 = Stripifier.findEdgeInfo(edgeInfoVec, faceInfo.m_v2, faceInfo.m_v0);
                StripInfo stripInfo6 = new StripInfo(new StripStartInfo(faceInfo, edgeInfo5, false), n3++, n2++);
                stripInfoVecArray[n7++].add(stripInfo6);
            }
            n6 = n7;
            for (n5 = 0; n5 < n6; ++n5) {
                stripInfoVecArray[n5].at(0).build(edgeInfoVec, faceInfoVec);
                int n8 = stripInfoVecArray[n5].at((int)0).m_experimentId;
                stripInfo = stripInfoVecArray[n5].at(0);
                object = new StripStartInfo(null, null, false);
                while (Stripifier.findTraversal(faceInfoVec, edgeInfoVec, stripInfo, (StripStartInfo)object)) {
                    stripInfo = new StripInfo((StripStartInfo)object, n3++, n8);
                    stripInfo.build(edgeInfoVec, faceInfoVec);
                    stripInfoVecArray[n5].add(stripInfo);
                }
            }
            n5 = 0;
            double d = 0.0;
            for (int i = 0; i < n6; ++i) {
                float f;
                float f2 = 1.0f;
                float f3 = 0.0f;
                float f4 = Stripifier.avgStripSize(stripInfoVecArray[i]);
                float f5 = f4 * f2 + (f = (float)stripInfoVecArray[i].size()) * f3;
                if (!((double)f5 > d)) continue;
                d = f5;
                n5 = i;
            }
            Stripifier.commitStrips(stripInfoVec, stripInfoVecArray[n5]);
        }
    }

    void splitUpStripsAndOptimize(StripInfoVec stripInfoVec, StripInfoVec stripInfoVec2, EdgeInfoVec edgeInfoVec, FaceInfoVec faceInfoVec) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6 = this.cacheSize;
        StripInfoVec stripInfoVec3 = new StripInfoVec();
        for (int i = 0; i < stripInfoVec.size(); ++i) {
            StripStartInfo stripStartInfo = new StripStartInfo(null, null, false);
            int n7 = 0;
            for (n5 = 0; n5 < stripInfoVec.at((int)i).m_faces.size(); ++n5) {
                if (Stripifier.isDegenerate(stripInfoVec.at((int)i).m_faces.at(n5))) continue;
                ++n7;
            }
            if (n7 > n6) {
                int n8;
                n4 = n7 / n6;
                n3 = n7 % n6;
                int n9 = 0;
                for (n5 = 0; n5 < n4; ++n5) {
                    object = new StripInfo(stripStartInfo, 0, -1);
                    n2 = n5 * n6 + n9;
                    n = 1;
                    while (n2 < n6 + n5 * n6 + n9) {
                        if (Stripifier.isDegenerate(stripInfoVec.at((int)i).m_faces.at(n2))) {
                            if ((n2 + 1 != n6 + n5 * n6 + ++n9 || n5 == n4 - 1 && n3 < 4 && n3 > 0) && n == 0) {
                                ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n2++));
                                continue;
                            }
                            ++n2;
                            continue;
                        }
                        ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n2++));
                        n = 0;
                    }
                    if (n5 == n4 - 1 && n3 < 4 && n3 > 0) {
                        n8 = 0;
                        while (n8 < n3) {
                            if (!Stripifier.isDegenerate(stripInfoVec.at((int)i).m_faces.at(n2))) {
                                ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n2++));
                                ++n8;
                                continue;
                            }
                            ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n2++));
                            ++n9;
                        }
                        n3 = 0;
                    }
                    stripInfoVec3.add(object);
                }
                n2 = n5 * n6 + n9;
                if (n3 == 0) continue;
                object = new StripInfo(stripStartInfo, 0, -1);
                n = 0;
                n8 = 1;
                while (n < n3) {
                    if (!Stripifier.isDegenerate(stripInfoVec.at((int)i).m_faces.at(n2))) {
                        ++n;
                        n8 = 0;
                        ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n2++));
                        continue;
                    }
                    if (n8 == 0) {
                        ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n2++));
                        continue;
                    }
                    ++n2;
                }
                stripInfoVec3.add(object);
                continue;
            }
            object = new StripInfo(stripStartInfo, 0, -1);
            for (n5 = 0; n5 < stripInfoVec.at((int)i).m_faces.size(); ++n5) {
                ((StripInfo)object).m_faces.add(stripInfoVec.at((int)i).m_faces.at(n5));
            }
            stripInfoVec3.add(object);
        }
        StripInfoVec stripInfoVec4 = new StripInfoVec();
        this.removeSmallStrips(stripInfoVec3, stripInfoVec4, faceInfoVec);
        stripInfoVec2.clear();
        if (stripInfoVec4.size() != 0) {
            object = new VertexCache(this.cacheSize);
            float f = -1.0f;
            n4 = -99999;
            n3 = 0;
            float f2 = 10000.0f;
            for (n2 = 0; n2 < stripInfoVec4.size(); ++n2) {
                n = 0;
                for (n5 = 0; n5 < stripInfoVec4.at((int)n2).m_faces.size(); ++n5) {
                    n += Stripifier.numNeighbors(stripInfoVec4.at((int)n2).m_faces.at(n5), edgeInfoVec);
                }
                float f3 = (float)n / (float)stripInfoVec4.at((int)n2).m_faces.size();
                if (!(f3 < f2)) continue;
                f2 = f3;
                n3 = n2;
            }
            Stripifier.updateCacheStrip((VertexCache)object, stripInfoVec4.at(n3));
            stripInfoVec2.add(stripInfoVec4.at(n3));
            stripInfoVec4.at((int)n3).visited = true;
            n2 = stripInfoVec4.at((int)n3).m_faces.size() % 2 == 0 ? 1 : 0;
            while (true) {
                f = -1.0f;
                for (n = 0; n < stripInfoVec4.size(); ++n) {
                    if (stripInfoVec4.at((int)n).visited) continue;
                    float f4 = Stripifier.calcNumHitsStrip((VertexCache)object, stripInfoVec4.at(n));
                    if (f4 > f) {
                        f = f4;
                        n4 = n;
                        continue;
                    }
                    if (!(f4 >= f)) continue;
                    StripInfo stripInfo = stripInfoVec4.at(n);
                    int n10 = stripInfo.m_faces.size();
                    FaceInfo faceInfo = new FaceInfo(stripInfo.m_faces.at((int)0).m_v0, stripInfo.m_faces.at((int)0).m_v1, stripInfo.m_faces.at((int)0).m_v2);
                    if (n10 > 1) {
                        int n11 = Stripifier.getUniqueVertexInB(stripInfo.m_faces.at(1), faceInfo);
                        if (n11 == faceInfo.m_v1) {
                            int n12 = faceInfo.m_v0;
                            faceInfo.m_v0 = faceInfo.m_v1;
                            faceInfo.m_v1 = n12;
                        } else if (n11 == faceInfo.m_v2) {
                            int n13 = faceInfo.m_v0;
                            faceInfo.m_v0 = faceInfo.m_v2;
                            faceInfo.m_v2 = n13;
                        }
                        if (n10 > 2) {
                            int[] nArray = new int[2];
                            Stripifier.getSharedVertices(stripInfo.m_faces.at(2), faceInfo, nArray);
                            if (nArray[0] == faceInfo.m_v1 && nArray[1] == -1) {
                                int n14 = faceInfo.m_v2;
                                faceInfo.m_v2 = faceInfo.m_v1;
                                faceInfo.m_v1 = n14;
                            }
                        }
                    }
                    if (n2 != Stripifier.isCW(stripInfo.m_faces.at(0), faceInfo.m_v0, faceInfo.m_v1)) continue;
                    n4 = n;
                }
                if (f == -1.0f) break;
                stripInfoVec4.at((int)n4).visited = true;
                Stripifier.updateCacheStrip((VertexCache)object, stripInfoVec4.at(n4));
                stripInfoVec2.add(stripInfoVec4.at(n4));
                n2 = stripInfoVec4.at((int)n4).m_faces.size() % 2 == 0 ? n2 : (n2 == 0 ? 1 : 0);
            }
        }
    }

    void stripify(IntVec intVec, int n, int n2, int n3, StripInfoVec stripInfoVec, FaceInfoVec faceInfoVec) {
        this.meshJump = 0.0f;
        this.bFirstTimeResetPoint = true;
        int n4 = 10;
        this.cacheSize = Math.max(1, n - CACHE_INEFFICIENCY);
        this.minStripLength = n2;
        this.indices = intVec;
        FaceInfoVec faceInfoVec2 = new FaceInfoVec();
        EdgeInfoVec edgeInfoVec = new EdgeInfoVec();
        this.buildStripifyInfo(faceInfoVec2, edgeInfoVec, n3);
        StripInfoVec stripInfoVec2 = new StripInfoVec();
        this.findAllStrips(stripInfoVec2, faceInfoVec2, edgeInfoVec, n4);
        this.splitUpStripsAndOptimize(stripInfoVec2, stripInfoVec, edgeInfoVec, faceInfoVec);
    }
}

