/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom.nvtristrip;

public class PrimitiveGroup {
    public static final int PT_LIST = 0;
    public static final int PT_STRIP = 1;
    public static final int PT_FAN = 2;
    public int type = 1;
    public int[] indices;
    public int numIndices;

    public String getTypeString() {
        switch (this.type) {
            case 0: {
                return "list";
            }
            case 1: {
                return "strip";
            }
            case 2: {
                return "fan";
            }
        }
        return "????";
    }

    public String toString() {
        return this.getTypeString() + " : " + this.numIndices;
    }

    public String getFullInfo() {
        if (this.type != 1) {
            return this.toString();
        }
        int[] nArray = new int[this.numIndices];
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.numIndices; ++i) {
            if (this.indices[i] == n) {
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                n2 = -1;
                n = -1;
                continue;
            }
            n = this.indices[i];
            ++n2;
        }
        int n4 = n2;
        nArray[n4] = nArray[n4] + 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Strip:").append(this.numIndices).append("\n");
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            stringBuffer.append(i).append("->").append(nArray[i]).append("\n");
        }
        return stringBuffer.toString();
    }

    public int[] getTrimmedIndices() {
        if (this.indices.length == this.numIndices) {
            return this.indices;
        }
        int[] nArray = new int[this.numIndices];
        System.arraycopy(this.indices, 0, nArray, 0, this.numIndices);
        return nArray;
    }
}

