/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.geom;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;

public class NormalGenerator {
    private static final Logger logger = Logger.getLogger(NormalGenerator.class.getName());
    private float creaseAngle;
    private Vector3f[] sourceVerts;
    private ColorRGBA[] sourceColors;
    private Vector2f[] sourceTexCoords;
    private int[] sourceInds;
    private LinkedList<Triangle> triangles;
    private ArrayList<Vector3f> destVerts;
    private ArrayList<ColorRGBA> destColors;
    private ArrayList<Vector2f> destTexCoords;
    private LinkedList<Triangle> destTris;
    private LinkedList<Edge> edges;
    private LinkedList<LinkedList<Triangle>> splitMeshes;
    private LinkedList<LinkedList<Edge>> splitMeshBorders;
    private Vector3f[] splitVerts;
    private ColorRGBA[] splitColors;
    private Vector2f[] splitTexCoords;
    private Vector3f[] splitNormals;
    private int[] splitIndices;
    private boolean[] borderIndices;
    private Vector3f compVect0 = new Vector3f();
    private Vector3f compVect1 = new Vector3f();

    public void generateNormals(TriMesh triMesh, float f) {
        this.creaseAngle = f;
        for (int i = 0; i < triMesh.getBatchCount(); ++i) {
            this.generateNormals(triMesh.getBatch(i));
            this.cleanup();
        }
    }

    public void generateNormals(TriangleBatch triangleBatch, float f) {
        if (triangleBatch != null) {
            this.creaseAngle = f;
            this.generateNormals(triangleBatch);
            this.cleanup();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateNormals(TriangleBatch triangleBatch) {
        void var4_9;
        IntBuffer intBuffer;
        int n;
        if (triangleBatch.getMode() != 1) {
            logger.info("Invalid triangles mode in " + triangleBatch);
            return;
        }
        this.sourceInds = BufferUtils.getIntArray(triangleBatch.getIndexBuffer());
        this.sourceVerts = BufferUtils.getVector3Array(triangleBatch.getVertexBuffer());
        this.sourceColors = triangleBatch.getColorBuffer() != null ? BufferUtils.getColorArray(triangleBatch.getColorBuffer()) : null;
        this.sourceTexCoords = triangleBatch.getTextureBuffer(0) != null ? BufferUtils.getVector2Array(triangleBatch.getTextureBuffer(0)) : null;
        this.initialize();
        while (!this.triangles.isEmpty()) {
            this.createMeshSplit();
        }
        if (!this.splitMeshes.isEmpty()) {
            this.borderIndices = new boolean[this.sourceVerts.length];
            this.fillBorderIndices();
            this.duplicateCreaseVertices();
        }
        this.splitVerts = this.destVerts.toArray(new Vector3f[this.destVerts.size()]);
        this.splitColors = this.destColors != null ? this.destColors.toArray(new ColorRGBA[this.destColors.size()]) : null;
        this.splitTexCoords = this.destTexCoords != null ? this.destTexCoords.toArray(new Vector2f[this.destTexCoords.size()]) : null;
        this.splitNormals = new Vector3f[this.destVerts.size()];
        for (n = 0; n < this.splitNormals.length; ++n) {
            this.splitNormals[n] = new Vector3f();
        }
        n = 0;
        for (LinkedList object2 : this.splitMeshes) {
            n += object2.size();
        }
        this.splitIndices = new int[n * 3];
        this.computeNormalsAndIndices();
        Object object3 = triangleBatch.getVertexBuffer();
        if (((Buffer)object3).capacity() < this.splitVerts.length * 3) {
            object3 = BufferUtils.createFloatBuffer(this.splitVerts);
        } else {
            ((FloatBuffer)object3).clear();
            for (Vector3f vector3f : this.splitVerts) {
                ((FloatBuffer)object3).put(vector3f.x).put(vector3f.y).put(vector3f.z);
            }
            ((FloatBuffer)object3).flip();
        }
        FloatBuffer floatBuffer = triangleBatch.getNormalBuffer();
        if (floatBuffer == null || floatBuffer.capacity() < this.splitNormals.length * 3) {
            FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(this.splitNormals);
        } else {
            floatBuffer.clear();
            for (Vector3f vector3f : this.splitNormals) {
                floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
            }
            floatBuffer.flip();
        }
        FloatBuffer floatBuffer3 = null;
        if (this.splitColors != null) {
            floatBuffer3 = triangleBatch.getColorBuffer();
            if (floatBuffer3.capacity() < this.splitColors.length * 4) {
                floatBuffer3 = BufferUtils.createFloatBuffer(this.splitColors);
            } else {
                floatBuffer3.clear();
                for (ColorRGBA colorRGBA : this.splitColors) {
                    floatBuffer3.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
                }
                floatBuffer3.flip();
            }
        }
        FloatBuffer floatBuffer4 = null;
        if (this.splitTexCoords != null) {
            floatBuffer4 = triangleBatch.getTextureBuffer(0);
            if (floatBuffer4.capacity() < this.splitTexCoords.length * 2) {
                floatBuffer4 = BufferUtils.createFloatBuffer(this.splitTexCoords);
            } else {
                floatBuffer4.clear();
                for (Vector2f vector2f : this.splitTexCoords) {
                    floatBuffer4.put(vector2f.x).put(vector2f.y);
                }
                floatBuffer4.flip();
            }
        }
        if ((intBuffer = triangleBatch.getIndexBuffer()).capacity() < this.splitIndices.length) {
            intBuffer = BufferUtils.createIntBuffer(this.splitIndices);
        } else {
            intBuffer.clear();
            intBuffer.put(this.splitIndices);
            intBuffer.flip();
        }
        triangleBatch.setVertexBuffer((FloatBuffer)object3);
        triangleBatch.setNormalBuffer((FloatBuffer)var4_9);
        triangleBatch.setColorBuffer(floatBuffer3);
        triangleBatch.getTextureBuffers().clear();
        triangleBatch.setTextureBuffer(floatBuffer4, 0);
        triangleBatch.setIndexBuffer(intBuffer);
        triangleBatch.setHasDirtyVertices(true);
    }

    private void initialize() {
        int n;
        this.destVerts = new ArrayList(this.sourceVerts.length);
        for (n = 0; n < this.sourceVerts.length; ++n) {
            this.destVerts.add(this.sourceVerts[n]);
        }
        if (this.sourceColors != null) {
            this.destColors = new ArrayList(this.sourceColors.length);
            for (n = 0; n < this.sourceColors.length; ++n) {
                this.destColors.add(this.sourceColors[n]);
            }
        } else {
            this.destColors = null;
        }
        if (this.sourceTexCoords != null) {
            this.destTexCoords = new ArrayList(this.sourceTexCoords.length);
            for (n = 0; n < this.sourceTexCoords.length; ++n) {
                this.destTexCoords.add(this.sourceTexCoords[n]);
            }
        } else {
            this.destTexCoords = null;
        }
        this.triangles = new LinkedList();
        n = 0;
        while (n * 3 < this.sourceInds.length) {
            Triangle triangle = new Triangle(this.sourceInds[n * 3 + 0], this.sourceInds[n * 3 + 1], this.sourceInds[n * 3 + 2]);
            triangle.computeNormal(this.sourceVerts);
            this.triangles.add(triangle);
            ++n;
        }
        if (this.splitMeshes == null) {
            this.splitMeshes = new LinkedList();
        } else {
            this.splitMeshes.clear();
        }
        if (this.splitMeshBorders == null) {
            this.splitMeshBorders = new LinkedList();
        } else {
            this.splitMeshBorders.clear();
        }
    }

    private void createMeshSplit() {
        Triangle triangle;
        this.destTris = new LinkedList();
        this.edges = new LinkedList();
        Triangle triangle2 = this.triangles.removeFirst();
        this.destTris.addLast(triangle2);
        this.edges.addLast(triangle2.edges[0]);
        this.edges.addLast(triangle2.edges[1]);
        this.edges.addLast(triangle2.edges[2]);
        while ((triangle = this.insertTriangle()) != null) {
        }
        this.splitMeshes.addLast(this.destTris);
        this.splitMeshBorders.addLast(this.edges);
    }

    private Triangle insertTriangle() {
        int n;
        Object object;
        ListIterator listIterator = this.triangles.listIterator();
        ListIterator<Edge> listIterator2 = null;
        Object object2 = null;
        int n2 = -1;
        Edge edge = null;
        while (object2 == null && listIterator.hasNext()) {
            object = (Triangle)listIterator.next();
            listIterator2 = this.edges.listIterator();
            while (object2 == null && listIterator2.hasNext()) {
                edge = (Edge)listIterator2.next();
                for (n = 0; n < ((Triangle)object).edges.length && object2 == null; ++n) {
                    if (!edge.isConnectedTo(((Triangle)object).edges[n]) || !this.checkAngle((Triangle)object, edge.parent)) continue;
                    n2 = n;
                    object2 = object;
                }
            }
        }
        if (object2 != null) {
            listIterator.remove();
            this.destTris.addLast((Triangle)object2);
            edge.connected = object2;
            object = ((Triangle)object2).edges[n2];
            ((Edge)object).connected = edge.parent;
            listIterator2.remove();
            listIterator2.add(((Triangle)object2).edges[(n2 + 1) % 3]);
            listIterator2.add(((Triangle)object2).edges[(n2 + 2) % 3]);
            if (edge.newI0 > -1) {
                ((Edge)object).newI1 = edge.newI0;
                ((Triangle)object2).edges[(n2 + 1) % 3].newI0 = edge.newI0;
            }
            if (edge.newI1 > -1) {
                ((Edge)object).newI0 = edge.newI1;
                ((Triangle)object2).edges[(n2 + 2) % 3].newI1 = edge.newI1;
            }
            for (n = n2 + 1; n < n2 + 3; ++n) {
                this.connectEdge((Triangle)object2, n % 3);
            }
        }
        return object2;
    }

    private void connectEdge(Triangle triangle, int n) {
        Edge edge = triangle.edges[n];
        ListIterator listIterator = this.edges.listIterator();
        boolean bl = false;
        while (!bl && listIterator.hasNext()) {
            Edge edge2 = (Edge)listIterator.next();
            if (!edge2.isConnectedTo(edge)) continue;
            bl = true;
            listIterator.remove();
            this.edges.remove(edge);
            if (!this.checkAngle(triangle, edge2.parent)) {
                this.duplicateValues(edge.i0);
                triangle.edges[(n + 2) % 3].newI1 = edge.newI0 = this.destVerts.size() - 1;
                this.duplicateValues(edge.i1);
                triangle.edges[(n + 1) % 3].newI0 = edge.newI1 = this.destVerts.size() - 1;
                continue;
            }
            if (edge2.newI0 > -1) {
                edge.newI1 = edge2.newI0;
                triangle.edges[(n + 1) % 3].newI0 = edge2.newI0;
            }
            if (edge2.newI1 <= -1) continue;
            edge.newI0 = edge2.newI1;
            triangle.edges[(n + 2) % 3].newI1 = edge2.newI1;
        }
    }

    private boolean checkAngle(Triangle triangle, Triangle triangle2) {
        return triangle.normal.angleBetween(triangle2.normal) <= this.creaseAngle + 1.0E-4f;
    }

    private void duplicateValues(int n) {
        this.destVerts.add(this.destVerts.get(n));
        if (this.destColors != null) {
            this.destColors.add(this.destColors.get(n));
        }
        if (this.destTexCoords != null) {
            this.destTexCoords.add(this.destTexCoords.get(n));
        }
    }

    private void fillBorderIndices() {
        Arrays.fill(this.borderIndices, false);
        LinkedList<Edge> linkedList = this.splitMeshBorders.getFirst();
        for (Edge edge : linkedList) {
            this.borderIndices[edge.i0] = true;
            this.borderIndices[edge.i1] = true;
        }
    }

    private void duplicateCreaseVertices() {
        if (this.splitMeshBorders.size() < 2) {
            return;
        }
        int[] nArray = new int[this.sourceVerts.length];
        ListIterator listIterator = this.splitMeshBorders.listIterator();
        listIterator.next();
        ListIterator listIterator2 = this.splitMeshes.listIterator();
        listIterator2.next();
        while (listIterator.hasNext()) {
            Arrays.fill(nArray, -1);
            LinkedList linkedList = (LinkedList)listIterator.next();
            LinkedList linkedList2 = (LinkedList)listIterator2.next();
            ListIterator listIterator3 = linkedList.listIterator();
            while (listIterator3.hasNext()) {
                Edge edge = (Edge)listIterator3.next();
                if (edge.newI0 == -1) {
                    if (this.borderIndices[edge.i0]) {
                        if (nArray[edge.i0] == -1) {
                            this.duplicateValues(edge.i0);
                            nArray[edge.i0] = this.destVerts.size() - 1;
                        }
                    } else {
                        nArray[edge.i0] = edge.i0;
                    }
                }
                if (edge.newI1 != -1) continue;
                if (this.borderIndices[edge.i1]) {
                    if (nArray[edge.i1] != -1) continue;
                    this.duplicateValues(edge.i1);
                    nArray[edge.i1] = this.destVerts.size() - 1;
                    continue;
                }
                nArray[edge.i1] = edge.i1;
            }
            for (int i = 0; i < this.borderIndices.length; ++i) {
                if (this.borderIndices[i]) {
                    for (Triangle triangle : linkedList2) {
                        this.replaceIndex(triangle, i, nArray[i]);
                    }
                    continue;
                }
                if (nArray[i] <= -1) continue;
                this.borderIndices[i] = true;
            }
        }
    }

    private void replaceIndex(Triangle triangle, int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            Edge edge = triangle.edges[i];
            if (edge.newI0 == -1 && edge.i0 == n) {
                edge.newI0 = n2;
            }
            if (edge.newI1 != -1 || edge.i1 != n) continue;
            edge.newI1 = n2;
        }
    }

    private void computeNormalsAndIndices() {
        int n = 0;
        for (LinkedList linkedList : this.splitMeshes) {
            for (Triangle triangle : linkedList) {
                for (int i = 0; i < 3; ++i) {
                    if (triangle.edges[i].newI0 > -1) {
                        this.splitNormals[triangle.edges[i].newI0].addLocal(triangle.normal);
                        this.splitIndices[n++] = triangle.edges[i].newI0;
                        continue;
                    }
                    this.splitNormals[triangle.edges[i].i0].addLocal(triangle.normal);
                    this.splitIndices[n++] = triangle.edges[i].i0;
                }
            }
        }
        for (int i = 0; i < this.splitNormals.length; ++i) {
            if (!(this.splitNormals[i].distanceSquared(Vector3f.ZERO) > 1.0E-4f)) continue;
            this.splitNormals[i].normalizeLocal();
        }
    }

    private void cleanup() {
        this.creaseAngle = 0.0f;
        Arrays.fill(this.sourceVerts, null);
        this.sourceVerts = null;
        if (this.sourceColors != null) {
            Arrays.fill(this.sourceColors, null);
            this.sourceColors = null;
        }
        if (this.sourceTexCoords != null) {
            Arrays.fill(this.sourceTexCoords, null);
            this.sourceTexCoords = null;
        }
        this.sourceInds = null;
        if (this.triangles != null) {
            this.triangles.clear();
            this.triangles = null;
        }
        if (this.destVerts != null) {
            this.destVerts.clear();
            this.destVerts = null;
        }
        if (this.destColors != null) {
            this.destColors.clear();
            this.destColors = null;
        }
        if (this.destTexCoords != null) {
            this.destTexCoords.clear();
            this.destTexCoords = null;
        }
        if (this.destTris != null) {
            this.destTris.clear();
            this.destTris = null;
        }
        if (this.edges != null) {
            this.edges.clear();
            this.edges = null;
        }
        if (this.splitMeshes != null) {
            for (LinkedList linkedList : this.splitMeshes) {
                linkedList.clear();
            }
            this.splitMeshes.clear();
            this.splitMeshes = null;
        }
        if (this.splitMeshBorders != null) {
            for (LinkedList linkedList : this.splitMeshBorders) {
                linkedList.clear();
            }
            this.splitMeshBorders.clear();
            this.splitMeshBorders = null;
        }
        this.splitVerts = null;
        this.splitNormals = null;
        this.splitColors = null;
        this.splitTexCoords = null;
        this.splitIndices = null;
        this.borderIndices = null;
    }

    private class Edge {
        public int i0;
        public int i1;
        public int newI0 = -1;
        public int newI1 = -1;
        public Triangle parent;
        public Triangle connected;

        public Edge() {
        }

        public Edge(Triangle triangle, int n, int n2) {
            this.parent = triangle;
            this.i0 = n;
            this.i1 = n2;
        }

        public boolean isConnectedTo(Edge edge) {
            return this.i0 == edge.i1 && this.i1 == edge.i0;
        }

        public String toString() {
            String string = "Edge (";
            string = this.newI0 > -1 ? string + this.newI0 : string + this.i0;
            string = string + ", ";
            string = this.newI1 > -1 ? string + this.newI1 : string + this.i1;
            string = string + ")";
            return string;
        }
    }

    private class Triangle {
        public Edge[] edges = new Edge[3];
        public Vector3f normal = new Vector3f(0.0f, 0.0f, 0.0f);

        public Triangle() {
        }

        public Triangle(int n, int n2, int n3) {
            this.edges[0] = new Edge(this, n, n2);
            this.edges[1] = new Edge(this, n2, n3);
            this.edges[2] = new Edge(this, n3, n);
        }

        public void computeNormal(Vector3f[] vector3fArray) {
            int n = this.edges[0].i0;
            int n2 = this.edges[1].i0;
            int n3 = this.edges[2].i0;
            vector3fArray[n3].subtract(vector3fArray[n2], NormalGenerator.this.compVect0);
            vector3fArray[n].subtract(vector3fArray[n2], NormalGenerator.this.compVect1);
            this.normal.set(NormalGenerator.this.compVect0.crossLocal(NormalGenerator.this.compVect1)).normalizeLocal();
        }

        public int indexOf(Edge edge) {
            for (int i = 0; i < 3; ++i) {
                if (this.edges[i] != edge) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            String string = "Triangle (";
            for (int i = 0; i < 3; ++i) {
                Edge edge = this.edges[i];
                string = edge == null ? string + "?" : (edge.newI0 > -1 ? string + edge.newI0 : string + edge.i0);
                if (i >= 2) continue;
                string = string + ", ";
            }
            string = string + ")";
            return string;
        }
    }
}

