/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export.binary;

import com.jme.util.export.ByteUtils;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryClassField;
import com.jme.util.export.binary.BinaryClassObject;
import com.jme.util.export.binary.BinaryExporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOutputCapsule
implements OutputCapsule {
    public static final int NULL_OBJECT = -1;
    public static final int DEFAULT_OBJECT = -2;
    public static byte[] NULL_BYTES = new byte[]{-1};
    public static byte[] DEFAULT_BYTES = new byte[]{-2};
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected byte[] bytes;
    protected BinaryExporter exporter;
    protected BinaryClassObject cObj;

    public BinaryOutputCapsule(BinaryExporter binaryExporter, BinaryClassObject binaryClassObject) {
        this.exporter = binaryExporter;
        this.cObj = binaryClassObject;
    }

    @Override
    public void write(byte by, String string, byte by2) throws IOException {
        if (by == by2) {
            return;
        }
        this.writeAlias(string, (byte)0);
        this.write(by);
    }

    @Override
    public void write(byte[] byArray, String string, byte[] byArray2) throws IOException {
        if (byArray == byArray2) {
            return;
        }
        this.writeAlias(string, (byte)1);
        this.write(byArray);
    }

    @Override
    public void write(byte[][] byArray, String string, byte[][] byArray2) throws IOException {
        if (byArray == byArray2) {
            return;
        }
        this.writeAlias(string, (byte)2);
        this.write(byArray);
    }

    @Override
    public void write(int n, String string, int n2) throws IOException {
        if (n == n2) {
            return;
        }
        this.writeAlias(string, (byte)10);
        this.write(n);
    }

    @Override
    public void write(int[] nArray, String string, int[] nArray2) throws IOException {
        if (nArray == nArray2) {
            return;
        }
        this.writeAlias(string, (byte)11);
        this.write(nArray);
    }

    @Override
    public void write(int[][] nArray, String string, int[][] nArray2) throws IOException {
        if (nArray == nArray2) {
            return;
        }
        this.writeAlias(string, (byte)12);
        this.write(nArray);
    }

    @Override
    public void write(float f, String string, float f2) throws IOException {
        if (f == f2) {
            return;
        }
        this.writeAlias(string, (byte)20);
        this.write(f);
    }

    @Override
    public void write(float[] fArray, String string, float[] fArray2) throws IOException {
        if (fArray == fArray2) {
            return;
        }
        this.writeAlias(string, (byte)21);
        this.write(fArray);
    }

    @Override
    public void write(float[][] fArray, String string, float[][] fArray2) throws IOException {
        if (fArray == fArray2) {
            return;
        }
        this.writeAlias(string, (byte)22);
        this.write(fArray);
    }

    @Override
    public void write(double d, String string, double d2) throws IOException {
        if (d == d2) {
            return;
        }
        this.writeAlias(string, (byte)30);
        this.write(d);
    }

    @Override
    public void write(double[] dArray, String string, double[] dArray2) throws IOException {
        if (dArray == dArray2) {
            return;
        }
        this.writeAlias(string, (byte)31);
        this.write(dArray);
    }

    @Override
    public void write(double[][] dArray, String string, double[][] dArray2) throws IOException {
        if (dArray == dArray2) {
            return;
        }
        this.writeAlias(string, (byte)32);
        this.write(dArray);
    }

    @Override
    public void write(long l, String string, long l2) throws IOException {
        if (l == l2) {
            return;
        }
        this.writeAlias(string, (byte)40);
        this.write(l);
    }

    @Override
    public void write(long[] lArray, String string, long[] lArray2) throws IOException {
        if (lArray == lArray2) {
            return;
        }
        this.writeAlias(string, (byte)41);
        this.write(lArray);
    }

    @Override
    public void write(long[][] lArray, String string, long[][] lArray2) throws IOException {
        if (lArray == lArray2) {
            return;
        }
        this.writeAlias(string, (byte)42);
        this.write(lArray);
    }

    @Override
    public void write(short s, String string, short s2) throws IOException {
        if (s == s2) {
            return;
        }
        this.writeAlias(string, (byte)50);
        this.write(s);
    }

    @Override
    public void write(short[] sArray, String string, short[] sArray2) throws IOException {
        if (sArray == sArray2) {
            return;
        }
        this.writeAlias(string, (byte)51);
        this.write(sArray);
    }

    @Override
    public void write(short[][] sArray, String string, short[][] sArray2) throws IOException {
        if (sArray == sArray2) {
            return;
        }
        this.writeAlias(string, (byte)52);
        this.write(sArray);
    }

    @Override
    public void write(boolean bl, String string, boolean bl2) throws IOException {
        if (bl == bl2) {
            return;
        }
        this.writeAlias(string, (byte)60);
        this.write(bl);
    }

    @Override
    public void write(boolean[] blArray, String string, boolean[] blArray2) throws IOException {
        if (blArray == blArray2) {
            return;
        }
        this.writeAlias(string, (byte)61);
        this.write(blArray);
    }

    @Override
    public void write(boolean[][] blArray, String string, boolean[][] blArray2) throws IOException {
        if (blArray == blArray2) {
            return;
        }
        this.writeAlias(string, (byte)62);
        this.write(blArray);
    }

    @Override
    public void write(String string, String string2, String string3) throws IOException {
        if (string == null ? string3 == null : string.equals(string3)) {
            return;
        }
        this.writeAlias(string2, (byte)70);
        this.write(string);
    }

    @Override
    public void write(String[] stringArray, String string, String[] stringArray2) throws IOException {
        if (stringArray == stringArray2) {
            return;
        }
        this.writeAlias(string, (byte)71);
        this.write(stringArray);
    }

    @Override
    public void write(String[][] stringArray, String string, String[][] stringArray2) throws IOException {
        if (stringArray == stringArray2) {
            return;
        }
        this.writeAlias(string, (byte)72);
        this.write(stringArray);
    }

    @Override
    public void write(BitSet bitSet, String string, BitSet bitSet2) throws IOException {
        if (bitSet == bitSet2) {
            return;
        }
        this.writeAlias(string, (byte)80);
        this.write(bitSet);
    }

    @Override
    public void write(Savable savable, String string, Savable savable2) throws IOException {
        if (savable == savable2) {
            return;
        }
        this.writeAlias(string, (byte)90);
        this.write(savable);
    }

    @Override
    public void write(Savable[] savableArray, String string, Savable[] savableArray2) throws IOException {
        if (savableArray == savableArray2) {
            return;
        }
        this.writeAlias(string, (byte)91);
        this.write(savableArray);
    }

    @Override
    public void write(Savable[][] savableArray, String string, Savable[][] savableArray2) throws IOException {
        if (savableArray == savableArray2) {
            return;
        }
        this.writeAlias(string, (byte)92);
        this.write(savableArray);
    }

    @Override
    public void write(FloatBuffer floatBuffer, String string, FloatBuffer floatBuffer2) throws IOException {
        if (floatBuffer == floatBuffer2) {
            return;
        }
        this.writeAlias(string, (byte)120);
        this.write(floatBuffer);
    }

    @Override
    public void write(IntBuffer intBuffer, String string, IntBuffer intBuffer2) throws IOException {
        if (intBuffer == intBuffer2) {
            return;
        }
        this.writeAlias(string, (byte)121);
        this.write(intBuffer);
    }

    @Override
    public void write(ByteBuffer byteBuffer, String string, ByteBuffer byteBuffer2) throws IOException {
        if (byteBuffer == byteBuffer2) {
            return;
        }
        this.writeAlias(string, (byte)122);
        this.write(byteBuffer);
    }

    @Override
    public void write(ShortBuffer shortBuffer, String string, ShortBuffer shortBuffer2) throws IOException {
        if (shortBuffer == shortBuffer2) {
            return;
        }
        this.writeAlias(string, (byte)123);
        this.write(shortBuffer);
    }

    @Override
    public void writeFloatBufferArrayList(ArrayList<FloatBuffer> arrayList, String string, ArrayList<FloatBuffer> arrayList2) throws IOException {
        if (arrayList == arrayList2) {
            return;
        }
        this.writeAlias(string, (byte)110);
        this.writeFloatBufferArrayList(arrayList);
    }

    @Override
    public void writeSavableArrayList(ArrayList arrayList, String string, ArrayList arrayList2) throws IOException {
        if (arrayList == arrayList2) {
            return;
        }
        this.writeAlias(string, (byte)100);
        this.writeSavableArrayList(arrayList);
    }

    @Override
    public void writeSavableArrayListArray(ArrayList[] arrayListArray, String string, ArrayList[] arrayListArray2) throws IOException {
        if (arrayListArray == arrayListArray2) {
            return;
        }
        this.writeAlias(string, (byte)101);
        this.writeSavableArrayListArray(arrayListArray);
    }

    @Override
    public void writeSavableArrayListArray2D(ArrayList[][] arrayListArray, String string, ArrayList[][] arrayListArray2) throws IOException {
        if (arrayListArray == arrayListArray2) {
            return;
        }
        this.writeAlias(string, (byte)102);
        this.writeSavableArrayListArray2D(arrayListArray);
    }

    @Override
    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String string, Map<? extends Savable, ? extends Savable> map2) throws IOException {
        if (map == map2) {
            return;
        }
        this.writeAlias(string, (byte)105);
        this.writeSavableMap(map);
    }

    @Override
    public void writeStringSavableMap(Map<String, ? extends Savable> map, String string, Map<String, ? extends Savable> map2) throws IOException {
        if (map == map2) {
            return;
        }
        this.writeAlias(string, (byte)106);
        this.writeStringSavableMap(map);
    }

    protected void writeAlias(String string, byte by) throws IOException {
        if (this.cObj.nameFields.get(string) == null) {
            this.generateAlias(string, by);
        }
        byte by2 = this.cObj.nameFields.get((Object)string).alias;
        this.write(by2);
    }

    protected void generateAlias(String string, byte by) {
        byte by2 = (byte)this.cObj.nameFields.size();
        this.cObj.nameFields.put(string, new BinaryClassField(string, by2, by));
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinaryOutputCapsule)) {
            return false;
        }
        byte[] byArray = ((BinaryOutputCapsule)object).bytes;
        if (this.bytes.length != byArray.length) {
            return false;
        }
        return Arrays.equals(this.bytes, byArray);
    }

    public void finish() {
        this.bytes = this.baos.toByteArray();
        this.baos = null;
    }

    protected void write(byte by) throws IOException {
        this.baos.write(by);
    }

    protected void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.write(-1);
            return;
        }
        this.write(byArray.length);
        this.baos.write(byArray);
    }

    protected void write(byte[][] byArray) throws IOException {
        if (byArray == null) {
            this.write(-1);
            return;
        }
        this.write(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.write(byArray[i]);
        }
    }

    protected void write(int n) throws IOException {
        this.baos.write(BinaryOutputCapsule.deflate(ByteUtils.convertToBytes(n)));
    }

    protected void write(int[] nArray) throws IOException {
        if (nArray == null) {
            this.write(-1);
            return;
        }
        this.write(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.write(nArray[i]);
        }
    }

    protected void write(int[][] nArray) throws IOException {
        if (nArray == null) {
            this.write(-1);
            return;
        }
        this.write(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.write(nArray[i]);
        }
    }

    protected void write(float f) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(f));
    }

    protected void write(float[] fArray) throws IOException {
        if (fArray == null) {
            this.write(-1);
            return;
        }
        this.write(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.write(fArray[i]);
        }
    }

    protected void write(float[][] fArray) throws IOException {
        if (fArray == null) {
            this.write(-1);
            return;
        }
        this.write(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.write(fArray[i]);
        }
    }

    protected void write(double d) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(d));
    }

    protected void write(double[] dArray) throws IOException {
        if (dArray == null) {
            this.write(-1);
            return;
        }
        this.write(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.write(dArray[i]);
        }
    }

    protected void write(double[][] dArray) throws IOException {
        if (dArray == null) {
            this.write(-1);
            return;
        }
        this.write(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.write(dArray[i]);
        }
    }

    protected void write(long l) throws IOException {
        this.baos.write(BinaryOutputCapsule.deflate(ByteUtils.convertToBytes(l)));
    }

    protected void write(long[] lArray) throws IOException {
        if (lArray == null) {
            this.write(-1);
            return;
        }
        this.write(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            this.write(lArray[i]);
        }
    }

    protected void write(long[][] lArray) throws IOException {
        if (lArray == null) {
            this.write(-1);
            return;
        }
        this.write(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            this.write(lArray[i]);
        }
    }

    protected void write(short s) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(s));
    }

    protected void write(short[] sArray) throws IOException {
        if (sArray == null) {
            this.write(-1);
            return;
        }
        this.write(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            this.write(sArray[i]);
        }
    }

    protected void write(short[][] sArray) throws IOException {
        if (sArray == null) {
            this.write(-1);
            return;
        }
        this.write(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            this.write(sArray[i]);
        }
    }

    protected void write(boolean bl) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(bl));
    }

    protected void write(boolean[] blArray) throws IOException {
        if (blArray == null) {
            this.write(-1);
            return;
        }
        this.write(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            this.write(blArray[i]);
        }
    }

    protected void write(boolean[][] blArray) throws IOException {
        if (blArray == null) {
            this.write(-1);
            return;
        }
        this.write(blArray.length);
        for (int i = 0; i < blArray.length; ++i) {
            this.write(blArray[i]);
        }
    }

    protected void write(String string) throws IOException {
        if (string == null) {
            this.write(-1);
            return;
        }
        byte[] byArray = string.getBytes("UTF8");
        this.write(byArray.length);
        this.baos.write(byArray);
    }

    protected void write(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.write(-1);
            return;
        }
        this.write(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.write(stringArray[i]);
        }
    }

    protected void write(String[][] stringArray) throws IOException {
        if (stringArray == null) {
            this.write(-1);
            return;
        }
        this.write(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.write(stringArray[i]);
        }
    }

    protected void write(BitSet bitSet) throws IOException {
        if (bitSet == null) {
            this.write(-1);
            return;
        }
        this.write(bitSet.size());
        int n = bitSet.size();
        for (int i = 0; i < n; ++i) {
            this.write(bitSet.get(i));
        }
    }

    protected static byte[] deflate(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 == 4) {
            n = ByteUtils.convertIntFromBytes(byArray);
            if (n == -1) {
                return NULL_BYTES;
            }
            if (n == -2) {
                return DEFAULT_BYTES;
            }
        }
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
            --n2;
        }
        if (n2 == 0) {
            return new byte[1];
        }
        byte[] byArray2 = new byte[1 + n2];
        byArray2[0] = (byte)n2;
        for (int i = 1; i < byArray2.length; ++i) {
            byArray2[i] = byArray[byArray.length - n2 - 1 + i];
        }
        return byArray2;
    }

    protected void write(Savable savable) throws IOException {
        if (savable == null) {
            this.write(-1);
            return;
        }
        int n = this.exporter.processBinarySavable(savable);
        this.write(n);
    }

    protected void write(Savable[] savableArray) throws IOException {
        if (savableArray == null) {
            this.write(-1);
            return;
        }
        this.write(savableArray.length);
        for (int i = 0; i < savableArray.length; ++i) {
            this.write(savableArray[i]);
        }
    }

    protected void write(Savable[][] savableArray) throws IOException {
        if (savableArray == null) {
            this.write(-1);
            return;
        }
        this.write(savableArray.length);
        for (int i = 0; i < savableArray.length; ++i) {
            this.write(savableArray[i]);
        }
    }

    protected void writeSavableArrayList(ArrayList arrayList) throws IOException {
        if (arrayList == null) {
            this.write(-1);
            return;
        }
        this.write(arrayList.size());
        for (Object e : arrayList) {
            this.write((Savable)e);
        }
    }

    protected void writeSavableArrayListArray(ArrayList[] arrayListArray) throws IOException {
        if (arrayListArray == null) {
            this.write(-1);
            return;
        }
        this.write(arrayListArray.length);
        for (ArrayList arrayList : arrayListArray) {
            this.writeSavableArrayList(arrayList);
        }
    }

    protected void writeSavableArrayListArray2D(ArrayList[][] arrayListArray) throws IOException {
        if (arrayListArray == null) {
            this.write(-1);
            return;
        }
        this.write(arrayListArray.length);
        for (ArrayList[] arrayListArray2 : arrayListArray) {
            this.writeSavableArrayListArray(arrayListArray2);
        }
    }

    protected void writeSavableMap(Map<? extends Savable, ? extends Savable> map) throws IOException {
        if (map == null) {
            this.write(-1);
            return;
        }
        this.write(map.size());
        for (Savable savable : map.keySet()) {
            this.write(new Savable[]{savable, map.get(savable)});
        }
    }

    protected void writeStringSavableMap(Map<String, ? extends Savable> map) throws IOException {
        if (map == null) {
            this.write(-1);
            return;
        }
        this.write(map.size());
        String[] stringArray = map.keySet().toArray(new String[0]);
        this.write(stringArray);
        Savable[] savableArray = map.values().toArray(new Savable[0]);
        this.write(savableArray);
    }

    protected void writeFloatBufferArrayList(ArrayList arrayList) throws IOException {
        if (arrayList == null) {
            this.write(-1);
            return;
        }
        this.write(arrayList.size());
        for (Object e : arrayList) {
            this.write((FloatBuffer)e);
        }
    }

    protected void write(FloatBuffer floatBuffer) throws IOException {
        if (floatBuffer == null) {
            this.write(-1);
            return;
        }
        floatBuffer.rewind();
        int n = floatBuffer.limit();
        this.write(n);
        for (int i = 0; i < n; ++i) {
            this.write(floatBuffer.get());
        }
        floatBuffer.rewind();
    }

    protected void write(IntBuffer intBuffer) throws IOException {
        if (intBuffer == null) {
            this.write(-1);
            return;
        }
        intBuffer.rewind();
        int n = intBuffer.limit();
        this.write(n);
        for (int i = 0; i < n; ++i) {
            this.write(intBuffer.get());
        }
        intBuffer.rewind();
    }

    protected void write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            this.write(-1);
            return;
        }
        byteBuffer.rewind();
        int n = byteBuffer.limit();
        this.write(n);
        for (int i = 0; i < n; ++i) {
            this.write(byteBuffer.get());
        }
        byteBuffer.rewind();
    }

    protected void write(ShortBuffer shortBuffer) throws IOException {
        if (shortBuffer == null) {
            this.write(-1);
            return;
        }
        shortBuffer.rewind();
        int n = shortBuffer.limit();
        this.write(n);
        for (int i = 0; i < n; ++i) {
            this.write(shortBuffer.get());
        }
        shortBuffer.rewind();
    }
}

