/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.export.binary;

import com.jme.math.FastMath;
import com.jme.util.export.ByteUtils;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.ReadListener;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryClassField;
import com.jme.util.export.binary.BinaryClassLoader;
import com.jme.util.export.binary.BinaryClassObject;
import com.jme.util.export.binary.BinaryInputCapsule;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class BinaryImporter
implements JMEImporter {
    private static final Logger logger = Logger.getLogger(BinaryImporter.class.getName());
    protected HashMap<String, BinaryClassObject> classes;
    protected HashMap<Integer, Savable> contentTable;
    protected IdentityHashMap<Savable, BinaryInputCapsule> capsuleTable;
    protected HashMap<Integer, Integer> locationTable;
    public static boolean debug = false;
    protected byte[] dataArray;
    protected int aliasWidth;

    public static BinaryImporter getInstance() {
        return new BinaryImporter();
    }

    public Savable load(InputStream inputStream) throws IOException {
        return this.load(inputStream, null);
    }

    public Savable load(InputStream inputStream, ReadListener readListener) throws IOException {
        int n;
        int n2;
        int n3;
        this.contentTable = new HashMap();
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(gZIPInputStream);
        int n4 = ByteUtils.readInt(bufferedInputStream);
        int n5 = 4;
        this.aliasWidth = (int)FastMath.log(n4, 256.0f) + 1;
        this.classes = new HashMap(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            String string = this.readString(bufferedInputStream, this.aliasWidth);
            n2 = ByteUtils.readInt(bufferedInputStream);
            String string2 = this.readString(bufferedInputStream, n2);
            BinaryClassObject binaryClassObject = new BinaryClassObject();
            binaryClassObject.alias = string.getBytes();
            binaryClassObject.className = string2;
            int n6 = ByteUtils.readInt(bufferedInputStream);
            n5 += 8 + this.aliasWidth + n2;
            binaryClassObject.nameFields = new HashMap(n6);
            binaryClassObject.aliasFields = new HashMap(n6);
            for (int i = 0; i < n6; ++i) {
                byte by = (byte)bufferedInputStream.read();
                byte by2 = (byte)bufferedInputStream.read();
                int n7 = ByteUtils.readInt(bufferedInputStream);
                String string3 = this.readString(bufferedInputStream, n7);
                BinaryClassField binaryClassField = new BinaryClassField(string3, by, by2);
                binaryClassObject.nameFields.put(string3, binaryClassField);
                binaryClassObject.aliasFields.put(by, binaryClassField);
                n5 += 6 + n7;
            }
            this.classes.put(string, binaryClassObject);
        }
        if (readListener != null) {
            readListener.readBytes(n5);
        }
        n3 = ByteUtils.readInt(bufferedInputStream);
        n5 = 4;
        this.capsuleTable = new IdentityHashMap(n3);
        this.locationTable = new HashMap(n3);
        for (n = 0; n < n3; ++n) {
            n2 = ByteUtils.readInt(bufferedInputStream);
            int n8 = ByteUtils.readInt(bufferedInputStream);
            this.locationTable.put(n2, n8);
            n5 += 8;
        }
        n = ByteUtils.readInt(bufferedInputStream);
        n2 = ByteUtils.readInt(bufferedInputStream);
        n5 += 8;
        if (readListener != null) {
            readListener.readBytes(n5);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n9 = -1;
        byte[] byArray = new byte[4096];
        while ((n9 = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n9);
            if (readListener == null) continue;
            readListener.readBytes(n9);
        }
        bufferedInputStream = null;
        this.dataArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        Savable savable = this.readObject(n2);
        if (debug) {
            logger.info("Importer Stats: ");
            logger.info("Tags: " + n4);
            logger.info("Objects: " + n3);
            logger.info("Data Size: " + this.dataArray.length);
        }
        this.dataArray = null;
        return savable;
    }

    public Savable load(URL uRL) throws IOException {
        return this.load(uRL, null);
    }

    public Savable load(URL uRL, ReadListener readListener) throws IOException {
        InputStream inputStream = uRL.openStream();
        Savable savable = this.load(inputStream, readListener);
        inputStream.close();
        return savable;
    }

    public Savable load(File file) throws IOException {
        return this.load(file, null);
    }

    public Savable load(File file, ReadListener readListener) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Savable savable = this.load(fileInputStream, readListener);
        fileInputStream.close();
        return savable;
    }

    public Savable load(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Savable savable = this.load(byteArrayInputStream);
        byteArrayInputStream.close();
        return savable;
    }

    public BinaryInputCapsule getCapsule(Savable savable) {
        return this.capsuleTable.get(savable);
    }

    protected String readString(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)inputStream.read();
        }
        return new String(byArray);
    }

    protected String readString(int n, int n2) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.dataArray[i + n2];
        }
        return new String(byArray);
    }

    public Savable readObject(int n) {
        if (this.contentTable.get(n) != null) {
            return this.contentTable.get(n);
        }
        try {
            int n2 = this.locationTable.get(n);
            String string = this.readString(this.aliasWidth, n2);
            n2 += this.aliasWidth;
            BinaryClassObject binaryClassObject = this.classes.get(string);
            if (binaryClassObject == null) {
                logger.warning("NULL class object" + string);
            }
            int n3 = ByteUtils.convertIntFromBytes(this.dataArray, n2);
            BinaryInputCapsule binaryInputCapsule = new BinaryInputCapsule(this, binaryClassObject);
            binaryInputCapsule.setContent(this.dataArray, n2 += 4, n2 + n3);
            Savable savable = BinaryClassLoader.fromName(binaryClassObject.className, binaryInputCapsule);
            this.capsuleTable.put(savable, binaryInputCapsule);
            this.contentTable.put(n, savable);
            savable.read(this);
            this.capsuleTable.remove(savable);
            return savable;
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", iOException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", classNotFoundException);
            return null;
        }
        catch (InstantiationException instantiationException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "readObject(int id)", "Exception", illegalAccessException);
            return null;
        }
    }
}

