/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system.lwjgl;

import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.PropertiesIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LWJGLPropertiesDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(LWJGLPropertiesDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private final PropertiesIO source;
    private URL imageFile = null;
    private DisplayMode[] modes = null;
    private String[] windowedResolutions = new String[]{"640 x 480", "800 x 600", "1024 x 768", "1152 x 864"};
    private JCheckBox fullscreenBox = null;
    private JComboBox displayResCombo = null;
    private JComboBox colorDepthCombo = null;
    private JComboBox displayFreqCombo = null;
    private JComboBox rendererCombo = null;
    private JLabel icon = null;
    private boolean cancelled = false;
    private Stack<Runnable> mainThreadTasks;

    public LWJGLPropertiesDialog(PropertiesIO propertiesIO, String string) {
        this(propertiesIO, string, null);
    }

    public LWJGLPropertiesDialog(PropertiesIO propertiesIO, URL uRL) {
        this(propertiesIO, uRL, null);
    }

    public LWJGLPropertiesDialog(PropertiesIO propertiesIO, String string, Stack<Runnable> stack) {
        this(propertiesIO, LWJGLPropertiesDialog.getURL(string), stack);
    }

    public LWJGLPropertiesDialog(PropertiesIO propertiesIO, URL uRL, Stack<Runnable> stack) {
        if (null == propertiesIO) {
            throw new JmeException("PropertyIO source cannot be null");
        }
        this.source = propertiesIO;
        this.imageFile = uRL;
        this.mainThreadTasks = stack;
        ModesRetriever modesRetriever = new ModesRetriever();
        if (stack != null) {
            stack.add(modesRetriever);
        } else {
            modesRetriever.run();
        }
        this.modes = modesRetriever.getModes();
        Arrays.sort(this.modes, new DisplayModeSorter());
        this.createUI();
    }

    public void setImage(String string) {
        try {
            URL uRL = new URL("file:" + string);
            this.setImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setImage(URL uRL) {
        this.icon.setIcon(new ImageIcon(uRL));
        this.pack();
        this.center();
    }

    private void showDialog() {
        this.setVisible(true);
        this.toFront();
    }

    private void center() {
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void createUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LWJGLPropertiesDialog.this.cancelled = true;
                LWJGLPropertiesDialog.this.dispose();
            }
        });
        this.setTitle("Select Display Settings");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        this.icon = new JLabel(this.imageFile != null ? new ImageIcon(this.imageFile) : null);
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && LWJGLPropertiesDialog.this.verifyAndSaveCurrentSelection()) {
                    LWJGLPropertiesDialog.this.dispose();
                }
            }
        };
        this.displayResCombo = this.setUpResolutionChooser();
        this.displayResCombo.addKeyListener(keyAdapter);
        this.colorDepthCombo = new JComboBox();
        this.colorDepthCombo.addKeyListener(keyAdapter);
        this.displayFreqCombo = new JComboBox();
        this.displayFreqCombo.addKeyListener(keyAdapter);
        this.fullscreenBox = new JCheckBox("Fullscreen?");
        this.fullscreenBox.setSelected(this.source.getFullscreen());
        this.fullscreenBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LWJGLPropertiesDialog.this.updateResolutionChoices();
            }
        });
        this.rendererCombo = this.setUpRendererChooser();
        this.rendererCombo.addKeyListener(keyAdapter);
        this.updateResolutionChoices();
        this.displayResCombo.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        jPanel3.add(this.displayResCombo);
        jPanel3.add(this.colorDepthCombo);
        jPanel3.add(this.displayFreqCombo);
        jPanel3.add(this.fullscreenBox);
        jPanel3.add(this.rendererCombo);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LWJGLPropertiesDialog.this.verifyAndSaveCurrentSelection()) {
                    LWJGLPropertiesDialog.this.dispose();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LWJGLPropertiesDialog.this.cancelled = true;
                LWJGLPropertiesDialog.this.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        if (this.icon != null) {
            jPanel2.add((Component)this.icon, "North");
        }
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.center();
        this.showDialog();
    }

    private boolean verifyAndSaveCurrentSelection() {
        String string = (String)this.displayResCombo.getSelectedItem();
        boolean bl = this.fullscreenBox.isSelected();
        int n = Integer.parseInt(string.substring(0, string.indexOf(" x ")));
        string = string.substring(string.indexOf(" x ") + 3);
        int n2 = Integer.parseInt(string);
        String string2 = (String)this.colorDepthCombo.getSelectedItem();
        int n3 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
        String string3 = (String)this.displayFreqCombo.getSelectedItem();
        int n4 = -1;
        if (bl) {
            n4 = Integer.parseInt(string3.substring(0, string3.indexOf(" ")));
        }
        String string4 = (String)this.rendererCombo.getSelectedItem();
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        } else {
            ModeValidator modeValidator = new ModeValidator(string4, n, n2, n3, n4);
            if (this.mainThreadTasks != null) {
                this.mainThreadTasks.add(modeValidator);
            } else {
                modeValidator.run();
            }
            bl2 = modeValidator.isValid();
        }
        if (bl2) {
            this.source.save(n, n2, n3, n4, bl, string4);
        } else {
            LWJGLPropertiesDialog.showError(this, "Your monitor claims to not support the display mode you've selected.\nThe combination of bit depth and refresh rate is not supported.");
        }
        return bl2;
    }

    private JComboBox setUpResolutionChooser() {
        String[] stringArray = LWJGLPropertiesDialog.getResolutions(this.modes);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LWJGLPropertiesDialog.this.updateDisplayChoices();
            }
        });
        return jComboBox;
    }

    private JComboBox setUpRendererChooser() {
        String[] stringArray = DisplaySystem.getSystemProviderIdentifiers();
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getRenderer());
        return jComboBox;
    }

    private void updateDisplayChoices() {
        String string;
        if (!this.fullscreenBox.isSelected()) {
            return;
        }
        String string2 = (String)this.displayResCombo.getSelectedItem();
        String string3 = (String)this.colorDepthCombo.getSelectedItem();
        if (string3 == null) {
            string3 = this.source.getDepth() + " bpp";
        }
        if ((string = (String)this.displayFreqCombo.getSelectedItem()) == null) {
            string = this.source.getFreq() + " Hz";
        }
        String[] stringArray = LWJGLPropertiesDialog.getDepths(string2, this.modes);
        this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.colorDepthCombo.setSelectedItem(string3);
        String[] stringArray2 = LWJGLPropertiesDialog.getFrequencies(string2, this.modes);
        this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.displayFreqCombo.setSelectedItem(string);
    }

    private void updateResolutionChoices() {
        if (!this.fullscreenBox.isSelected()) {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(this.windowedResolutions));
            this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"24 bpp", "16 bpp"}));
            this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"n/a"}));
            this.displayFreqCombo.setEnabled(false);
        } else {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(LWJGLPropertiesDialog.getResolutions(this.modes)));
            this.displayFreqCombo.setEnabled(true);
            this.updateDisplayChoices();
        }
    }

    private static URL getURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static void showError(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, "Error", 0);
    }

    private static String[] getResolutions(DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(displayModeArray.length);
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getDepths(String string, DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (displayModeArray[i].getBitsPerPixel() < 16) continue;
            String string2 = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            String string3 = String.valueOf(displayModeArray[i].getBitsPerPixel()) + " bpp";
            if (!string2.equals(string) || arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] getFrequencies(String string, DisplayMode[] displayModeArray) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < displayModeArray.length; ++i) {
            String string2 = displayModeArray[i].getWidth() + " x " + displayModeArray[i].getHeight();
            String string3 = String.valueOf(displayModeArray[i].getFrequency()) + " Hz";
            if (!string2.equals(string) || arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    class ModesRetriever
    implements Runnable {
        boolean ready = false;
        DisplayMode[] modes = null;

        ModesRetriever() {
        }

        public void run() {
            try {
                this.modes = Display.getAvailableDisplayModes();
            }
            catch (LWJGLException lWJGLException) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "LWJGLPropertiesDialog(PropertiesIO, URL)", "Exception", lWJGLException);
                return;
            }
            this.ready = true;
        }

        public DisplayMode[] getModes() {
            while (!this.ready) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            return this.modes;
        }
    }

    class ModeValidator
    implements Runnable {
        boolean ready = false;
        boolean valid = false;
        String renderer;
        int width;
        int height;
        int depth;
        int freq;

        ModeValidator(String string, int n, int n2, int n3, int n4) {
            this.renderer = string;
            this.width = n;
            this.height = n2;
            this.depth = n3;
            this.freq = n4;
        }

        public void run() {
            DisplaySystem displaySystem = DisplaySystem.getDisplaySystem(this.renderer);
            this.valid = displaySystem != null ? displaySystem.isValidDisplayMode(this.width, this.height, this.depth, this.freq) : false;
            this.ready = true;
        }

        public boolean isValid() {
            while (!this.ready) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            return this.valid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplayModeSorter
    implements Comparator<DisplayMode> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayMode displayMode, DisplayMode displayMode2) {
            if (displayMode.getWidth() != displayMode2.getWidth()) {
                return displayMode.getWidth() > displayMode2.getWidth() ? 1 : -1;
            }
            if (displayMode.getHeight() != displayMode2.getHeight()) {
                return displayMode.getHeight() > displayMode2.getHeight() ? 1 : -1;
            }
            if (displayMode.getBitsPerPixel() != displayMode2.getBitsPerPixel()) {
                return displayMode.getBitsPerPixel() > displayMode2.getBitsPerPixel() ? 1 : -1;
            }
            if (displayMode.getFrequency() != displayMode2.getFrequency()) {
                return displayMode.getFrequency() > displayMode2.getFrequency() ? 1 : -1;
            }
            return 0;
        }
    }
}

