/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system.lwjgl;

import com.jme.image.Image;
import com.jme.renderer.RenderContext;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.lwjgl.LWJGLPbufferTextureRenderer;
import com.jme.renderer.lwjgl.LWJGLRenderer;
import com.jme.renderer.lwjgl.LWJGLTextureRenderer;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.ImageUtils;
import com.jme.util.WeakIdentityCache;
import com.jmex.awt.JMECanvas;
import com.jmex.awt.lwjgl.LWJGLCanvas;
import java.awt.Canvas;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

public class LWJGLDisplaySystem
extends DisplaySystem {
    private static final Logger logger = Logger.getLogger(LWJGLDisplaySystem.class.getName());
    private LWJGLRenderer renderer;
    private Pbuffer headlessDisplay;
    private JMECanvas canvas;
    private RenderContext currentContext = null;
    private WeakIdentityCache<Object, RenderContext> contextStore = new WeakIdentityCache();

    public LWJGLDisplaySystem() {
        logger.info("LWJGL Display System created.");
    }

    public boolean isValidDisplayMode(int n, int n2, int n3, int n4) {
        return this.getValidDisplayMode(n, n2, n3, n4) != null;
    }

    public void setVSyncEnabled(boolean bl) {
        Display.setVSyncEnabled(bl);
    }

    public void setTitle(String string) {
        Display.setTitle(string);
    }

    public void createWindow(int n, int n2, int n3, int n4, boolean bl) throws JmeException {
        if (n <= 0 || n2 <= 0) {
            throw new JmeException("Invalid resolution values: " + n + " " + n2);
        }
        if (n3 != 32 && n3 != 16 && n3 != 24) {
            throw new JmeException("Invalid pixel depth: " + n3);
        }
        this.width = n;
        this.height = n2;
        this.bpp = n3;
        this.frq = n4;
        this.fs = bl;
        this.initDisplay();
        this.renderer = new LWJGLRenderer(this.width, this.height);
        this.switchContext(this);
        LWJGLDisplaySystem.updateStates(this.renderer);
        this.created = true;
    }

    public void createHeadlessWindow(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new JmeException("Invalid resolution values: " + n + " " + n2);
        }
        if (n3 != 32 && n3 != 16 && n3 != 24) {
            throw new JmeException("Invalid pixel depth: " + n3);
        }
        this.width = n;
        this.height = n2;
        this.bpp = n3;
        this.initHeadlessDisplay();
        this.renderer = new LWJGLRenderer(this.width, this.height);
        this.switchContext(this);
        this.renderer.setHeadless(true);
        LWJGLDisplaySystem.updateStates(this.renderer);
        this.created = true;
    }

    public Canvas createCanvas(int n, int n2) {
        LWJGLCanvas lWJGLCanvas;
        if (n <= 0 || n2 <= 0) {
            throw new JmeException("Invalid resolution values: " + n + " " + n2);
        }
        this.width = n;
        this.height = n2;
        try {
            lWJGLCanvas = new LWJGLCanvas();
        }
        catch (LWJGLException lWJGLException) {
            throw new JmeException("Unable to create canvas.", lWJGLException);
        }
        this.currentContext = new RenderContext();
        this.contextStore.put(lWJGLCanvas, this.currentContext);
        this.created = true;
        return lWJGLCanvas;
    }

    public JMECanvas getCurrentCanvas() {
        return this.canvas;
    }

    public Pbuffer getHeadlessDisplay() {
        return this.headlessDisplay;
    }

    public void recreateWindow(int n, int n2, int n3, int n4, boolean bl) {
        if (!this.created) {
            this.createWindow(n, n2, n3, n4, bl);
            return;
        }
        if (n <= 0 || n2 <= 0) {
            throw new JmeException("Invalid resolution values: " + n + " " + n2);
        }
        if (n3 != 32 && n3 != 16 && n3 != 24) {
            throw new JmeException("Invalid pixel depth: " + n3);
        }
        this.width = n;
        this.height = n2;
        this.bpp = n3;
        this.frq = n4;
        this.fs = bl;
        this.reinitDisplay();
        this.renderer.reinit(this.width, this.height);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public boolean isClosing() {
        if (this.headlessDisplay == null) {
            return Display.isCloseRequested();
        }
        return false;
    }

    public boolean isActive() {
        return Display.isActive();
    }

    public void reset() {
    }

    public void close() {
        Display.destroy();
    }

    public TextureRenderer createTextureRenderer(int n, int n2, int n3) {
        if (!this.isCreated()) {
            return null;
        }
        TextureRenderer textureRenderer = new LWJGLTextureRenderer(n, n2, (LWJGLRenderer)this.getRenderer());
        if (!textureRenderer.isSupported()) {
            textureRenderer = null;
            if (n3 == 1) {
                n3 = 8313;
            } else if (n3 == 2) {
                n3 = 8314;
            } else if (n3 == 4) {
                n3 = 8312;
            } else if (n3 == 3) {
                n3 = 8354;
            }
            RenderTexture renderTexture = new RenderTexture(false, true, true, false, n3, 0);
            textureRenderer = new LWJGLPbufferTextureRenderer(n, n2, (LWJGLRenderer)this.getRenderer(), renderTexture);
        }
        return textureRenderer;
    }

    private DisplayMode getValidDisplayMode(int n, int n2, int n3, int n4) {
        DisplayMode[] displayModeArray;
        try {
            displayModeArray = Display.getAvailableDisplayModes();
        }
        catch (LWJGLException lWJGLException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "getValidDisplayMode(width, height, bpp, freq)", "Exception", lWJGLException);
            return null;
        }
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (displayModeArray[i].getWidth() != n) {
                logger.fine("DisplayMode " + displayModeArray[i] + ": Width != " + n);
                continue;
            }
            if (displayModeArray[i].getHeight() != n2) {
                logger.fine("DisplayMode " + displayModeArray[i] + ": Height != " + n2);
                continue;
            }
            if (displayModeArray[i].getBitsPerPixel() != n3) {
                logger.fine("DisplayMode " + displayModeArray[i] + ": Bits per pixel != " + n3);
                continue;
            }
            if (n5 == -1) {
                logger.fine("DisplayMode " + displayModeArray[i] + ": Match! ");
                n5 = i;
                n6 = displayModeArray[i].getFrequency();
                continue;
            }
            int n7 = displayModeArray[i].getFrequency();
            if (n6 == n4 || n7 != n4 && n6 >= n7) continue;
            logger.fine("DisplayMode " + displayModeArray[i] + ": Better match!");
            n5 = i;
            n6 = n7;
        }
        if (n5 == -1) {
            return null;
        }
        logger.info("Selected DisplayMode: " + displayModeArray[n5]);
        return displayModeArray[n5];
    }

    private void initDisplay() {
        DisplayMode displayMode = this.selectMode();
        PixelFormat pixelFormat = this.getFormat();
        if (null == displayMode) {
            throw new JmeException("Bad display mode");
        }
        try {
            Display.setDisplayMode(displayMode);
            Display.setFullscreen(this.fs);
            if (!this.fs) {
                int n = Toolkit.getDefaultToolkit().getScreenSize().width - this.width >> 1;
                int n2 = Toolkit.getDefaultToolkit().getScreenSize().height - this.height >> 1;
                Display.setLocation(n, n2);
            }
            Display.create(pixelFormat);
            if (this.samples != 0 && GLContext.getCapabilities().GL_ARB_multisample) {
                GL11.glEnable(32925);
            }
            Keyboard.poll();
            Mouse.poll();
        }
        catch (Exception exception) {
            logger.severe("Cannot create window");
            logger.logp(Level.SEVERE, this.getClass().toString(), "initDisplay()", "Exception", exception);
            throw new JmeException("Cannot create window: " + exception.getMessage());
        }
    }

    private void initHeadlessDisplay() {
        DisplayMode displayMode = this.getValidDisplayMode(this.width, this.height, this.bpp, this.frq);
        PixelFormat pixelFormat = this.getFormat();
        try {
            Display.setDisplayMode(displayMode);
            this.headlessDisplay = new Pbuffer(this.width, this.height, pixelFormat, null, null);
            this.headlessDisplay.makeCurrent();
            if (this.samples != 0 && GLContext.getCapabilities().GL_ARB_multisample) {
                GL11.glEnable(32925);
            }
        }
        catch (Exception exception) {
            logger.severe("Cannot create headless window");
            logger.logp(Level.SEVERE, this.getClass().toString(), "initHeadlessDisplay()", "Exception", exception);
            throw new Error("Cannot create headless window: " + exception.getMessage(), exception);
        }
    }

    private void reinitDisplay() {
        DisplayMode displayMode = this.selectMode();
        try {
            Display.releaseContext();
            Display.setDisplayMode(displayMode);
            Display.setFullscreen(this.fs);
            Display.makeCurrent();
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "reinitDisplay()", "Cannot recreate window", exception);
            throw new Error("Cannot recreate window: " + exception.getMessage());
        }
    }

    private DisplayMode selectMode() {
        DisplayMode displayMode;
        if (this.fs) {
            displayMode = this.getValidDisplayMode(this.width, this.height, this.bpp, this.frq);
            if (null == displayMode) {
                throw new JmeException("Bad display mode");
            }
        } else {
            displayMode = new DisplayMode(this.width, this.height);
        }
        return displayMode;
    }

    public void setRenderer(Renderer renderer) {
        if (renderer instanceof LWJGLRenderer) {
            this.renderer = (LWJGLRenderer)renderer;
        } else {
            logger.warning("Invalid Renderer type");
        }
    }

    protected void updateDisplayBGC() {
        try {
            Display.setDisplayConfiguration(this.gamma, this.brightness, this.contrast);
        }
        catch (LWJGLException lWJGLException) {
            logger.warning("Unable to apply gamma/brightness/contrast settings: " + lWJGLException.getMessage());
        }
    }

    public void setIcon(Image[] imageArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[imageArray.length];
        for (int i = 0; i < byteBufferArray.length; ++i) {
            if (imageArray[i].getType() != 3) {
                try {
                    imageArray[i] = ImageUtils.convert(imageArray[i], 3);
                }
                catch (JmeException jmeException) {
                    throw new JmeException("Your icon is in a format that could not be converted to RGBA8888", jmeException);
                }
            }
            byteBufferArray[i] = imageArray[i].getData();
            byteBufferArray[i].rewind();
        }
        Display.setIcon(byteBufferArray);
    }

    public String getAdapter() {
        return Display.getAdapter();
    }

    public String getDriverVersion() {
        return Display.getVersion();
    }

    public String getDisplayVendor() {
        try {
            return GL11.glGetString(7936);
        }
        catch (Exception exception) {
            return "Unable to retrieve vendor.";
        }
    }

    public String getDisplayRenderer() {
        try {
            return GL11.glGetString(7937);
        }
        catch (Exception exception) {
            return "Unable to retrieve adapter details.";
        }
    }

    public String getDisplayAPIVersion() {
        try {
            return GL11.glGetString(7938);
        }
        catch (Exception exception) {
            return "Unable to retrieve API version.";
        }
    }

    public void setCurrentCanvas(JMECanvas jMECanvas) {
        this.canvas = jMECanvas;
    }

    public PixelFormat getFormat() {
        return new PixelFormat(this.bpp, this.alphaBits, this.depthBits, this.stencilBits, this.samples);
    }

    public RenderContext getCurrentContext() {
        return this.currentContext;
    }

    public RenderContext switchContext(Object object) {
        this.currentContext = this.contextStore.get(object);
        if (this.currentContext == null) {
            this.currentContext = new RenderContext();
            this.currentContext.setupRecords(this.getRenderer());
            this.contextStore.put(object, this.currentContext);
        }
        return this.currentContext;
    }

    public void initForCanvas(int n, int n2) {
        this.renderer = new LWJGLRenderer(n, n2);
        this.renderer.setHeadless(true);
        this.currentContext.setupRecords(this.renderer);
        DisplaySystem.updateStates(this.renderer);
    }

    public RenderContext removeContext(Object object) {
        if (object != null) {
            RenderContext renderContext = this.contextStore.get(object);
            if (renderContext != this.currentContext) {
                return this.contextStore.remove(object);
            }
            logger.warning("Can not remove current context.");
        }
        return null;
    }
}

