/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderContext;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.lwjgl.records.MaterialStateRecord;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLMaterialState
extends MaterialState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        MaterialStateRecord materialStateRecord = (MaterialStateRecord)renderContext.getStateRecord(4);
        renderContext.currentStates[4] = this;
        int n = LWJGLMaterialState.getGLMaterialFace(this.materialFace);
        this.applyColorMaterial(this.getColorMaterial(), n, materialStateRecord);
        LWJGLMaterialState.applyColor(4608, this.getAmbient(), n, materialStateRecord);
        LWJGLMaterialState.applyColor(4609, this.getDiffuse(), n, materialStateRecord);
        LWJGLMaterialState.applyColor(5632, this.getEmissive(), n, materialStateRecord);
        LWJGLMaterialState.applyColor(4610, this.getSpecular(), n, materialStateRecord);
        if (!materialStateRecord.isValid() || n != materialStateRecord.face || materialStateRecord.shininess != this.shininess) {
            GL11.glMaterialf(n, 5633, this.shininess);
            materialStateRecord.shininess = this.shininess;
        }
        materialStateRecord.face = n;
        if (!materialStateRecord.isValid()) {
            materialStateRecord.validate();
        }
    }

    private static void applyColor(int n, ColorRGBA colorRGBA, int n2, MaterialStateRecord materialStateRecord) {
        if (!(LWJGLMaterialState.isVertexProvidedColor(n, materialStateRecord) || materialStateRecord.isValid() && n2 == materialStateRecord.face && materialStateRecord.isSetColor(n2, n, colorRGBA, materialStateRecord))) {
            materialStateRecord.tempColorBuff.clear();
            materialStateRecord.tempColorBuff.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
            materialStateRecord.tempColorBuff.flip();
            GL11.glMaterial(n2, n, materialStateRecord.tempColorBuff);
            materialStateRecord.setColor(n2, n, colorRGBA);
        }
    }

    private static boolean isVertexProvidedColor(int n, MaterialStateRecord materialStateRecord) {
        switch (n) {
            case 4608: {
                return materialStateRecord.colorMaterial == 4608 || materialStateRecord.colorMaterial == 5634;
            }
            case 4609: {
                return materialStateRecord.colorMaterial == 4609 || materialStateRecord.colorMaterial == 5634;
            }
            case 4610: {
                return materialStateRecord.colorMaterial == 4610;
            }
            case 5632: {
                return materialStateRecord.colorMaterial == 5632;
            }
        }
        return false;
    }

    private void applyColorMaterial(int n, int n2, MaterialStateRecord materialStateRecord) {
        int n3 = LWJGLMaterialState.getGLColorMaterial(n);
        if (!materialStateRecord.isValid() || n2 != materialStateRecord.face || n3 != materialStateRecord.colorMaterial) {
            if (n3 == -1) {
                GL11.glDisable(2903);
            } else {
                GL11.glColorMaterial(n2, n3);
                GL11.glEnable(2903);
                materialStateRecord.resetColorsForCM(n2, n3);
            }
            materialStateRecord.colorMaterial = n3;
        }
    }

    private static int getGLColorMaterial(int n) {
        switch (n) {
            case 1: {
                return 4608;
            }
            case 2: {
                return 4609;
            }
            case 3: {
                return 5634;
            }
            case 5: {
                return 5632;
            }
            case 4: {
                return 4610;
            }
        }
        return -1;
    }

    private static int getGLMaterialFace(int n) {
        switch (n) {
            case 0: {
                return 1028;
            }
            case 1: {
                return 1029;
            }
            case 2: {
                return 1032;
            }
        }
        return -1;
    }

    public StateRecord createStateRecord() {
        return new MaterialStateRecord();
    }
}

