/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderContext;
import com.jme.scene.state.FogState;
import com.jme.scene.state.lwjgl.records.FogStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLFogState
extends FogState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        FogStateRecord fogStateRecord = (FogStateRecord)renderContext.getStateRecord(2);
        renderContext.currentStates[2] = this;
        if (this.isEnabled()) {
            this.enableFog(true, fogStateRecord);
            if (fogStateRecord.isValid()) {
                if (fogStateRecord.fogStart != this.start) {
                    GL11.glFogf(2915, this.start);
                    fogStateRecord.fogStart = this.start;
                }
                if (fogStateRecord.fogEnd != this.end) {
                    GL11.glFogf(2916, this.end);
                    fogStateRecord.fogEnd = this.end;
                }
                if (fogStateRecord.density != this.density) {
                    GL11.glFogf(2914, this.density);
                    fogStateRecord.density = this.density;
                }
            } else {
                GL11.glFogf(2915, this.start);
                fogStateRecord.fogStart = this.start;
                GL11.glFogf(2916, this.end);
                fogStateRecord.fogEnd = this.end;
                GL11.glFogf(2914, this.density);
                fogStateRecord.density = this.density;
            }
            this.applyFogColor(this.getColor(), fogStateRecord);
            this.applyFogMode(this.densityFunction, fogStateRecord);
            this.applyFogHint(this.applyFunction, fogStateRecord);
        } else {
            this.enableFog(false, fogStateRecord);
        }
        if (!fogStateRecord.isValid()) {
            fogStateRecord.validate();
        }
    }

    private void enableFog(boolean bl, FogStateRecord fogStateRecord) {
        if (fogStateRecord.isValid()) {
            if (bl && !fogStateRecord.enabled) {
                GL11.glEnable(2912);
                fogStateRecord.enabled = true;
            } else if (!bl && fogStateRecord.enabled) {
                GL11.glDisable(2912);
                fogStateRecord.enabled = false;
            }
        } else {
            if (bl) {
                GL11.glEnable(2912);
            } else {
                GL11.glDisable(2912);
            }
            fogStateRecord.enabled = bl;
        }
    }

    private void applyFogColor(ColorRGBA colorRGBA, FogStateRecord fogStateRecord) {
        if (!fogStateRecord.isValid() || !colorRGBA.equals(fogStateRecord.fogColor)) {
            fogStateRecord.fogColor.set(colorRGBA);
            fogStateRecord.colorBuff.clear();
            fogStateRecord.colorBuff.put(fogStateRecord.fogColor.r).put(fogStateRecord.fogColor.g).put(fogStateRecord.fogColor.b).put(fogStateRecord.fogColor.a);
            fogStateRecord.colorBuff.flip();
            GL11.glFog(2918, fogStateRecord.colorBuff);
        }
    }

    private void applyFogMode(int n, FogStateRecord fogStateRecord) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 9729;
                break;
            }
            case 2: {
                n2 = 2049;
                break;
            }
            default: {
                n2 = 2048;
            }
        }
        if (!fogStateRecord.isValid() || fogStateRecord.fogMode != n2) {
            GL11.glFogi(2917, n2);
            fogStateRecord.fogMode = n2;
        }
    }

    private void applyFogHint(int n, FogStateRecord fogStateRecord) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 4353;
                break;
            }
            default: {
                n2 = 4354;
            }
        }
        if (!fogStateRecord.isValid() || fogStateRecord.fogHint != n2) {
            GL11.glHint(3156, n2);
            fogStateRecord.fogHint = n2;
        }
    }

    public FogStateRecord createStateRecord() {
        return new FogStateRecord();
    }
}

