/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.lwjgl.records.AlphaStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLAlphaState
extends AlphaState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        AlphaStateRecord alphaStateRecord = (AlphaStateRecord)renderContext.getStateRecord(0);
        renderContext.currentStates[0] = this;
        if (this.isEnabled()) {
            this.applyBlend(this.isBlendEnabled(), this.getSrcFunction(), this.getDstFunction(), alphaStateRecord);
            this.applyTest(this.isTestEnabled(), this.getTestFunction(), this.getReference(), alphaStateRecord);
        } else {
            this.applyBlend(false, -1, -1, alphaStateRecord);
            this.applyTest(false, -1, -1.0f, alphaStateRecord);
        }
        if (!alphaStateRecord.isValid()) {
            alphaStateRecord.validate();
        }
    }

    private void applyBlend(boolean bl, int n, int n2, AlphaStateRecord alphaStateRecord) {
        if (alphaStateRecord.isValid()) {
            if (bl) {
                if (!alphaStateRecord.blendEnabled) {
                    GL11.glEnable(3042);
                    alphaStateRecord.blendEnabled = true;
                }
                int n3 = this.getGLSrcValue(n);
                int n4 = this.getGLDstValue(n2);
                if (alphaStateRecord.srcFactor != n3 || alphaStateRecord.dstFactor != n4) {
                    GL11.glBlendFunc(n3, n4);
                    alphaStateRecord.srcFactor = n3;
                    alphaStateRecord.dstFactor = n4;
                }
            } else if (alphaStateRecord.blendEnabled) {
                GL11.glDisable(3042);
                alphaStateRecord.blendEnabled = false;
            }
        } else if (bl) {
            GL11.glEnable(3042);
            alphaStateRecord.blendEnabled = true;
            int n5 = this.getGLSrcValue(n);
            int n6 = this.getGLDstValue(n2);
            GL11.glBlendFunc(n5, n6);
            alphaStateRecord.srcFactor = n5;
            alphaStateRecord.dstFactor = n6;
        } else {
            GL11.glDisable(3042);
            alphaStateRecord.blendEnabled = false;
        }
    }

    private int getGLSrcValue(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 774;
            }
            case 3: {
                return 775;
            }
            case 4: {
                return 770;
            }
            case 5: {
                return 771;
            }
            case 6: {
                return 772;
            }
            case 7: {
                return 773;
            }
            case 8: {
                return 776;
            }
        }
        return 1;
    }

    private int getGLDstValue(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 768;
            }
            case 3: {
                return 769;
            }
            case 4: {
                return 770;
            }
            case 5: {
                return 771;
            }
            case 6: {
                return 772;
            }
            case 7: {
                return 773;
            }
        }
        return 0;
    }

    private void applyTest(boolean bl, int n, float f, AlphaStateRecord alphaStateRecord) {
        if (alphaStateRecord.isValid()) {
            if (bl) {
                int n2;
                if (!alphaStateRecord.testEnabled) {
                    GL11.glEnable(3008);
                    alphaStateRecord.testEnabled = true;
                }
                if (alphaStateRecord.alphaFunc != (n2 = this.getGLFuncValue(n)) || alphaStateRecord.alphaRef != f) {
                    GL11.glAlphaFunc(n2, f);
                    alphaStateRecord.alphaFunc = n2;
                    alphaStateRecord.alphaRef = f;
                }
            } else if (alphaStateRecord.testEnabled) {
                GL11.glDisable(3008);
                alphaStateRecord.testEnabled = false;
            }
        } else if (bl) {
            GL11.glEnable(3008);
            alphaStateRecord.testEnabled = true;
            int n3 = this.getGLFuncValue(n);
            GL11.glAlphaFunc(n3, f);
            alphaStateRecord.alphaFunc = n3;
            alphaStateRecord.alphaRef = f;
        } else {
            GL11.glDisable(3008);
            alphaStateRecord.testEnabled = false;
        }
    }

    private int getGLFuncValue(int n) {
        switch (n) {
            case 0: {
                return 512;
            }
            case 1: {
                return 513;
            }
            case 2: {
                return 514;
            }
            case 3: {
                return 515;
            }
            case 4: {
                return 516;
            }
            case 5: {
                return 517;
            }
            case 6: {
                return 518;
            }
        }
        return 519;
    }

    public AlphaStateRecord createStateRecord() {
        return new AlphaStateRecord();
    }
}

