/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;

public abstract class VertexProgramState
extends RenderState {
    protected static float[][] envparameters = new float[96][];
    protected boolean usingParameters = false;
    protected float[][] parameters = new float[96][];
    protected ByteBuffer program;

    public static void setEnvParameter(float[] fArray, int n) {
        if (n < 0 || n > 95) {
            throw new IllegalArgumentException("Invalid parameter ID");
        }
        if (fArray != null && fArray.length != 4) {
            throw new IllegalArgumentException("Vertex program parameters must be of type float[4]");
        }
        VertexProgramState.envparameters[n] = fArray;
    }

    public abstract boolean isSupported();

    public void setParameter(float[] fArray, int n) {
        if (n < 0 || n > 95) {
            throw new IllegalArgumentException("Invalid parameter ID");
        }
        if (fArray != null && fArray.length != 4) {
            throw new IllegalArgumentException("Vertex program parameters must be of type float[4]");
        }
        this.usingParameters = true;
        this.parameters[n] = fArray;
        this.setNeedsRefresh(true);
    }

    public int getType() {
        return 10;
    }

    public abstract void load(URL var1);

    public abstract void load(String var1);

    public abstract String getProgram();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.program == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.program.capacity());
            this.program.rewind();
            int n = this.program.capacity();
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeByte(this.program.get());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.program = null;
        } else {
            this.program = BufferUtils.createByteBuffer(n);
            for (int i = 0; i < n; ++i) {
                this.program.put(objectInputStream.readByte());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.usingParameters, "usingParameters", false);
        outputCapsule.write(this.parameters, "parameters", new float[96][]);
        outputCapsule.write(this.program, "program", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.usingParameters = inputCapsule.readBoolean("usingParameters", false);
        this.parameters = inputCapsule.readFloatArray2D("parameters", new float[96][]);
        this.program = inputCapsule.readByteBuffer("program", null);
    }

    public Class getClassTag() {
        return VertexProgramState.class;
    }
}

