/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.image.Image;
import com.jme.image.Texture;
import com.jme.scene.state.RenderState;
import com.jme.util.TextureManager;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TextureState
extends RenderState {
    private static final Logger logger = Logger.getLogger(TextureState.class.getName());
    protected static Texture defaultTexture = null;
    public static final int OFF = 0;
    public static final int COMBINE_FIRST = 1;
    public static final int COMBINE_CLOSEST = 2;
    public static final int COMBINE_RECENT_ENABLED = 3;
    public static final int INHERIT = 4;
    public static final int REPLACE = 5;
    public static final int CM_AFFINE = 0;
    public static final int CM_PERSPECTIVE = 1;
    protected transient ArrayList<Texture> texture;
    protected static int numTotalTexUnits = -1;
    protected static int numFixedTexUnits = -1;
    protected static int numVertexTexUnits = -1;
    protected static int numFragmentTexUnits = -1;
    protected static int numFragmentTexCoordUnits = -1;
    protected static float maxAnisotropic = -1.0f;
    protected static boolean supportsMultiTexture = false;
    protected static boolean supportsMultiTextureDetected = false;
    protected static boolean supportsEnvDot3 = false;
    protected static boolean supportsEnvDot3Detected = false;
    protected static boolean supportsEnvCombine = false;
    protected static boolean supportsEnvCombineDetected = false;
    protected static boolean supportsAniso = false;
    protected static boolean supportsAnisoDetected = false;
    protected static boolean supportsNonPowerTwo = false;
    protected static boolean supportsNonPowerTwoDetected = false;
    protected static boolean supportsRectangular = false;
    protected static boolean supportsRectangularDetected = false;
    protected static boolean supportsS3TCCompression = false;
    protected static boolean supportsS3TCCompressionDetected = false;
    protected transient int firstTexture = 0;
    protected transient int lastTexture = 0;
    private int correction = 1;
    protected int offset = 0;
    protected transient int[] idCache = new int[0];

    public TextureState() {
        if (defaultTexture == null) {
            try {
                defaultTexture = TextureManager.loadTexture(TextureState.class.getResource("notloaded.png"), 2, 1, 0.0f, true);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Failed to load default texture: notloaded.png", exception);
            }
        }
    }

    public int getType() {
        return 6;
    }

    public void setTexture(Texture texture) {
        if (this.texture.size() == 0) {
            this.texture.add(texture);
        } else {
            this.texture.set(0, texture);
        }
        this.setNeedsRefresh(true);
        this.resetFirstLast();
    }

    public Texture getTexture() {
        if (this.texture.size() > 0) {
            return this.texture.get(0);
        }
        return null;
    }

    public void setTexture(Texture texture, int n) {
        if (n >= 0 && n < numTotalTexUnits) {
            while (n >= this.texture.size()) {
                this.texture.add(null);
            }
            this.texture.set(n, texture);
            this.resetFirstLast();
        }
        this.setNeedsRefresh(true);
    }

    public Texture getTexture(int n) {
        if (n < this.texture.size() && n >= 0) {
            return this.texture.get(n);
        }
        return null;
    }

    public boolean removeTexture(Texture texture) {
        int n = this.texture.indexOf(texture);
        if (n == -1) {
            return false;
        }
        this.texture.set(n, null);
        this.idCache[n] = 0;
        return true;
    }

    public boolean removeTexture(int n) {
        if (n < 0 || n >= numTotalTexUnits || n >= this.texture.size()) {
            return false;
        }
        Texture texture = this.texture.get(n);
        if (texture == null) {
            return false;
        }
        this.texture.set(n, null);
        this.idCache[n] = 0;
        return true;
    }

    public void clearTextures() {
        int n = this.texture.size();
        while (--n >= 0) {
            this.removeTexture(n);
        }
    }

    public void setCorrection(int n) {
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.correction = n;
        this.setNeedsRefresh(true);
    }

    public int getCorrection() {
        return this.correction;
    }

    public static int getTotalNumberOfUnits() {
        return numTotalTexUnits;
    }

    public static int getNumberOfFixedUnits() {
        return numFixedTexUnits;
    }

    public static int getNumberOfVertexUnits() {
        return numVertexTexUnits;
    }

    public static int getNumberOfFragmentUnits() {
        return numFragmentTexUnits;
    }

    public static int getNumberOfFragmentTexCoordUnits() {
        return numFragmentTexCoordUnits;
    }

    public static int getNumberOfTotalUnits() {
        return numTotalTexUnits;
    }

    public int getNumberOfSetTextures() {
        return this.texture.size();
    }

    public final int getTextureID(int n) {
        if (n < this.idCache.length && n >= 0) {
            return this.idCache[n];
        }
        return 0;
    }

    public void setTextureCoordinateOffset(int n) {
        this.offset = n;
        this.setNeedsRefresh(true);
    }

    public int getTextureCoordinateOffset() {
        return this.offset;
    }

    public void load() {
        for (int i = 0; i < numTotalTexUnits; ++i) {
            if (this.getTexture(i) == null) continue;
            this.load(i);
        }
    }

    public abstract void load(int var1);

    public abstract void delete(int var1);

    public abstract void deleteAll();

    public abstract void deleteAll(boolean var1);

    public float getMaxAnisotropic() {
        return maxAnisotropic;
    }

    protected void resetFirstLast() {
        boolean bl = false;
        for (int i = 0; i < this.texture.size(); ++i) {
            if (this.texture.get(i) == null) continue;
            if (!bl) {
                this.firstTexture = i;
                bl = true;
            }
            this.lastTexture = i;
        }
        if (this.idCache == null || this.idCache.length <= this.lastTexture) {
            if (this.idCache == null || this.idCache.length == 0) {
                this.idCache = new int[this.lastTexture + 2];
            } else {
                int[] nArray = new int[this.lastTexture + 2];
                System.arraycopy(this.idCache, 0, nArray, 0, this.idCache.length);
                this.idCache = nArray;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readShort();
        this.texture = new ArrayList(1);
        for (int i = 0; i < n; ++i) {
            if (!objectInputStream.readBoolean()) continue;
            this.texture.add(TextureManager.loadTexture(new URL(objectInputStream.readUTF()), objectInputStream.readInt(), objectInputStream.readInt()));
        }
        this.resetFirstLast();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(this.texture.size());
        for (int i = 0; i < this.texture.size(); ++i) {
            if (this.texture.get(i) == null) {
                objectOutputStream.writeBoolean(false);
                continue;
            }
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(this.texture.get(i).getImageLocation());
            objectOutputStream.writeInt(this.texture.get(i).getMipmapState());
            objectOutputStream.writeInt(this.texture.get(i).getFilter());
        }
    }

    public static boolean isMultiTextureSupported() {
        return supportsMultiTexture;
    }

    public static void overrideMultiTextureSupport(boolean bl) {
        supportsMultiTexture = bl;
    }

    public static void resetMultiTextureSupport() {
        supportsMultiTexture = supportsMultiTextureDetected;
    }

    public static boolean isEnvDot3Supported() {
        return supportsEnvDot3;
    }

    public static void overrideEnvDot3Support(boolean bl) {
        supportsEnvDot3 = bl;
    }

    public static void resetEnvDot3Support() {
        supportsEnvDot3 = supportsEnvDot3Detected;
    }

    public static boolean isEnvCombineSupported() {
        return supportsEnvCombine;
    }

    public static void overrideEnvCombineSupport(boolean bl) {
        supportsEnvCombine = bl;
    }

    public static void resetEnvCombineSupport() {
        supportsEnvCombine = supportsEnvCombineDetected;
    }

    public boolean isS3TCSupported() {
        return supportsS3TCCompression;
    }

    public static void overrideS3TCSupport(boolean bl) {
        supportsS3TCCompression = bl;
    }

    public static void resetS3TCSupport() {
        supportsS3TCCompression = supportsS3TCCompressionDetected;
    }

    public static boolean isAnisoSupported() {
        return supportsAniso;
    }

    public static void overrideAnisoSupport(boolean bl) {
        supportsAniso = bl;
    }

    public static void resetAnisoSupport() {
        supportsAniso = supportsAnisoDetected;
    }

    public static boolean isNonPowerOfTwoTextureSupported() {
        return supportsNonPowerTwo;
    }

    public static void overrideNonPowerOfTwoTextureSupport(boolean bl) {
        supportsNonPowerTwo = bl;
    }

    public static void resetNonPowerOfTwoTextureSupport() {
        supportsNonPowerTwo = supportsNonPowerTwoDetected;
    }

    public static boolean isRectangularTextureSupported() {
        return supportsRectangular;
    }

    public static void overrideRectangularTextureSupport(boolean bl) {
        supportsRectangular = bl;
    }

    public static void resetRectangularTextureSupport() {
        supportsRectangular = supportsRectangularDetected;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.texture, "texture", new ArrayList(1));
        outputCapsule.write(this.offset, "offset", 0);
        outputCapsule.write(this.correction, "correction", 1);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.texture = inputCapsule.readSavableArrayList("texture", new ArrayList(1));
        this.offset = inputCapsule.readInt("offset", 0);
        this.correction = inputCapsule.readInt("correction", 1);
        this.resetFirstLast();
    }

    public Class getClassTag() {
        return TextureState.class;
    }

    public void deleteTextureId(int n) {
    }

    public static Image getDefaultTextureImage() {
        return defaultTexture != null ? defaultTexture.getImage() : null;
    }

    public static Texture getDefaultTexture() {
        return defaultTexture;
    }
}

