/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public abstract class FogState
extends RenderState {
    public static final int DF_LINEAR = 0;
    public static final int DF_EXP = 1;
    public static final int DF_EXPSQR = 2;
    public static final int AF_PER_VERTEX = 0;
    public static final int AF_PER_PIXEL = 1;
    protected float start;
    protected float end;
    protected float density;
    protected ColorRGBA color = new ColorRGBA();
    protected int densityFunction = 0;
    protected int applyFunction = 0;

    public void setApplyFunction(int n) {
        if (n < 0 || n > 1) {
            n = 0;
        }
        this.applyFunction = n;
        this.setNeedsRefresh(true);
    }

    public void setDensityFunction(int n) {
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.densityFunction = n;
        this.setNeedsRefresh(true);
    }

    public void setColor(ColorRGBA colorRGBA) {
        this.color.set(colorRGBA);
        this.setNeedsRefresh(true);
    }

    public void setDensity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.density = f;
        this.setNeedsRefresh(true);
    }

    public void setEnd(float f) {
        this.end = f;
        this.setNeedsRefresh(true);
    }

    public void setStart(float f) {
        this.start = f;
        this.setNeedsRefresh(true);
    }

    public int getType() {
        return 2;
    }

    public int getApplyFunction() {
        return this.applyFunction;
    }

    public ColorRGBA getColor() {
        return this.color;
    }

    public float getDensity() {
        return this.density;
    }

    public int getDensityFunction() {
        return this.densityFunction;
    }

    public float getEnd() {
        return this.end;
    }

    public float getStart() {
        return this.start;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.start, "start", 0.0f);
        outputCapsule.write(this.end, "end", 0.0f);
        outputCapsule.write(this.density, "density", 0.0f);
        outputCapsule.write(this.color, "color", ColorRGBA.black);
        outputCapsule.write(this.densityFunction, "densityFunction", 0);
        outputCapsule.write(this.applyFunction, "applyFunction", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.start = inputCapsule.readFloat("start", 0.0f);
        this.end = inputCapsule.readFloat("end", 0.0f);
        this.density = inputCapsule.readFloat("density", 0.0f);
        this.color = (ColorRGBA)inputCapsule.readSavable("color", ColorRGBA.black.clone());
        this.densityFunction = inputCapsule.readInt("densityFunction", 0);
        this.applyFunction = inputCapsule.readInt("applyFunction", 0);
    }

    public Class getClassTag() {
        return FogState.class;
    }
}

