/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;

public class Quad
extends TriMesh {
    private static final long serialVersionUID = 1L;

    public Quad() {
    }

    public Quad(String string) {
        this(string, 1.0f, 1.0f);
    }

    public Quad(String string, float f, float f2) {
        super(string);
        this.initialize(f, f2);
    }

    public void resize(float f, float f2) {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getVertexBuffer().clear();
        triangleBatch.getVertexBuffer().put(-f / 2.0f).put(f2 / 2.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(-f / 2.0f).put(-f2 / 2.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(f / 2.0f).put(-f2 / 2.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(f / 2.0f).put(f2 / 2.0f).put(0.0f);
    }

    public void initialize(float f, float f2) {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(4);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer(triangleBatch.getVertexCount());
        this.setTextureBuffer(0, floatBuffer);
        triangleBatch.setTriangleQuantity(2);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getTriangleCount() * 3));
        triangleBatch.getVertexBuffer().put(-f / 2.0f).put(f2 / 2.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(-f / 2.0f).put(-f2 / 2.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(f / 2.0f).put(-f2 / 2.0f).put(0.0f);
        triangleBatch.getVertexBuffer().put(f / 2.0f).put(f2 / 2.0f).put(0.0f);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        floatBuffer.put(0.0f).put(1.0f);
        floatBuffer.put(0.0f).put(0.0f);
        floatBuffer.put(1.0f).put(0.0f);
        floatBuffer.put(1.0f).put(1.0f);
        triangleBatch.getIndexBuffer().put(0);
        triangleBatch.getIndexBuffer().put(1);
        triangleBatch.getIndexBuffer().put(2);
        triangleBatch.getIndexBuffer().put(0);
        triangleBatch.getIndexBuffer().put(2);
        triangleBatch.getIndexBuffer().put(3);
    }

    public Vector3f getCenter() {
        return this.worldTranslation;
    }
}

