/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Dome
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private int planes;
    private int radialSamples;
    public float radius;
    public Vector3f center;
    private static Vector3f tempVa = new Vector3f();
    private static Vector3f tempVb = new Vector3f();
    private static Vector3f tempVc = new Vector3f();

    public Dome() {
    }

    public Dome(String string) {
        super(string);
    }

    public Dome(String string, int n, int n2, float f) {
        this(string, new Vector3f(0.0f, 0.0f, 0.0f), n, n2, f);
    }

    public Dome(String string, Vector3f vector3f, int n, int n2, float f) {
        super(string);
        this.setData(vector3f, n, n2, f, true, true);
    }

    public Dome(String string, Vector3f vector3f, int n, int n2, float f, boolean bl) {
        super(string);
        this.setData(vector3f, n, n2, f, true, bl);
    }

    public void setData(Vector3f vector3f, int n, int n2, float f, boolean bl, boolean bl2) {
        this.center = vector3f != null ? vector3f : new Vector3f(0.0f, 0.0f, 0.0f);
        this.planes = n;
        this.radialSamples = n2;
        this.radius = f;
        if (bl) {
            this.setGeometryData(bl2);
            this.setIndexData(bl2);
        }
    }

    private void setGeometryData(boolean bl) {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount((this.planes - 1) * (this.radialSamples + 1) + 1);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        float f = 1.0f / (float)this.radialSamples;
        float f2 = 1.0f / (float)(this.planes - 1);
        float[] fArray = new float[this.radialSamples];
        float[] fArray2 = new float[this.radialSamples];
        for (n = 0; n < this.radialSamples; ++n) {
            float f3 = (float)Math.PI * 2 * f * (float)n;
            fArray2[n] = FastMath.cos(f3);
            fArray[n] = FastMath.sin(f3);
        }
        n = 0;
        for (int i = 0; i < this.planes - 1; ++i) {
            float f4 = f2 * (float)i;
            float f5 = this.radius * f4;
            Vector3f vector3f = tempVb.set(this.center);
            vector3f.y += f5;
            float f6 = FastMath.sqrt(FastMath.abs(this.radius * this.radius - f5 * f5));
            int n2 = n;
            for (int j = 0; j < this.radialSamples; ++j) {
                float f7 = (float)j * f;
                Vector3f vector3f2 = tempVc.set(fArray2[j], 0.0f, fArray[j]);
                vector3f2.mult(f6, tempVa);
                triangleBatch.getVertexBuffer().put(vector3f.x + Dome.tempVa.x).put(vector3f.y + Dome.tempVa.y).put(vector3f.z + Dome.tempVa.z);
                BufferUtils.populateFromBuffer(tempVa, triangleBatch.getVertexBuffer(), n);
                Vector3f vector3f3 = tempVa.subtractLocal(this.center);
                vector3f3.normalizeLocal();
                if (bl) {
                    triangleBatch.getNormalBuffer().put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
                } else {
                    triangleBatch.getNormalBuffer().put(-vector3f3.x).put(-vector3f3.y).put(-vector3f3.z);
                }
                triangleBatch.getTextureBuffers().get(0).put(f7).put(f4);
                ++n;
            }
            BufferUtils.copyInternalVector3(triangleBatch.getVertexBuffer(), n2, n);
            BufferUtils.copyInternalVector3(triangleBatch.getNormalBuffer(), n2, n);
            triangleBatch.getTextureBuffers().get(0).put(1.0f).put(f4);
            ++n;
        }
        triangleBatch.getVertexBuffer().put(this.center.x).put(this.center.y + this.radius).put(this.center.z);
        if (bl) {
            triangleBatch.getNormalBuffer().put(0.0f).put(1.0f).put(0.0f);
        } else {
            triangleBatch.getNormalBuffer().put(0.0f).put(-1.0f).put(0.0f);
        }
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(1.0f);
    }

    private void setIndexData(boolean bl) {
        int n;
        int n2;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setTriangleQuantity((this.planes - 2) * this.radialSamples * 2 + this.radialSamples);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        int n3 = 0;
        for (n2 = 1; n2 < this.planes - 1; ++n2) {
            n = (n2 - 1) * (this.radialSamples + 1);
            int n4 = n2 * (this.radialSamples + 1);
            int n5 = 0;
            while (n5 < this.radialSamples) {
                if (!bl) {
                    triangleBatch.getIndexBuffer().put(n + n5);
                    triangleBatch.getIndexBuffer().put(n + n5 + 1);
                    triangleBatch.getIndexBuffer().put(n4 + n5);
                    triangleBatch.getIndexBuffer().put(n + n5 + 1);
                    triangleBatch.getIndexBuffer().put(n4 + n5 + 1);
                    triangleBatch.getIndexBuffer().put(n4 + n5);
                } else {
                    triangleBatch.getIndexBuffer().put(n + n5);
                    triangleBatch.getIndexBuffer().put(n4 + n5);
                    triangleBatch.getIndexBuffer().put(n + n5 + 1);
                    triangleBatch.getIndexBuffer().put(n + n5 + 1);
                    triangleBatch.getIndexBuffer().put(n4 + n5);
                    triangleBatch.getIndexBuffer().put(n4 + n5 + 1);
                }
                ++n5;
                n3 += 6;
            }
        }
        n2 = (this.planes - 2) * (this.radialSamples + 1);
        n = 0;
        while (n < this.radialSamples) {
            if (!bl) {
                triangleBatch.getIndexBuffer().put(n2 + n);
                triangleBatch.getIndexBuffer().put(n2 + n + 1);
                triangleBatch.getIndexBuffer().put(triangleBatch.getVertexCount() - 1);
            } else {
                triangleBatch.getIndexBuffer().put(n2 + n);
                triangleBatch.getIndexBuffer().put(triangleBatch.getVertexCount() - 1);
                triangleBatch.getIndexBuffer().put(n2 + n + 1);
            }
            ++n;
            n3 += 3;
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.planes, "planes", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.radius, "radius", 0.0f);
        outputCapsule.write(this.center, "center", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.planes = inputCapsule.readInt("planes", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.radius = inputCapsule.readFloat("radius", 0.0f);
        this.center = (Vector3f)inputCapsule.readSavable("center", Vector3f.ZERO.clone());
    }
}

