/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Disk
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private int shellSamples;
    private int radialSamples;
    private float radius;

    public Disk() {
    }

    public Disk(String string, int n, int n2, float f) {
        super(string);
        this.shellSamples = n;
        this.radialSamples = n2;
        this.radius = f;
        int n3 = n2 - 1;
        int n4 = n - 1;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(1 + n2 * n4);
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity(n2 * (2 * n4 - 1));
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        this.setGeometryData(n4);
        this.setIndexData(n3, n4);
    }

    private void setGeometryData(int n) {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.getVertexBuffer().put(0.0f).put(0.0f).put(0.0f);
        for (int i = 0; i < triangleBatch.getVertexCount(); ++i) {
            triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1.0f);
        }
        triangleBatch.getTextureBuffers().get(0).put(0.5f).put(0.5f);
        float f = 1.0f / (float)n;
        float f2 = 1.0f / (float)this.radialSamples;
        Vector3f vector3f = new Vector3f();
        Vector2f vector2f = new Vector2f();
        for (int i = 0; i < this.radialSamples; ++i) {
            float f3 = (float)Math.PI * 2 * f2 * (float)i;
            float f4 = FastMath.cos(f3);
            float f5 = FastMath.sin(f3);
            Vector3f vector3f2 = new Vector3f(f4, f5, 0.0f);
            for (int j = 1; j < this.shellSamples; ++j) {
                float f6 = f * (float)j;
                vector3f.set(vector3f2).multLocal(f6);
                int n2 = j + n * i;
                vector2f.x = 0.5f * (1.0f + vector3f.x);
                vector2f.y = 0.5f * (1.0f + vector3f.y);
                BufferUtils.setInBuffer(vector2f, triangleBatch.getTextureBuffers().get(0), n2);
                vector3f.multLocal(this.radius);
                BufferUtils.setInBuffer(vector3f, triangleBatch.getVertexBuffer(), n2);
            }
        }
    }

    private void setIndexData(int n, int n2) {
        TriangleBatch triangleBatch = this.getBatch(0);
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        while (n5 < this.radialSamples) {
            triangleBatch.getIndexBuffer().put(0);
            triangleBatch.getIndexBuffer().put(1 + n2 * n4);
            triangleBatch.getIndexBuffer().put(1 + n2 * n5);
            n3 += 3;
            int n6 = 1;
            while (n6 < n2) {
                int n7 = n6 + n2 * n4;
                int n8 = n6 + n2 * n5;
                int n9 = n7 + 1;
                int n10 = n8 + 1;
                triangleBatch.getIndexBuffer().put(n7);
                triangleBatch.getIndexBuffer().put(n9);
                triangleBatch.getIndexBuffer().put(n10);
                triangleBatch.getIndexBuffer().put(n7);
                triangleBatch.getIndexBuffer().put(n10);
                triangleBatch.getIndexBuffer().put(n8);
                ++n6;
                n3 += 6;
            }
            n4 = n5++;
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.shellSamples, "shellSamples", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.radius, "radius", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.shellSamples = inputCapsule.readInt("shellSamples", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.radius = inputCapsule.readFloat("raidus", 0.0f);
    }
}

