/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Cylinder
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private int axisSamples;
    private int radialSamples;
    private float radius;
    private float radius2;
    private float height;
    private boolean closed;
    private boolean inverted;

    public Cylinder() {
    }

    public Cylinder(String string, int n, int n2, float f, float f2) {
        this(string, n, n2, f, f2, false);
    }

    public Cylinder(String string, int n, int n2, float f, float f2, boolean bl) {
        this(string, n, n2, f, f2, bl, false);
    }

    public Cylinder(String string, int n, int n2, float f, float f2, boolean bl, boolean bl2) {
        super(string);
        this.axisSamples = n + (bl ? 2 : 0);
        this.radialSamples = n2;
        this.setRadius(f);
        this.height = f2;
        this.closed = bl;
        this.inverted = bl2;
        this.allocateVertices();
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = f;
        this.allocateVertices();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
        this.radius2 = f;
        this.allocateVertices();
    }

    public void setRadius1(float f) {
        this.radius = f;
        this.allocateVertices();
    }

    public void setRadius2(float f) {
        this.radius2 = f;
        this.allocateVertices();
    }

    public int getAxisSamples() {
        return this.axisSamples;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    private void allocateVertices() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount(this.axisSamples * (this.radialSamples + 1) + (this.closed ? 2 : 0));
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getNormalBuffer(), triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setTriangleQuantity(((this.closed ? 2 : 0) + 2 * (this.axisSamples - 1)) * this.radialSamples);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(triangleBatch.getIndexBuffer(), 3 * triangleBatch.getTriangleCount()));
        this.setGeometryData();
        this.setIndexData();
    }

    private void setGeometryData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        float f = 1.0f / (float)this.radialSamples;
        float f2 = 1.0f / (float)(this.closed ? this.axisSamples - 3 : this.axisSamples - 1);
        float f3 = 1.0f / (float)(this.axisSamples - 1);
        float f4 = 0.5f * this.height;
        float[] fArray = new float[this.radialSamples + 1];
        float[] fArray2 = new float[this.radialSamples + 1];
        for (int i = 0; i < this.radialSamples; ++i) {
            float f5 = (float)Math.PI * 2 * f * (float)i;
            fArray2[i] = FastMath.cos(f5);
            fArray[i] = FastMath.sin(f5);
        }
        fArray[this.radialSamples] = fArray[0];
        fArray2[this.radialSamples] = fArray2[0];
        Vector3f vector3f = new Vector3f();
        int n = 0;
        for (int i = 0; i < this.axisSamples; ++i) {
            float f6;
            float f7;
            int n2 = 0;
            if (!this.closed) {
                f6 = f7 = (float)i * f2;
            } else if (i == 0) {
                n2 = -1;
                f7 = 0.0f;
                f6 = f3;
            } else if (i == this.axisSamples - 1) {
                n2 = 1;
                f7 = 1.0f;
                f6 = 1.0f - f3;
            } else {
                f7 = (float)(i - 1) * f2;
                f6 = (float)i * f3;
            }
            float f8 = -f4 + this.height * f7;
            Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, f8);
            int n3 = n;
            for (int j = 0; j < this.radialSamples; ++j) {
                float f9 = (float)j * f;
                vector3f.set(fArray2[j], fArray[j], 0.0f);
                if (n2 == 0) {
                    if (!this.inverted) {
                        triangleBatch.getNormalBuffer().put(vector3f.x).put(vector3f.y).put(vector3f.z);
                    } else {
                        triangleBatch.getNormalBuffer().put(-vector3f.x).put(-vector3f.y).put(-vector3f.z);
                    }
                } else {
                    triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(n2 * (this.inverted ? -1 : 1));
                }
                vector3f.multLocal((this.radius - this.radius2) * f7 + this.radius2).addLocal(vector3f2);
                triangleBatch.getVertexBuffer().put(vector3f.x).put(vector3f.y).put(vector3f.z);
                triangleBatch.getTextureBuffer(0).put(this.inverted ? 1.0f - f9 : f9).put(f6);
                ++n;
            }
            BufferUtils.copyInternalVector3(triangleBatch.getVertexBuffer(), n3, n);
            BufferUtils.copyInternalVector3(triangleBatch.getNormalBuffer(), n3, n);
            triangleBatch.getTextureBuffer(0).put(this.inverted ? 0.0f : 1.0f).put(f6);
            ++n;
        }
        if (this.closed) {
            triangleBatch.getVertexBuffer().put(0.0f).put(0.0f).put(-f4);
            triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(-1 * (this.inverted ? -1 : 1));
            triangleBatch.getTextureBuffers().get(0).put(0.5f).put(0.0f);
            triangleBatch.getVertexBuffer().put(0.0f).put(0.0f).put(f4);
            triangleBatch.getNormalBuffer().put(0.0f).put(0.0f).put(1 * (this.inverted ? -1 : 1));
            triangleBatch.getTextureBuffers().get(0).put(0.5f).put(1.0f);
        }
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        int n = 0;
        for (int i = 0; i < this.axisSamples - 1; ++i) {
            int n2 = n;
            int n3 = n2 + 1;
            int n4 = n += this.radialSamples + 1;
            int n5 = n4 + 1;
            for (int j = 0; j < this.radialSamples; ++j) {
                if (this.closed && i == 0) {
                    if (!this.inverted) {
                        triangleBatch.getIndexBuffer().put(n2++);
                        triangleBatch.getIndexBuffer().put(this.getVertexCount() - 2);
                        triangleBatch.getIndexBuffer().put(n3++);
                        continue;
                    }
                    triangleBatch.getIndexBuffer().put(n2++);
                    triangleBatch.getIndexBuffer().put(n3++);
                    triangleBatch.getIndexBuffer().put(this.getVertexCount() - 2);
                    continue;
                }
                if (this.closed && i == this.axisSamples - 2) {
                    if (!this.inverted) {
                        triangleBatch.getIndexBuffer().put(n4++);
                        triangleBatch.getIndexBuffer().put(n5++);
                        triangleBatch.getIndexBuffer().put(this.getVertexCount() - 1);
                        continue;
                    }
                    triangleBatch.getIndexBuffer().put(n4++);
                    triangleBatch.getIndexBuffer().put(this.getVertexCount() - 1);
                    triangleBatch.getIndexBuffer().put(n5++);
                    continue;
                }
                if (!this.inverted) {
                    triangleBatch.getIndexBuffer().put(n2++);
                    triangleBatch.getIndexBuffer().put(n3);
                    triangleBatch.getIndexBuffer().put(n4);
                    triangleBatch.getIndexBuffer().put(n3++);
                    triangleBatch.getIndexBuffer().put(n5++);
                    triangleBatch.getIndexBuffer().put(n4++);
                    continue;
                }
                triangleBatch.getIndexBuffer().put(n2++);
                triangleBatch.getIndexBuffer().put(n4);
                triangleBatch.getIndexBuffer().put(n3);
                triangleBatch.getIndexBuffer().put(n3++);
                triangleBatch.getIndexBuffer().put(n4++);
                triangleBatch.getIndexBuffer().put(n5++);
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.axisSamples, "axisSamples", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.radius, "radius", 0.0f);
        outputCapsule.write(this.radius2, "radius2", 0.0f);
        outputCapsule.write(this.height, "height", 0.0f);
        outputCapsule.write(this.closed, "closed", false);
        outputCapsule.write(this.inverted, "inverted", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.axisSamples = inputCapsule.readInt("axisSamples", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.radius = inputCapsule.readFloat("radius", 0.0f);
        this.radius2 = inputCapsule.readFloat("radius2", 0.0f);
        this.height = inputCapsule.readFloat("height", 0.0f);
        this.closed = inputCapsule.readBoolean("closed", false);
        this.inverted = inputCapsule.readBoolean("inverted", false);
    }
}

