/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.lod;

import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.Renderer;
import com.jme.scene.SwitchModel;
import com.jme.scene.SwitchNode;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;

public class DiscreteLodNode
extends SwitchNode
implements Savable {
    private static final long serialVersionUID = 1L;
    private Vector3f modelCenter;
    private Vector3f worldCenter = new Vector3f();
    private static Vector3f tmpVs = new Vector3f();
    private SwitchModel model;

    public DiscreteLodNode() {
    }

    public DiscreteLodNode(String string, SwitchModel switchModel) {
        super(string);
        this.model = switchModel;
        this.modelCenter = new Vector3f();
    }

    public void selectLevelOfDetail(Camera camera) {
        if (this.model == null) {
            return;
        }
        this.worldCenter = this.worldRotation.multLocal(this.worldCenter.set(this.modelCenter)).multLocal(this.worldScale).addLocal(this.worldTranslation);
        float f = tmpVs.set(this.worldScale).multLocal(this.worldScale).length();
        this.model.set(this.worldCenter.subtractLocal(camera.getLocation()));
        this.model.set(new Float(f));
        this.setActiveChild(this.model.getSwitchChild());
    }

    public void draw(Renderer renderer) {
        this.selectLevelOfDetail(renderer.getCamera());
        super.draw(renderer);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.modelCenter, "modelCenter", Vector3f.ZERO);
        outputCapsule.write(this.worldCenter, "worldCenter", Vector3f.ZERO);
        outputCapsule.write(this.model, "model", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.modelCenter = (Vector3f)inputCapsule.readSavable("modelCenter", Vector3f.ZERO.clone());
        this.worldCenter = (Vector3f)inputCapsule.readSavable("worldCenter", Vector3f.ZERO.clone());
        this.model = (SwitchModel)inputCapsule.readSavable("model", null);
    }
}

