/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.scene.Node;
import com.jme.scene.Spatial;
import junit.framework.TestCase;

public class TestNode
extends TestCase {
    private Node root;

    protected void setUp() throws Exception {
        this.root = new Node("root");
    }

    public void testInit() {
        TestNode.assertEquals((int)0, (int)this.root.getQuantity());
        TestNode.assertEquals((int)0, (int)this.root.getVertexCount());
        TestNode.assertEquals((int)0, (int)this.root.getTriangleCount());
        TestNode.assertNull((Object)this.root.getParent());
        TestNode.assertNull((Object)this.root.getChild(5));
        TestNode.assertNull((Object)this.root.getChild("test"));
        TestNode.assertEquals((String)"root", (String)this.root.getName());
    }

    public void testHierarchy() {
        Node node = new Node("child1");
        Node node2 = new Node("child2");
        Node node3 = new Node("child3");
        this.root.attachChild(node);
        this.root.attachChild(node2);
        this.root.attachChild(node3);
        TestNode.assertEquals((int)3, (int)this.root.getQuantity());
        TestNode.assertEquals((Object)node2, (Object)this.root.getChild(1));
        TestNode.assertEquals((Object)node2, (Object)this.root.getChild("child2"));
        TestNode.assertEquals((Object)this.root, (Object)node.getParent());
        Spatial spatial = this.root.detachChildAt(2);
        TestNode.assertEquals((Object)node3, (Object)spatial);
        TestNode.assertEquals((int)2, (int)this.root.getQuantity());
        int n = this.root.detachChild(node2);
        TestNode.assertEquals((int)1, (int)n);
        TestNode.assertEquals((int)1, (int)this.root.getQuantity());
        n = this.root.detachChildNamed("not a child");
        TestNode.assertEquals((int)-1, (int)n);
        TestNode.assertEquals((int)1, (int)this.root.getQuantity());
        n = this.root.detachChildNamed("child1");
        TestNode.assertEquals((int)0, (int)n);
        TestNode.assertEquals((int)0, (int)this.root.getQuantity());
        this.root.attachChild(node);
        this.root.attachChild(node2);
        this.root.attachChildAt(node3, 1);
        TestNode.assertEquals((int)3, (int)this.root.getQuantity());
        TestNode.assertEquals((Object)node3, (Object)this.root.getChild(1));
        TestNode.assertEquals((int)2, (int)this.root.getChildIndex(node2));
        this.root.detachAllChildren();
        TestNode.assertEquals((int)0, (int)this.root.getQuantity());
    }
}

