/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.renderer.Camera;
import com.jme.scene.Node;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class CameraNode
extends Node {
    private static final long serialVersionUID = 1L;
    private Camera camera;

    public CameraNode() {
    }

    public CameraNode(String string, Camera camera) {
        super(string);
        this.camera = camera;
    }

    public void updateFromCamera() {
        this.getLocalRotation().fromAxes(this.camera.getLeft(), this.camera.getUp(), this.camera.getDirection());
        this.getLocalTranslation().set(this.camera.getLocation());
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        if (this.camera != null) {
            this.camera.setFrame(this.worldTranslation, this.worldRotation);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.camera, "camera", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.camera = (Camera)inputCapsule.readSavable("camera", null);
    }
}

