/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.lwjgl;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.lwjgl.LWJGLRenderer;
import com.jme.scene.state.lwjgl.records.RendererRecord;
import com.jme.system.DisplaySystem;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class LWJGLFont {
    public static final int NORMAL = 0;
    public static final int ITALICS = 1;
    private int base;
    private ByteBuffer scratch;
    private ColorRGBA fontColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);

    public LWJGLFont() {
        this.scratch = BufferUtils.createByteBuffer(1);
        this.buildDisplayList();
    }

    public void deleteFont() {
        GL11.glDeleteLists(this.base, 256);
    }

    public void setColor(ColorRGBA colorRGBA) {
        this.fontColor.set(colorRGBA);
    }

    public void print(LWJGLRenderer lWJGLRenderer, int n, int n2, Vector3f vector3f, StringBuffer stringBuffer, int n3) {
        RendererRecord rendererRecord = (RendererRecord)DisplaySystem.getDisplaySystem().getCurrentContext().getRendererRecord();
        if (n3 > 1) {
            n3 = 1;
        } else if (n3 < 0) {
            n3 = 0;
        }
        boolean bl = lWJGLRenderer.isInOrthoMode();
        if (!bl) {
            lWJGLRenderer.setOrtho();
        } else {
            rendererRecord.switchMode(5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
        }
        GL11.glTranslatef(n, n2, 0.0f);
        GL11.glScalef(vector3f.x, vector3f.y, vector3f.z);
        GL11.glListBase(this.base - 32 + 128 * n3);
        if (stringBuffer.length() > this.scratch.capacity()) {
            this.scratch = BufferUtils.createByteBuffer(stringBuffer.length());
        } else {
            this.scratch.clear();
        }
        int n4 = stringBuffer.length();
        for (int i = 0; i < n4; ++i) {
            this.scratch.put((byte)stringBuffer.charAt(i));
        }
        this.scratch.flip();
        rendererRecord.setCurrentColor(this.fontColor);
        GL11.glCallLists(this.scratch);
        rendererRecord.setCurrentColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (!bl) {
            lWJGLRenderer.unsetOrtho();
        } else {
            rendererRecord.switchMode(5888);
            GL11.glPopMatrix();
        }
    }

    public void buildDisplayList() {
        this.base = GL11.glGenLists(256);
        for (int i = 0; i < 256; ++i) {
            float f = (float)(i % 16) / 16.0f;
            float f2 = (float)(i / 16) / 16.0f;
            GL11.glNewList(this.base + i, 4864);
            GL11.glBegin(7);
            GL11.glTexCoord2f(f, 1.0f - f2 - 0.0625f);
            GL11.glVertex2i(0, 0);
            GL11.glTexCoord2f(f + 0.0625f, 1.0f - f2 - 0.0625f);
            GL11.glVertex2i(16, 0);
            GL11.glTexCoord2f(f + 0.0625f, 1.0f - f2);
            GL11.glVertex2i(16, 16);
            GL11.glTexCoord2f(f, 1.0f - f2);
            GL11.glVertex2i(0, 16);
            GL11.glEnd();
            GL11.glTranslatef(10.0f, 0.0f, 0.0f);
            GL11.glEndList();
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nColor: " + this.fontColor.toString();
        return string;
    }
}

