/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Vector3f;
import junit.framework.TestCase;

public class TestVector3f
extends TestCase {
    private Vector3f vector1;
    private Vector3f vector2;

    protected void setUp() throws Exception {
        this.vector1 = new Vector3f(1.0f, 2.0f, 3.0f);
        this.vector2 = new Vector3f(4.0f, 5.0f, 6.0f);
    }

    public void testCreation() {
        Vector3f vector3f = new Vector3f();
        this.testVectorEquals("Init zero", vector3f, 0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(1.0f, 2.0f, 3.0f);
        this.testVectorEquals("Init something", vector3f2, 1.0f, 2.0f, 3.0f);
        Vector3f vector3f3 = new Vector3f(vector3f2);
        this.testVectorEquals("Init clone", vector3f3, 1.0f, 2.0f, 3.0f);
    }

    public void testSet() {
        Vector3f vector3f = new Vector3f();
        vector3f.set(1.0f, 2.0f, 3.0f);
        this.testVectorEquals("Set something", vector3f, 1.0f, 2.0f, 3.0f);
        vector3f.set(1, 5.0f);
        this.testVectorEquals("Set index", vector3f, 1.0f, 5.0f, 3.0f);
    }

    public void testEquals() {
        Vector3f vector3f = new Vector3f(1.0f, 2.0f, 3.0f);
        Vector3f vector3f2 = new Vector3f(1.0f, 2.0f, 3.0f);
        TestVector3f.assertTrue((String)"Equal vectors", (boolean)vector3f.equals(vector3f2));
        Vector3f vector3f3 = new Vector3f(4.0f, 5.0f, 6.0f);
        TestVector3f.assertFalse((String)"Not equal vectors", (boolean)vector3f2.equals(vector3f3));
    }

    public void testAdd() {
        Vector3f vector3f = this.vector1.add(this.vector2);
        this.testVectorEquals("Add", vector3f, 5.0f, 7.0f, 9.0f);
        vector3f = vector3f.add(-1.0f, 1.0f, 1.0f);
        this.testVectorEquals("Add", vector3f, 4.0f, 8.0f, 10.0f);
        vector3f.add(this.vector2, vector3f);
        this.testVectorEquals("Add", vector3f, 8.0f, 13.0f, 16.0f);
    }

    public void testAddLocal() {
        Vector3f vector3f = new Vector3f(this.vector1);
        vector3f.addLocal(this.vector2);
        this.testVectorEquals("Addlocal", vector3f, 5.0f, 7.0f, 9.0f);
        vector3f.addLocal(-1.0f, 1.0f, 1.0f);
        this.testVectorEquals("Addlocal", vector3f, 4.0f, 8.0f, 10.0f);
    }

    public void testSubtract() {
        Vector3f vector3f = this.vector1.subtract(this.vector2);
        this.testVectorEquals("Subtract", vector3f, -3.0f, -3.0f, -3.0f);
        vector3f = vector3f.subtract(-1.0f, 1.0f, 1.0f);
        this.testVectorEquals("Subtract", vector3f, -2.0f, -4.0f, -4.0f);
        vector3f.subtract(this.vector2, vector3f);
        this.testVectorEquals("Subtract", vector3f, -6.0f, -9.0f, -10.0f);
    }

    public void testSubtractLocal() {
        Vector3f vector3f = new Vector3f(this.vector1);
        vector3f.subtractLocal(this.vector2);
        this.testVectorEquals("Subtractlocal", vector3f, -3.0f, -3.0f, -3.0f);
        vector3f.subtractLocal(-1.0f, 1.0f, 1.0f);
        this.testVectorEquals("Subtractlocal", vector3f, -2.0f, -4.0f, -4.0f);
    }

    public void testMult() {
        Vector3f vector3f = this.vector1.mult(this.vector2);
        this.testVectorEquals("Mult", vector3f, 4.0f, 10.0f, 18.0f);
        vector3f = vector3f.mult(2.0f);
        this.testVectorEquals("Mult", vector3f, 8.0f, 20.0f, 36.0f);
        vector3f.mult(this.vector2, vector3f);
        this.testVectorEquals("Mult", vector3f, 32.0f, 100.0f, 216.0f);
    }

    public void testMultLocal() {
        Vector3f vector3f = new Vector3f(this.vector1);
        vector3f.multLocal(this.vector2);
        this.testVectorEquals("Multlocal", vector3f, 4.0f, 10.0f, 18.0f);
        vector3f.multLocal(2.0f);
        this.testVectorEquals("Multlocal", vector3f, 8.0f, 20.0f, 36.0f);
    }

    public void testCross() {
        Vector3f vector3f = this.vector1.cross(this.vector2);
        this.testVectorEquals("Cross", vector3f, -3.0f, 6.0f, -3.0f);
    }

    public void testLength() {
        float f = this.vector1.lengthSquared();
        TestVector3f.assertEquals((String)"Length", (float)14.0f, (float)f, (float)1.1920929E-7f);
        f = this.vector1.length();
        TestVector3f.assertEquals((String)"Length", (float)3.7416575f, (float)f, (float)1.1920929E-7f);
    }

    private void testVectorEquals(String string, Vector3f vector3f, float f, float f2, float f3) {
        boolean bl = true;
        if (Float.compare(f, vector3f.x) != 0) {
            bl = false;
        }
        if (Float.compare(f2, vector3f.y) != 0) {
            bl = false;
        }
        if (Float.compare(f3, vector3f.z) != 0) {
            bl = false;
        }
        if (!bl) {
            TestVector3f.fail((String)(string + " Excpected [" + f + ", " + f2 + ", " + f3 + "] but was [" + vector3f.x + ", " + vector3f.y + ", " + vector3f.z + "]"));
        }
    }

    private void testVectorEquals(String string, Vector3f vector3f, Vector3f vector3f2) {
        boolean bl = true;
        if (Float.compare(vector3f.x, vector3f2.x) != 0) {
            bl = false;
        }
        if (Float.compare(vector3f.y, vector3f2.y) != 0) {
            bl = false;
        }
        if (Float.compare(vector3f.z, vector3f2.z) != 0) {
            bl = false;
        }
        if (!bl) {
            TestVector3f.fail((String)(string + " Excpected [" + vector3f.x + ", " + vector3f.y + ", " + vector3f.z + "] but was [" + vector3f2.x + ", " + vector3f2.y + ", " + vector3f2.z + "]"));
        }
    }
}

