/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import org.junit.Assert;
import org.junit.Test;

public class TestMatrix4f {
    @Test
    public void testTranspose() {
        Matrix4f matrix4f = new Matrix4f();
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles(0.1f, 0.2f, 0.3f);
        matrix4f.setRotationQuaternion(quaternion);
        Matrix4f matrix4f2 = matrix4f.transpose();
        Assert.assertTrue((boolean)this.equalIdentity(matrix4f2.mult(matrix4f)));
        Assert.assertTrue((boolean)this.equalIdentity(matrix4f.mult(matrix4f2)));
    }

    @Test
    public void testScale() {
        Matrix4f matrix4f = new Matrix4f(0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f matrix4f2 = matrix4f.transpose();
        matrix4f.scale(new Vector3f(2.0f, 2.0f, 2.0f));
        Assert.assertTrue((matrix4f.mult(new Vector3f(1.0f, 0.0f, 0.0f)).lengthSquared() == 4.0f ? 1 : 0) != 0);
        matrix4f2.scale(new Vector3f(0.5f, 0.5f, 0.5f));
        Assert.assertTrue((boolean)this.equalIdentity(matrix4f.mult(matrix4f2)));
    }

    private boolean equalIdentity(Matrix4f matrix4f) {
        if ((double)Math.abs(matrix4f.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m33 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m03) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m13) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m20) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m21) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m23) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m30) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix4f.m31) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(matrix4f.m32) > 1.0E-4);
    }
}

