/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import org.junit.Assert;
import org.junit.Test;

public class TestMatrix3f {
    @Test
    public void testTranspose() {
        Matrix3f matrix3f = new Matrix3f();
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngles(0.1f, 0.2f, 0.3f);
        matrix3f.set(quaternion);
        Matrix3f matrix3f2 = matrix3f.transposeNew();
        Assert.assertTrue((boolean)this.equalIdentity(matrix3f2.mult(matrix3f)));
        Assert.assertTrue((boolean)this.equalIdentity(matrix3f.mult(matrix3f2)));
    }

    @Test
    public void testScale() {
        Matrix3f matrix3f = new Matrix3f(0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix3f matrix3f2 = matrix3f.transposeNew();
        matrix3f.scale(new Vector3f(2.0f, 2.0f, 2.0f));
        Assert.assertTrue((matrix3f.mult(new Vector3f(1.0f, 0.0f, 0.0f)).lengthSquared() == 4.0f ? 1 : 0) != 0);
        matrix3f2.scale(new Vector3f(0.5f, 0.5f, 0.5f));
        Assert.assertTrue((boolean)this.equalIdentity(matrix3f.mult(matrix3f2)));
    }

    private boolean equalIdentity(Matrix3f matrix3f) {
        if ((double)Math.abs(matrix3f.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(matrix3f.m20) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(matrix3f.m21) > 1.0E-4);
    }
}

