/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Matrix4f;
import com.jme.math.Vector3f;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;

public class Quaternion
implements Externalizable,
Savable {
    private static final Logger logger = Logger.getLogger(Quaternion.class.getName());
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;
    private static final Vector3f tmpYaxis = new Vector3f();
    private static final Vector3f tmpZaxis = new Vector3f();
    private static final Vector3f tmpXaxis = new Vector3f();

    public Quaternion() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Quaternion set(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        return this;
    }

    public Quaternion(float[] fArray) {
        this.fromAngles(fArray);
    }

    public Quaternion(Quaternion quaternion, Quaternion quaternion2, float f) {
        this.slerp(quaternion, quaternion2, f);
    }

    public Quaternion(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    public void loadIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public boolean isIdentity() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f && this.w == 1.0f;
    }

    public void fromAngles(float[] fArray) {
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Angles array must have three elements");
        }
        this.fromAngles(fArray[0], fArray[1], fArray[2]);
    }

    public void fromAngles(float f, float f2, float f3) {
        float f4 = FastMath.sin(f * 0.5f);
        float f5 = FastMath.cos(f * 0.5f);
        float f6 = FastMath.sin(f2 * 0.5f);
        float f7 = FastMath.cos(f2 * 0.5f);
        float f8 = FastMath.sin(f3 * 0.5f);
        float f9 = FastMath.cos(f3 * 0.5f);
        float f10 = f7 * f9;
        float f11 = f6 * f8;
        this.x = f10 * f4 + f11 * f5;
        this.y = f6 * f9 * f5 + f7 * f8 * f4;
        this.z = f7 * f8 * f5 - f6 * f9 * f4;
        this.w = f10 * f5 - f11 * f4;
    }

    public float[] toAngles(float[] fArray) {
        if (fArray == null) {
            fArray = new float[3];
        } else if (fArray.length != 3) {
            throw new IllegalArgumentException("Angles array must have three elements");
        }
        float f = this.w * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = f2 + f3 + f4 + f;
        float f6 = this.x * this.y + this.z * this.w;
        if ((double)f6 > 0.499 * (double)f5) {
            fArray[1] = 2.0f * FastMath.atan2(this.x, this.w);
            fArray[2] = 1.5707964f;
            fArray[0] = 0.0f;
        } else if ((double)f6 < -0.499 * (double)f5) {
            fArray[1] = -2.0f * FastMath.atan2(this.x, this.w);
            fArray[2] = -1.5707964f;
            fArray[0] = 0.0f;
        } else {
            fArray[1] = FastMath.atan2(2.0f * this.y * this.w - 2.0f * this.x * this.z, f2 - f3 - f4 + f);
            fArray[2] = FastMath.asin(2.0f * f6 / f5);
            fArray[0] = FastMath.atan2(2.0f * this.x * this.w - 2.0f * this.y * this.z, -f2 + f3 - f4 + f);
        }
        return fArray;
    }

    public void fromRotationMatrix(Matrix3f matrix3f) {
        this.fromRotationMatrix(matrix3f.m00, matrix3f.m01, matrix3f.m02, matrix3f.m10, matrix3f.m11, matrix3f.m12, matrix3f.m20, matrix3f.m21, matrix3f.m22);
    }

    public void fromRotationMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f + f5 + f9;
        if (f10 >= 0.0f) {
            float f11 = FastMath.sqrt(f10 + 1.0f);
            this.w = 0.5f * f11;
            f11 = 0.5f / f11;
            this.x = (f8 - f6) * f11;
            this.y = (f3 - f7) * f11;
            this.z = (f4 - f2) * f11;
        } else if (f > f5 && f > f9) {
            float f12 = FastMath.sqrt(1.0f + f - f5 - f9);
            this.x = f12 * 0.5f;
            f12 = 0.5f / f12;
            this.y = (f4 + f2) * f12;
            this.z = (f3 + f7) * f12;
            this.w = (f8 - f6) * f12;
        } else if (f5 > f9) {
            float f13 = FastMath.sqrt(1.0f + f5 - f - f9);
            this.y = f13 * 0.5f;
            f13 = 0.5f / f13;
            this.x = (f4 + f2) * f13;
            this.z = (f8 + f6) * f13;
            this.w = (f3 - f7) * f13;
        } else {
            float f14 = FastMath.sqrt(1.0f + f9 - f - f5);
            this.z = f14 * 0.5f;
            f14 = 0.5f / f14;
            this.x = (f3 + f7) * f14;
            this.y = (f8 + f6) * f14;
            this.w = (f4 - f2) * f14;
        }
    }

    public Matrix3f toRotationMatrix() {
        Matrix3f matrix3f = new Matrix3f();
        return this.toRotationMatrix(matrix3f);
    }

    public Matrix3f toRotationMatrix(Matrix3f matrix3f) {
        float f = this.norm();
        float f2 = f == 1.0f ? 2.0f : (f > 0.0f ? 2.0f / f : 0.0f);
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        float f6 = this.x * f3;
        float f7 = this.x * f4;
        float f8 = this.x * f5;
        float f9 = this.w * f3;
        float f10 = this.y * f4;
        float f11 = this.y * f5;
        float f12 = this.w * f4;
        float f13 = this.z * f5;
        float f14 = this.w * f5;
        matrix3f.m00 = 1.0f - (f10 + f13);
        matrix3f.m01 = f7 - f14;
        matrix3f.m02 = f8 + f12;
        matrix3f.m10 = f7 + f14;
        matrix3f.m11 = 1.0f - (f6 + f13);
        matrix3f.m12 = f11 - f9;
        matrix3f.m20 = f8 - f12;
        matrix3f.m21 = f11 + f9;
        matrix3f.m22 = 1.0f - (f6 + f10);
        return matrix3f;
    }

    public Matrix4f toRotationMatrix(Matrix4f matrix4f) {
        float f = this.norm();
        float f2 = f == 1.0f ? 2.0f : (f > 0.0f ? 2.0f / f : 0.0f);
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        float f6 = this.x * f3;
        float f7 = this.x * f4;
        float f8 = this.x * f5;
        float f9 = this.w * f3;
        float f10 = this.y * f4;
        float f11 = this.y * f5;
        float f12 = this.w * f4;
        float f13 = this.z * f5;
        float f14 = this.w * f5;
        matrix4f.m00 = 1.0f - (f10 + f13);
        matrix4f.m01 = f7 - f14;
        matrix4f.m02 = f8 + f12;
        matrix4f.m10 = f7 + f14;
        matrix4f.m11 = 1.0f - (f6 + f13);
        matrix4f.m12 = f11 - f9;
        matrix4f.m20 = f8 - f12;
        matrix4f.m21 = f11 + f9;
        matrix4f.m22 = 1.0f - (f6 + f10);
        return matrix4f;
    }

    public Vector3f getRotationColumn(int n) {
        return this.getRotationColumn(n, null);
    }

    public Vector3f getRotationColumn(int n, Vector3f vector3f) {
        float f;
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        if ((f = this.norm()) != 1.0f) {
            f = FastMath.invSqrt(f);
        }
        float f2 = this.x * this.x * f;
        float f3 = this.x * this.y * f;
        float f4 = this.x * this.z * f;
        float f5 = this.x * this.w * f;
        float f6 = this.y * this.y * f;
        float f7 = this.y * this.z * f;
        float f8 = this.y * this.w * f;
        float f9 = this.z * this.z * f;
        float f10 = this.z * this.w * f;
        switch (n) {
            case 0: {
                vector3f.x = 1.0f - 2.0f * (f6 + f9);
                vector3f.y = 2.0f * (f3 + f10);
                vector3f.z = 2.0f * (f4 - f8);
                break;
            }
            case 1: {
                vector3f.x = 2.0f * (f3 - f10);
                vector3f.y = 1.0f - 2.0f * (f2 + f9);
                vector3f.z = 2.0f * (f7 + f5);
                break;
            }
            case 2: {
                vector3f.x = 2.0f * (f4 + f8);
                vector3f.y = 2.0f * (f7 - f5);
                vector3f.z = 1.0f - 2.0f * (f2 + f6);
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new JmeException("Invalid column index. " + n);
            }
        }
        return vector3f;
    }

    public Quaternion fromAngleAxis(float f, Vector3f vector3f) {
        Vector3f vector3f2 = vector3f.normalize();
        this.fromAngleNormalAxis(f, vector3f2);
        return this;
    }

    public Quaternion fromAngleNormalAxis(float f, Vector3f vector3f) {
        float f2 = 0.5f * f;
        float f3 = FastMath.sin(f2);
        this.w = FastMath.cos(f2);
        this.x = f3 * vector3f.x;
        this.y = f3 * vector3f.y;
        this.z = f3 * vector3f.z;
        return this;
    }

    public float toAngleAxis(Vector3f vector3f) {
        float f;
        float f2 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (f2 == 0.0f) {
            f = 0.0f;
            vector3f.x = 1.0f;
            vector3f.y = 0.0f;
            vector3f.z = 0.0f;
        } else {
            f = 2.0f * FastMath.acos(this.w);
            float f3 = 1.0f / FastMath.sqrt(f2);
            vector3f.x = this.x * f3;
            vector3f.y = this.y * f3;
            vector3f.z = this.z * f3;
        }
        return f;
    }

    public Quaternion slerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        if (quaternion.x == quaternion2.x && quaternion.y == quaternion2.y && quaternion.z == quaternion2.z && quaternion.w == quaternion2.w) {
            this.set(quaternion);
            return this;
        }
        float f2 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (f2 < 0.0f) {
            quaternion2.x = -quaternion2.x;
            quaternion2.y = -quaternion2.y;
            quaternion2.z = -quaternion2.z;
            quaternion2.w = -quaternion2.w;
            f2 = -f2;
        }
        float f3 = 1.0f - f;
        float f4 = f;
        if (1.0f - f2 > 0.1f) {
            float f5 = FastMath.acos(f2);
            float f6 = 1.0f / FastMath.sin(f5);
            f3 = FastMath.sin((1.0f - f) * f5) * f6;
            f4 = FastMath.sin(f * f5) * f6;
        }
        this.x = f3 * quaternion.x + f4 * quaternion2.x;
        this.y = f3 * quaternion.y + f4 * quaternion2.y;
        this.z = f3 * quaternion.z + f4 * quaternion2.z;
        this.w = f3 * quaternion.w + f4 * quaternion2.w;
        return this;
    }

    public void slerp(Quaternion quaternion, float f) {
        if (this.x == quaternion.x && this.y == quaternion.y && this.z == quaternion.z && this.w == quaternion.w) {
            return;
        }
        float f2 = this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
        if (f2 < 0.0f) {
            quaternion.x = -quaternion.x;
            quaternion.y = -quaternion.y;
            quaternion.z = -quaternion.z;
            quaternion.w = -quaternion.w;
            f2 = -f2;
        }
        float f3 = 1.0f - f;
        float f4 = f;
        if (1.0f - f2 > 0.1f) {
            float f5 = FastMath.acos(f2);
            float f6 = 1.0f / FastMath.sin(f5);
            f3 = FastMath.sin((1.0f - f) * f5) * f6;
            f4 = FastMath.sin(f * f5) * f6;
        }
        this.x = f3 * this.x + f4 * quaternion.x;
        this.y = f3 * this.y + f4 * quaternion.y;
        this.z = f3 * this.z + f4 * quaternion.z;
        this.w = f3 * this.w + f4 * quaternion.w;
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.x + quaternion.x, this.y + quaternion.y, this.z + quaternion.z, this.w + quaternion.w);
    }

    public Quaternion addLocal(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.x - quaternion.x, this.y - quaternion.y, this.z - quaternion.z, this.w - quaternion.w);
    }

    public Quaternion subtractLocal(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
        return this;
    }

    public Quaternion mult(Quaternion quaternion) {
        return this.mult(quaternion, null);
    }

    public Quaternion mult(Quaternion quaternion, Quaternion quaternion2) {
        if (quaternion2 == null) {
            quaternion2 = new Quaternion();
        }
        float f = quaternion.w;
        float f2 = quaternion.x;
        float f3 = quaternion.y;
        float f4 = quaternion.z;
        quaternion2.x = this.x * f + this.y * f4 - this.z * f3 + this.w * f2;
        quaternion2.y = -this.x * f4 + this.y * f + this.z * f2 + this.w * f3;
        quaternion2.z = this.x * f3 - this.y * f2 + this.z * f + this.w * f4;
        quaternion2.w = -this.x * f2 - this.y * f3 - this.z * f4 + this.w * f;
        return quaternion2;
    }

    public void apply(Matrix3f matrix3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        this.fromRotationMatrix(matrix3f);
        float f5 = this.x;
        float f6 = this.y;
        float f7 = this.z;
        float f8 = this.w;
        this.x = f * f8 + f2 * f7 - f3 * f6 + f4 * f5;
        this.y = -f * f7 + f2 * f8 + f3 * f5 + f4 * f6;
        this.z = f * f6 - f2 * f5 + f3 * f8 + f4 * f7;
        this.w = -f * f5 - f2 * f6 - f3 * f7 + f4 * f8;
    }

    public void fromAxes(Vector3f[] vector3fArray) {
        if (vector3fArray.length != 3) {
            throw new IllegalArgumentException("Axis array must have three elements");
        }
        this.fromAxes(vector3fArray[0], vector3fArray[1], vector3fArray[2]);
    }

    public void fromAxes(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.fromRotationMatrix(vector3f.x, vector3f2.x, vector3f3.x, vector3f.y, vector3f2.y, vector3f3.y, vector3f.z, vector3f2.z, vector3f3.z);
    }

    public void toAxes(Vector3f[] vector3fArray) {
        Matrix3f matrix3f = this.toRotationMatrix();
        vector3fArray[0] = matrix3f.getColumn(0, vector3fArray[0]);
        vector3fArray[1] = matrix3f.getColumn(1, vector3fArray[1]);
        vector3fArray[2] = matrix3f.getColumn(2, vector3fArray[2]);
    }

    public Vector3f mult(Vector3f vector3f) {
        return this.mult(vector3f, null);
    }

    public Vector3f multLocal(Vector3f vector3f) {
        float f = this.w * this.w * vector3f.x + 2.0f * this.y * this.w * vector3f.z - 2.0f * this.z * this.w * vector3f.y + this.x * this.x * vector3f.x + 2.0f * this.y * this.x * vector3f.y + 2.0f * this.z * this.x * vector3f.z - this.z * this.z * vector3f.x - this.y * this.y * vector3f.x;
        float f2 = 2.0f * this.x * this.y * vector3f.x + this.y * this.y * vector3f.y + 2.0f * this.z * this.y * vector3f.z + 2.0f * this.w * this.z * vector3f.x - this.z * this.z * vector3f.y + this.w * this.w * vector3f.y - 2.0f * this.x * this.w * vector3f.z - this.x * this.x * vector3f.y;
        vector3f.z = 2.0f * this.x * this.z * vector3f.x + 2.0f * this.y * this.z * vector3f.y + this.z * this.z * vector3f.z - 2.0f * this.w * this.y * vector3f.x - this.y * this.y * vector3f.z + 2.0f * this.w * this.x * vector3f.y - this.x * this.x * vector3f.z + this.w * this.w * vector3f.z;
        vector3f.x = f;
        vector3f.y = f2;
        return vector3f;
    }

    public Quaternion multLocal(Quaternion quaternion) {
        float f = this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y + this.w * quaternion.x;
        float f2 = -this.x * quaternion.z + this.y * quaternion.w + this.z * quaternion.x + this.w * quaternion.y;
        float f3 = this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.w + this.w * quaternion.z;
        this.w = -this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z + this.w * quaternion.w;
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Quaternion multLocal(float f, float f2, float f3, float f4) {
        float f5 = this.x * f4 + this.y * f3 - this.z * f2 + this.w * f;
        float f6 = -this.x * f3 + this.y * f4 + this.z * f + this.w * f2;
        float f7 = this.x * f2 - this.y * f + this.z * f4 + this.w * f3;
        this.w = -this.x * f - this.y * f2 - this.z * f3 + this.w * f4;
        this.x = f5;
        this.y = f6;
        this.z = f7;
        return this;
    }

    public Vector3f mult(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        if (vector3f.x == 0.0f && vector3f.y == 0.0f && vector3f.z == 0.0f) {
            vector3f2.set(0.0f, 0.0f, 0.0f);
        } else {
            float f = vector3f.x;
            float f2 = vector3f.y;
            float f3 = vector3f.z;
            vector3f2.x = this.w * this.w * f + 2.0f * this.y * this.w * f3 - 2.0f * this.z * this.w * f2 + this.x * this.x * f + 2.0f * this.y * this.x * f2 + 2.0f * this.z * this.x * f3 - this.z * this.z * f - this.y * this.y * f;
            vector3f2.y = 2.0f * this.x * this.y * f + this.y * this.y * f2 + 2.0f * this.z * this.y * f3 + 2.0f * this.w * this.z * f - this.z * this.z * f2 + this.w * this.w * f2 - 2.0f * this.x * this.w * f3 - this.x * this.x * f2;
            vector3f2.z = 2.0f * this.x * this.z * f + 2.0f * this.y * this.z * f2 + this.z * this.z * f3 - 2.0f * this.w * this.y * f - this.y * this.y * f3 + 2.0f * this.w * this.x * f2 - this.x * this.x * f3 + this.w * this.w * f3;
        }
        return vector3f2;
    }

    public Quaternion mult(float f) {
        return new Quaternion(f * this.x, f * this.y, f * this.z, f * this.w);
    }

    public Quaternion multLocal(float f) {
        this.w *= f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public float dot(Quaternion quaternion) {
        return this.w * quaternion.w + this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z;
    }

    public float norm() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        float f = FastMath.invSqrt(this.norm());
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
    }

    public Quaternion inverse() {
        float f = this.norm();
        if ((double)f > 0.0) {
            float f2 = 1.0f / f;
            return new Quaternion(-this.x * f2, -this.y * f2, -this.z * f2, this.w * f2);
        }
        return null;
    }

    public Quaternion inverseLocal() {
        float f = this.norm();
        if ((double)f > 0.0) {
            float f2 = 1.0f / f;
            this.x *= -f2;
            this.y *= -f2;
            this.z *= -f2;
            this.w *= f2;
        }
        return this;
    }

    public void negate() {
        this.x *= -1.0f;
        this.y *= -1.0f;
        this.z *= -1.0f;
        this.w *= -1.0f;
    }

    public String toString() {
        return "com.jme.math.Quaternion: [x=" + this.x + " y=" + this.y + " z=" + this.z + " w=" + this.w + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Quaternion)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Quaternion quaternion = (Quaternion)object;
        if (Float.compare(this.x, quaternion.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, quaternion.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, quaternion.z) != 0) {
            return false;
        }
        return Float.compare(this.w, quaternion.w) == 0;
    }

    public int hashCode() {
        int n = 37;
        n = 37 * n + Float.floatToIntBits(this.x);
        n = 37 * n + Float.floatToIntBits(this.y);
        n = 37 * n + Float.floatToIntBits(this.z);
        n = 37 * n + Float.floatToIntBits(this.w);
        return n;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
        this.w = objectInput.readFloat();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
        objectOutput.writeFloat(this.w);
    }

    public void lookAt(Vector3f vector3f, Vector3f vector3f2) {
        tmpZaxis.set(vector3f).normalizeLocal();
        tmpXaxis.set(vector3f2).crossLocal(vector3f).normalizeLocal();
        tmpYaxis.set(vector3f).crossLocal(tmpXaxis).normalizeLocal();
        this.fromAxes(tmpXaxis, tmpYaxis, tmpZaxis);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.x, "x", 0.0f);
        outputCapsule.write(this.y, "y", 0.0f);
        outputCapsule.write(this.z, "z", 0.0f);
        outputCapsule.write(this.w, "w", 1.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.x = inputCapsule.readFloat("x", 0.0f);
        this.y = inputCapsule.readFloat("y", 0.0f);
        this.z = inputCapsule.readFloat("z", 0.0f);
        this.w = inputCapsule.readFloat("w", 1.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public Quaternion opposite() {
        return this.opposite(null);
    }

    public Quaternion opposite(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        Vector3f vector3f = new Vector3f();
        float f = this.toAngleAxis(vector3f);
        quaternion.fromAngleAxis((float)Math.PI + f, vector3f);
        return quaternion;
    }

    public Quaternion oppositeLocal() {
        return this.opposite(this);
    }
}

