/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.bounding.BoundingSphere;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.LightManagement;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.Vector3f;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Sphere;
import com.jme.util.export.Savable;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class LightManagementTest
extends TestCase {
    private static final Logger logger = Logger.getLogger(LightManagementTest.class.getName());

    public void testQuickSort() {
        Savable savable;
        LightManagement lightManagement = new LightManagement();
        SpotLight spotLight = new SpotLight();
        lightManagement.addLight(spotLight);
        SpotLight spotLight2 = new SpotLight();
        lightManagement.addLight(spotLight2);
        SpotLight spotLight3 = new SpotLight();
        lightManagement.addLight(spotLight3);
        SpotLight spotLight4 = new SpotLight();
        spotLight4.setAttenuate(true);
        spotLight4.setLocation(new Vector3f(2.0f, 0.0f, 0.0f));
        spotLight4.setDirection(new Vector3f(0.0f, 0.5f, 0.0f));
        spotLight4.setLinear(2.0f);
        lightManagement.addLight(spotLight4);
        lightManagement.addLight(new DirectionalLight());
        lightManagement.addLight(new SpotLight());
        lightManagement.addLight(new SpotLight());
        lightManagement.addLight(new DirectionalLight());
        lightManagement.addLight(new PointLight());
        for (int i = 0; i < lightManagement.numberOfLights(); ++i) {
            savable = lightManagement.get(i);
            ((Light)savable).setEnabled(true);
        }
        LightManagementTest.assertEquals((String)"number of lights", (int)9, (int)lightManagement.numberOfLights());
        Node node = new Node("test");
        savable = new Sphere(null, 5, 5, 1.0f);
        ((Geometry)savable).setModelBound(new BoundingSphere(1.0f, new Vector3f(1.0f, 0.0f, 0.0f)));
        node.attachChild((Spatial)savable);
        node.updateGeometricState(0.0f, true);
        lightManagement.sort(node);
        LightManagementTest.assertEquals((String)"number of lights", (int)9, (int)lightManagement.numberOfLights());
        float f = Float.MAX_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < lightManagement.numberOfLights(); ++i) {
            Light light = lightManagement.get(i);
            float f2 = lightManagement.getValueFor(light, node.getWorldBound());
            LightManagementTest.assertTrue((String)"order wrong", (f2 <= f ? 1 : 0) != 0);
            if (light == spotLight) {
                n = i;
            }
            if (light == spotLight2) {
                n2 = i;
            }
            if (light == spotLight3) {
                n3 = i;
            }
            f = f2;
        }
        LightManagementTest.assertEquals((String)"b after a", (int)(n + 1), (int)n2);
        LightManagementTest.assertEquals((String)"c after b", (int)(n2 + 1), (int)n3);
    }
}

