/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.joystick.lwjgl;

import com.jme.input.joystick.DummyJoystickInput;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.joystick.JoystickInputListener;
import com.jme.input.joystick.lwjgl.LWJGLJoystick;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWJGLJoystickInput
extends JoystickInput {
    private ArrayList<LWJGLJoystick> joysticks;
    private DummyJoystickInput.DummyJoystick dummyJoystick;

    protected LWJGLJoystickInput() throws RuntimeException {
        try {
            Controllers.create();
            this.updateJoystickList();
        }
        catch (LWJGLException lWJGLException) {
            throw new RuntimeException("Initalizing joystick support failed", lWJGLException);
        }
    }

    private void updateJoystickList() {
        this.joysticks = new ArrayList();
        for (int i = 0; i < Controllers.getControllerCount(); ++i) {
            this.joysticks.add(new LWJGLJoystick(Controllers.getController(i)));
        }
    }

    @Override
    public void update() {
        Controllers.poll();
        while (Controllers.next()) {
            JoystickInputListener joystickInputListener;
            int n;
            if (this.listeners == null || this.listeners.size() <= 0) continue;
            Joystick joystick = this.getJoystick(Controllers.getEventSource().getIndex());
            int n2 = Controllers.getEventControlIndex();
            if (Controllers.isEventButton()) {
                boolean bl = joystick.isButtonPressed(n2);
                for (n = 0; n < this.listeners.size(); ++n) {
                    joystickInputListener = (JoystickInputListener)this.listeners.get(n);
                    joystickInputListener.onButton(joystick, n2, bl);
                }
                continue;
            }
            if (!Controllers.isEventAxis()) continue;
            float f = joystick.getAxisValue(n2);
            for (n = 0; n < this.listeners.size(); ++n) {
                joystickInputListener = (JoystickInputListener)this.listeners.get(n);
                joystickInputListener.onAxis(joystick, n2, f);
            }
        }
    }

    @Override
    public int getJoystickCount() {
        int n = this.joysticks.size();
        if (n != Controllers.getControllerCount()) {
            this.updateJoystickList();
        }
        return n;
    }

    @Override
    public Joystick getJoystick(int n) {
        return this.joysticks.get(n);
    }

    @Override
    public Joystick getDefaultJoystick() {
        if (this.getJoystickCount() > 0) {
            return this.getJoystick(this.getJoystickCount() - 1);
        }
        if (this.dummyJoystick == null) {
            this.dummyJoystick = new DummyJoystickInput.DummyJoystick();
        }
        return this.dummyJoystick;
    }

    @Override
    protected void destroy() {
        Controllers.destroy();
    }

    @Override
    public ArrayList<Joystick> findJoysticksByAxis(String ... stringArray) {
        ArrayList<Joystick> arrayList = new ArrayList<Joystick>();
        for (int i = 0; i < this.getJoystickCount(); ++i) {
            Joystick joystick = this.getJoystick(i);
            boolean bl = true;
            for (String string : stringArray) {
                int n = joystick.findAxis(string);
                if (n == -1) {
                    bl = false;
                    break;
                }
                try {
                    joystick.getAxisValue(n);
                }
                catch (Exception exception) {
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            arrayList.add(joystick);
        }
        return arrayList;
    }
}

