/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.controller;

import com.jme.input.controls.GameControl;
import com.jme.input.controls.controller.Axis;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;

public class RotationController
extends Controller {
    private static final long serialVersionUID = -911814334954766964L;
    private Spatial spatial;
    private GameControl positive;
    private GameControl negative;
    private float multiplier;
    private Quaternion quat;
    private Vector3f dir;

    public RotationController(Spatial spatial, GameControl gameControl, GameControl gameControl2, float f, Axis axis) {
        this.spatial = spatial;
        this.positive = gameControl;
        this.negative = gameControl2;
        this.multiplier = f;
        this.quat = new Quaternion();
        if (axis == Axis.X) {
            this.dir = new Vector3f(1.0f, 0.0f, 0.0f);
        } else if (axis == Axis.Y) {
            this.dir = new Vector3f(0.0f, 1.0f, 0.0f);
        } else if (axis == Axis.Z) {
            this.dir = new Vector3f(0.0f, 0.0f, 1.0f);
        } else {
            throw new RuntimeException("Unknown axis: " + (Object)((Object)axis));
        }
    }

    public void update(float f) {
        float f2 = this.positive.getValue() - this.negative.getValue();
        float f3 = f2 * f * this.multiplier;
        if (f2 != 0.0f) {
            this.quat.fromAngleAxis(f3 * (float)Math.PI, this.dir);
            this.spatial.getLocalRotation().multLocal(this.quat);
        }
    }

    public GameControl getPositive() {
        return this.positive;
    }

    public void setPositive(GameControl gameControl) {
        this.positive = gameControl;
    }

    public GameControl getNegative() {
        return this.negative;
    }

    public void setNegative(GameControl gameControl) {
        this.negative = gameControl;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float f) {
        this.multiplier = f;
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
    }
}

