/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.binding;

import com.jme.input.MouseInput;
import com.jme.input.controls.Binding;
import com.jme.system.DisplaySystem;
import java.util.logging.Logger;

public class MouseOffsetBinding
implements Binding {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(MouseOffsetBinding.class.getName());
    private int width;
    private int heigth;
    private int axis;
    private boolean reverse;

    public MouseOffsetBinding(int n, boolean bl) {
        this.axis = n;
        this.reverse = bl;
        this.width = DisplaySystem.getDisplaySystem().getWidth();
        this.heigth = DisplaySystem.getDisplaySystem().getHeight();
    }

    public float getValue() {
        float f = 0.0f;
        switch (this.axis) {
            case 1: {
                f = MouseInput.get().getXAbsolute() - this.width / 2;
                return this.convert(100.0f / (float)(this.width / 2) * f);
            }
            case 2: {
                f = MouseInput.get().getYAbsolute() - this.heigth / 2;
                return this.convert(100.0f / (float)(this.heigth / 2) * f);
            }
        }
        this.log.severe("unknown Axis");
        return 0.0f;
    }

    private float convert(float f) {
        if (f < 0.0f && !this.reverse) {
            return 0.0f;
        }
        if (f > 0.0f && this.reverse) {
            return 0.0f;
        }
        return Math.abs(f * 0.01f);
    }

    public String getName() {
        return "OffsetMousebinding " + (this.axis == 1 ? "X" : "Y");
    }

    public String toString() {
        return this.getName();
    }
}

