/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;

public abstract class ActionTrigger {
    protected final InputHandler inputHandler;
    protected final String name;
    protected final boolean allowRepeats;
    protected final InputActionInterface action;
    private boolean active;
    private ActionTrigger next;
    private ActionTrigger previous;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActionTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, boolean bl) {
        this.inputHandler = inputHandler;
        this.action = inputActionInterface;
        this.allowRepeats = bl;
        this.name = string;
        InputHandler inputHandler2 = inputHandler;
        synchronized (inputHandler2) {
            inputHandler.allTriggers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove() {
        InputHandler inputHandler = this.inputHandler;
        synchronized (inputHandler) {
            this.deactivate();
            this.inputHandler.allTriggers.remove(this);
        }
    }

    public abstract void checkActivation(char var1, int var2, float var3, float var4, boolean var5, Object var6);

    protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
        inputActionEvent.setTriggerName(this.name);
        inputActionEvent.setTriggerAllowsRepeats(this.allowRepeats);
        inputActionEvent.setTriggerDevice(this.getDeviceName());
        inputActionEvent.setTriggerCharacter('\u0000');
        inputActionEvent.setTriggerDelta(0.0f);
        inputActionEvent.setTriggerIndex(0);
        inputActionEvent.setTriggerPosition(0.0f);
        inputActionEvent.setTriggerPressed(false);
    }

    protected abstract String getDeviceName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void activate() {
        InputHandler inputHandler = this.inputHandler;
        synchronized (inputHandler) {
            if (!this.active && this.inputHandler.isEnabled()) {
                this.active = true;
                ActionTrigger actionTrigger = this.inputHandler.activeTriggers;
                this.inputHandler.activeTriggers = this;
                this.setNext(actionTrigger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deactivate() {
        InputHandler inputHandler = this.inputHandler;
        synchronized (inputHandler) {
            if (this.active) {
                this.active = false;
                ActionTrigger actionTrigger = this.inputHandler.activeTriggers;
                if (actionTrigger == this) {
                    this.inputHandler.activeTriggers = this.getNext();
                    this.setNext(null);
                } else {
                    this.getPrevious().setNext(this.getNext());
                }
            }
        }
    }

    ActionTrigger getNext() {
        return this.next;
    }

    boolean setNext(ActionTrigger actionTrigger) {
        ActionTrigger actionTrigger2 = this.next;
        boolean bl = false;
        if (actionTrigger2 != actionTrigger) {
            if (actionTrigger2 != null) {
                this.next = null;
                actionTrigger2.setPrevious(null);
            }
            this.next = actionTrigger;
            if (actionTrigger != null) {
                actionTrigger.setPrevious(this);
            }
            bl = true;
        }
        return bl;
    }

    ActionTrigger getPrevious() {
        return this.previous;
    }

    boolean setPrevious(ActionTrigger actionTrigger) {
        ActionTrigger actionTrigger2 = this.previous;
        boolean bl = false;
        if (actionTrigger2 != actionTrigger) {
            if (actionTrigger2 != null) {
                this.previous = null;
                actionTrigger2.setNext(null);
            }
            this.previous = actionTrigger;
            if (actionTrigger != null) {
                actionTrigger.setNext(this);
            }
            bl = true;
        }
        return bl;
    }

    protected int getActionInvocationCount() {
        return 1;
    }

    public void performAction(InputActionEvent inputActionEvent) {
        int n = this.getActionInvocationCount();
        for (int i = 0; i < n; ++i) {
            this.putTriggerInfo(inputActionEvent, i);
            this.action.performAction(inputActionEvent);
        }
        if (!this.allowRepeats) {
            this.deactivate();
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    static class CommandTrigger
    extends ActionTrigger {
        protected CommandTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, boolean bl) {
            super(inputHandler, string, inputActionInterface, bl);
            this.activate();
        }

        public void performAction(InputActionEvent inputActionEvent) {
            if (this.name == null || KeyBindingManager.getKeyBindingManager().isValidCommand(this.name, this.allowRepeats)) {
                super.performAction(inputActionEvent);
                this.activate();
            }
        }

        public void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
        }

        protected String getDeviceName() {
            return "command";
        }
    }
}

