/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import java.nio.FloatBuffer;
import junit.framework.TestCase;

public class BoundsTest
extends TestCase {
    public void testMergeBox() {
        BoundingBox boundingBox = new BoundingBox(new Vector3f(0.0f, 0.0f, -15.0f), 10.0f, 10.0f, 0.0f);
        BoundingBox boundingBox2 = new BoundingBox(new Vector3f(0.0f, 0.0f, -5.0f), 10.0f, 10.0f, 0.0f);
        BoundingBox boundingBox3 = new BoundingBox();
        boundingBox.clone(boundingBox3);
        boundingBox3.merge(boundingBox2);
        BoundsTest.assertEquals((String)"center x", (float)0.0f, (float)boundingBox3.getCenter().x, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"center y", (float)0.0f, (float)boundingBox3.getCenter().y, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"center z", (float)-10.0f, (float)boundingBox3.getCenter().z, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"extent x", (float)10.0f, (float)boundingBox3.xExtent, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"extent y", (float)10.0f, (float)boundingBox3.yExtent, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"extent z", (float)5.0f, (float)boundingBox3.zExtent, (float)1.1920929E-7f);
    }

    public void testMergeSphereOBB() {
        BoundingSphere boundingSphere = new BoundingSphere(1.0f, new Vector3f());
        OrientedBoundingBox orientedBoundingBox = new OrientedBoundingBox();
        orientedBoundingBox.setCenter(new Vector3f(1.0f, 1.0f, 0.0f));
        orientedBoundingBox.setExtent(new Vector3f(1.0f, 1.0f, 1.0f));
        BoundingSphere boundingSphere2 = (BoundingSphere)boundingSphere.merge(orientedBoundingBox);
        BoundingSphere boundingSphere3 = (BoundingSphere)boundingSphere2.merge(orientedBoundingBox);
        BoundingSphere boundingSphere4 = (BoundingSphere)boundingSphere3.merge(orientedBoundingBox);
        BoundsTest.assertEquals((String)"center", (Object)boundingSphere2.getCenter(), (Object)boundingSphere3.getCenter());
        BoundsTest.assertEquals((String)"radius", (float)boundingSphere2.getRadius(), (float)boundingSphere3.getRadius(), (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"center", (Object)boundingSphere2.getCenter(), (Object)boundingSphere4.getCenter());
        BoundsTest.assertEquals((String)"radius", (float)boundingSphere2.getRadius(), (float)boundingSphere4.getRadius(), (float)1.1920929E-7f);
    }

    public void testComputeSphereFromPoints() {
        BoundingSphere boundingSphere = new BoundingSphere();
        float f = 2.0f;
        this.checkPointsOnCircle(f, boundingSphere, 2);
        this.checkPointsOnCircle(f, boundingSphere, 3);
        this.checkPointsOnCircle(f, boundingSphere, 4);
        this.checkPointsOnCircle(f, boundingSphere, 5);
        this.checkPointsOnCircle(f, boundingSphere, 10);
        this.checkPointsOnSphere(f, boundingSphere, 2);
        this.checkPointsOnSphere(f, boundingSphere, 3);
        this.checkPointsOnSphere(f, boundingSphere, 4);
    }

    private void checkPointsOnCircle(float f, BoundingSphere boundingSphere, int n) {
        int n2;
        FloatBuffer floatBuffer = FloatBuffer.allocate(n * 2 * 3);
        for (n2 = 0; n2 < n; ++n2) {
            floatBuffer.put(FastMath.cos((float)(2 * n2) * (float)Math.PI / (float)n) * ((float)n2 * f / (float)n)).put(FastMath.sin((float)(2 * n2) * (float)Math.PI / (float)n) * ((float)n2 * f / (float)n)).put(0.0f);
        }
        for (n2 = 0; n2 < n; ++n2) {
            floatBuffer.put(FastMath.cos((float)(2 * n2) * (float)Math.PI / (float)n) * f).put(FastMath.sin((float)(2 * n2) * (float)Math.PI / (float)n) * f).put(0.0f);
        }
        boundingSphere.computeFromPoints(floatBuffer);
        BoundsTest.assertEquals((String)("radius from " + n * 2 + " points"), (float)f, (float)boundingSphere.getRadius(), (float)0.001f);
    }

    private void checkPointsOnSphere(float f, BoundingSphere boundingSphere, int n) {
        int n2;
        FloatBuffer floatBuffer = FloatBuffer.allocate(n * 2 * 3);
        for (n2 = 0; n2 < n; ++n2) {
            floatBuffer.put(FastMath.cos((float)(2 * n2) * (float)Math.PI / (float)n) * (f * 0.9f)).put(FastMath.sin((float)(2 * n2) * (float)Math.PI / (float)n) * (f * 0.9f)).put(0.0f);
        }
        for (n2 = 0; n2 < n; ++n2) {
            floatBuffer.put(0.0f).put(FastMath.cos((float)(2 * n2) * (float)Math.PI / (float)n) * f).put(FastMath.sin((float)(2 * n2) * (float)Math.PI / (float)n) * f);
        }
        boundingSphere.computeFromPoints(floatBuffer);
        BoundsTest.assertEquals((String)("radius from " + n + " points"), (float)f, (float)boundingSphere.getRadius(), (float)0.001f);
    }
}

