/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.intersection.IntersectionRecord;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public abstract class BoundingVolume
implements Serializable,
Savable {
    private static final long serialVersionUID = 2L;
    public static final int BOUNDING_SPHERE = 0;
    public static final int BOUNDING_BOX = 1;
    public static final int BOUNDING_OBB = 2;
    public static final int BOUNDING_CAPSULE = 3;
    protected int checkPlane = 0;
    protected Vector3f center = new Vector3f();
    protected static final transient Vector3f _compVect1 = new Vector3f();
    protected static final transient Vector3f _compVect2 = new Vector3f();

    public BoundingVolume() {
    }

    public BoundingVolume(Vector3f vector3f) {
        this.center.set(vector3f);
    }

    public int getCheckPlane() {
        return this.checkPlane;
    }

    public final void setCheckPlane(int n) {
        this.checkPlane = n;
    }

    public abstract int getType();

    public final BoundingVolume transform(Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2) {
        return this.transform(quaternion, vector3f, vector3f2, null);
    }

    public abstract BoundingVolume transform(Quaternion var1, Vector3f var2, Vector3f var3, BoundingVolume var4);

    public abstract int whichSide(Plane var1);

    public abstract void computeFromPoints(FloatBuffer var1);

    public abstract void computeFromBatches(ArrayList var1);

    public abstract BoundingVolume merge(BoundingVolume var1);

    public abstract BoundingVolume mergeLocal(BoundingVolume var1);

    public abstract BoundingVolume clone(BoundingVolume var1);

    public final Vector3f getCenter() {
        return this.center;
    }

    public final Vector3f getCenter(Vector3f vector3f) {
        vector3f.set(this.center);
        return vector3f;
    }

    public final void setCenter(Vector3f vector3f) {
        this.center = vector3f;
    }

    public final float distanceTo(Vector3f vector3f) {
        return this.center.distance(vector3f);
    }

    public final float distanceSquaredTo(Vector3f vector3f) {
        return this.center.distanceSquared(vector3f);
    }

    public abstract float distanceToEdge(Vector3f var1);

    public abstract boolean intersects(BoundingVolume var1);

    public abstract boolean intersects(Ray var1);

    public abstract IntersectionRecord intersectsWhere(Ray var1);

    public abstract boolean intersectsSphere(BoundingSphere var1);

    public abstract boolean intersectsBoundingBox(BoundingBox var1);

    public abstract boolean intersectsOrientedBoundingBox(OrientedBoundingBox var1);

    public abstract boolean intersectsCapsule(BoundingCapsule var1);

    public abstract boolean contains(Vector3f var1);

    public void write(JMEExporter jMEExporter) throws IOException {
        jMEExporter.getCapsule(this).write(this.center, "center", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        this.center = (Vector3f)jMEImporter.getCapsule(this).readSavable("center", Vector3f.ZERO.clone());
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public abstract void computeFromTris(int[] var1, TriangleBatch var2, int var3, int var4);

    public abstract void computeFromTris(Triangle[] var1, int var2, int var3);

    public abstract float getVolume();
}

