/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.AbstractGame;
import com.jme.input.InputSystem;
import com.jme.util.ThrowableHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseGame
extends AbstractGame {
    private static final Logger logger = Logger.getLogger(BaseGame.class.getName());
    protected ThrowableHandler throwableHandler;

    public final void start() {
        block5: {
            logger.info("Application started.");
            try {
                this.getAttributes();
                if (!this.finished) {
                    this.initSystem();
                    this.assertDisplayCreated();
                    this.initGame();
                    while (!this.finished && !this.display.isClosing()) {
                        InputSystem.update();
                        this.update(-1.0f);
                        this.render(-1.0f);
                        this.display.getRenderer().displayBackBuffer();
                        Thread.yield();
                    }
                }
            }
            catch (Throwable throwable) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "start()", "Exception in game loop", throwable);
                if (this.throwableHandler == null) break block5;
                this.throwableHandler.handle(throwable);
            }
        }
        this.cleanup();
        logger.info("Application ending.");
        if (this.display != null) {
            this.display.reset();
        }
        this.quit();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.close();
        }
    }

    protected ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    protected void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

