/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.image.Texture;
import com.jme.math.Matrix4f;
import com.jme.scene.Controller;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.logging.Logger;

public class TextureKeyframeController
extends Controller {
    private static final Logger logger = Logger.getLogger(TextureKeyframeController.class.getName());
    public static final int IT_STEP = 0;
    public static final int IT_LINEAR = 1;
    private static final long serialVersionUID = 1L;
    private float[] times;
    private int[] interp;
    private Matrix4f[] transforms;
    private Texture texture;
    private int index;
    private int maxIndex;
    private float currentTime;
    private boolean increment = true;
    private static Matrix4f workMat = new Matrix4f();
    private static Matrix4f workMat2 = new Matrix4f();

    public TextureKeyframeController() {
    }

    public TextureKeyframeController(Texture texture) {
        this.texture = texture;
    }

    public void addData(float[] fArray, Matrix4f[] matrix4fArray, int[] nArray) {
        if (fArray.length != matrix4fArray.length) {
            logger.warning("Invalid texture keyframe information. Times and transforms are not of same length. [" + fArray.length + " != " + matrix4fArray.length);
            return;
        }
        this.times = fArray;
        this.interp = nArray;
        this.transforms = matrix4fArray;
        this.maxIndex = fArray.length - 1;
        this.currentTime = fArray[0];
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void update(float f) {
        if (this.texture == null) {
            return;
        }
        if (this.increment) {
            if (this.index == this.maxIndex) {
                if (this.getRepeatType() == 1) {
                    this.currentTime = 0.0f;
                    this.index = 0;
                    this.texture.setMatrix(this.transforms[this.index]);
                } else if (this.getRepeatType() == 2) {
                    this.increment = false;
                    this.update(f);
                }
            } else {
                this.currentTime += f * this.getSpeed();
                if (this.currentTime >= this.times[this.index + 1]) {
                    ++this.index;
                    this.texture.setMatrix(this.transforms[this.index]);
                } else if (this.interp[this.index] == 1) {
                    float f2 = (this.currentTime - this.times[this.index]) / (this.times[this.index + 1] - this.times[this.index]);
                    workMat = this.transforms[this.index].mult(1.0f - f2, workMat);
                    workMat2 = this.transforms[this.index + 1].mult(f2, workMat2);
                    workMat.addLocal(workMat2);
                    this.texture.setMatrix(workMat);
                }
            }
        } else if (this.index == 0) {
            if (this.getRepeatType() == 1) {
                this.currentTime = this.times[this.maxIndex];
                this.index = this.maxIndex;
            } else if (this.getRepeatType() == 2) {
                this.increment = true;
            }
        } else {
            this.currentTime -= f * this.getSpeed();
            if (this.currentTime <= this.times[this.index - 1]) {
                --this.index;
                this.texture.setMatrix(this.transforms[this.index]);
            } else if (this.interp[this.index] == 1) {
                float f3 = (this.currentTime - this.times[this.index]) / (this.times[this.index - 1] - this.times[this.index]);
                workMat = this.transforms[this.index].mult(1.0f - f3, workMat);
                workMat2 = this.transforms[this.index - 1].mult(f3, workMat2);
                workMat.addLocal(workMat2);
                this.texture.setMatrix(workMat);
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.times, "times", (float[])null);
        outputCapsule.write(this.interp, "interp", (int[])null);
        outputCapsule.write(this.transforms, "transforms", null);
        outputCapsule.write(this.texture, "texture", null);
        outputCapsule.write(this.maxIndex, "maxIndex", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.times = inputCapsule.readFloatArray("times", null);
        this.interp = inputCapsule.readIntArray("interp", null);
        Savable[] savableArray = inputCapsule.readSavableArray("transforms", null);
        if (savableArray == null) {
            this.transforms = null;
        } else {
            this.transforms = new Matrix4f[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.transforms[i] = (Matrix4f)savableArray[i];
            }
        }
        this.texture = (Texture)inputCapsule.readSavable("texture", null);
        this.maxIndex = inputCapsule.readInt("maxIndex", 0);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

