/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.animation.Bone;
import com.jme.animation.BoneTransform;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneAnimation
implements Serializable,
Savable {
    private static final Logger logger = Logger.getLogger(BoneAnimation.class.getName());
    private static final float DEFAULT_RATE = 0.05f;
    public static final int LINEAR = 0;
    public static final int BEZIER = 1;
    private static final long serialVersionUID = 1L;
    private String name;
    private float[] keyframeTime;
    private int[] interpolationType;
    private ArrayList<BoneTransform> boneTransforms;
    private float currentTime;
    private int currentFrame = 1;
    private int prevFrame = 0;
    private int endFrame;
    private int startFrame;
    private float interpolationRate = 0.05f;
    private float lastTime;
    private int cycleMode = 1;
    private boolean interpolate;
    private ArrayList<BoneAnimation> children;

    public BoneAnimation() {
    }

    public BoneAnimation(String string) {
        this.name = string;
    }

    public BoneAnimation(String string, Bone bone, int n) {
        this.name = string;
        this.keyframeTime = new float[n];
        this.interpolationType = new int[n];
    }

    public void addBoneAnimation(BoneAnimation boneAnimation) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(boneAnimation);
    }

    public void setCurrentFrame(int n) {
        int n2;
        if (this.prevFrame == n) {
            return;
        }
        if (this.keyframeTime != null && (n >= this.keyframeTime.length + 1 || n < 0)) {
            logger.severe(this.name + ": Invalid frame index (" + n + "). Intialized to only " + "have: " + this.keyframeTime.length + " keyframes.");
            return;
        }
        if (this.keyframeTime != null) {
            this.prevFrame = n;
            this.currentFrame = this.prevFrame < this.keyframeTime.length - 1 ? this.prevFrame + 1 : this.startFrame;
            this.currentTime = this.keyframeTime[this.prevFrame];
            if (this.boneTransforms != null) {
                for (n2 = 0; n2 < this.boneTransforms.size(); ++n2) {
                    this.boneTransforms.get(n2).setCurrentFrame(this.currentFrame);
                }
            }
        }
        if (this.children != null) {
            for (n2 = 0; n2 < this.children.size(); ++n2) {
                this.children.get(n2).setCurrentFrame(n);
            }
        }
    }

    public void addBoneTransforms(BoneTransform boneTransform) {
        if (this.boneTransforms == null) {
            this.boneTransforms = new ArrayList();
        }
        this.boneTransforms.add(boneTransform);
    }

    public void update(float f, int n, float f2) {
        if (this.boneTransforms != null && this.keyframeTime != null) {
            switch (n) {
                case 0: {
                    int n2;
                    if (this.currentFrame >= this.endFrame) {
                        this.currentFrame = this.endFrame;
                        break;
                    }
                    this.currentTime += f * f2;
                    if (this.currentTime > this.keyframeTime[this.endFrame]) {
                        this.currentFrame = this.endFrame;
                        this.currentTime = 0.0f;
                        break;
                    }
                    while (this.currentTime >= this.keyframeTime[this.currentFrame]) {
                        ++this.currentFrame;
                        ++this.prevFrame;
                    }
                    if (this.interpolate) {
                        this.lastTime += f;
                        if (!(this.lastTime > this.interpolationRate)) break;
                        this.lastTime -= this.interpolationRate;
                        float f3 = (this.currentTime - this.keyframeTime[this.prevFrame]) / (this.keyframeTime[this.currentFrame] - this.keyframeTime[this.prevFrame]);
                        for (n2 = 0; n2 < this.boneTransforms.size(); ++n2) {
                            this.boneTransforms.get(n2).update(this.prevFrame, this.currentFrame, this.interpolationType[this.prevFrame], f3);
                        }
                    } else {
                        for (int i = 0; i < this.boneTransforms.size(); ++i) {
                            this.boneTransforms.get(i).setCurrentFrame(this.currentFrame);
                        }
                    }
                    break;
                }
                case 2: {
                    int n2;
                    if (this.currentFrame >= this.endFrame) {
                        this.cycleMode *= -1;
                        this.currentFrame = this.endFrame;
                        this.prevFrame = this.endFrame - 1;
                        this.currentTime = this.keyframeTime[this.currentFrame];
                    } else if (this.prevFrame <= this.startFrame) {
                        this.cycleMode *= -1;
                        this.currentFrame = this.startFrame + 1;
                        this.prevFrame = this.startFrame;
                        this.currentTime = this.keyframeTime[this.currentFrame];
                    }
                    this.currentTime += f * f2 * (float)this.cycleMode;
                    if (this.cycleMode == 1) {
                        if (this.currentTime > this.keyframeTime[this.endFrame]) {
                            this.currentTime = this.keyframeTime[this.endFrame];
                        }
                        while (this.currentTime >= this.keyframeTime[this.currentFrame]) {
                            this.currentFrame += this.cycleMode;
                            this.prevFrame += this.cycleMode;
                        }
                    } else {
                        if (this.currentTime < this.keyframeTime[this.startFrame]) {
                            this.currentTime = this.keyframeTime[this.startFrame];
                        }
                        while (this.currentTime <= this.keyframeTime[this.currentFrame]) {
                            this.currentFrame += this.cycleMode;
                            this.prevFrame += this.cycleMode;
                        }
                    }
                    if (this.interpolate) {
                        this.lastTime += f;
                        if (!(this.lastTime > this.interpolationRate)) break;
                        this.lastTime -= this.interpolationRate;
                        float f4 = (this.currentTime - this.keyframeTime[this.prevFrame]) / (this.keyframeTime[this.currentFrame] - this.keyframeTime[this.prevFrame]);
                        for (n2 = 0; n2 < this.boneTransforms.size(); ++n2) {
                            this.boneTransforms.get(n2).update(this.prevFrame, this.currentFrame, this.interpolationType[this.prevFrame], f4);
                        }
                    } else {
                        for (int i = 0; i < this.boneTransforms.size(); ++i) {
                            this.boneTransforms.get(i).setCurrentFrame(this.currentFrame);
                        }
                    }
                    break;
                }
                case 1: {
                    int n2;
                    if (this.currentFrame >= this.endFrame) {
                        this.currentFrame = this.startFrame + 1;
                        this.prevFrame = this.startFrame;
                        this.currentTime = this.keyframeTime[this.startFrame];
                    }
                    this.currentTime += f * f2;
                    if (this.currentTime > this.keyframeTime[this.endFrame]) {
                        this.currentTime %= this.keyframeTime[this.endFrame];
                        this.currentFrame = this.startFrame;
                    }
                    while (this.currentTime >= this.keyframeTime[this.currentFrame]) {
                        if (this.currentFrame == this.endFrame) {
                            this.currentTime -= this.keyframeTime[this.endFrame];
                            this.currentFrame = this.startFrame + 1;
                            this.prevFrame = this.startFrame;
                            continue;
                        }
                        ++this.currentFrame;
                        ++this.prevFrame;
                    }
                    if (this.interpolate) {
                        this.lastTime += f;
                        if (!(this.lastTime > this.interpolationRate)) break;
                        this.lastTime -= this.interpolationRate;
                        float f5 = (this.currentTime - this.keyframeTime[this.prevFrame]) / (this.keyframeTime[this.currentFrame] - this.keyframeTime[this.prevFrame]);
                        for (n2 = 0; n2 < this.boneTransforms.size(); ++n2) {
                            this.boneTransforms.get(n2).update(this.prevFrame, this.currentFrame, this.interpolationType[this.prevFrame], f5);
                        }
                    } else {
                        for (int i = 0; i < this.boneTransforms.size(); ++i) {
                            this.boneTransforms.get(i).setCurrentFrame(this.currentFrame);
                        }
                    }
                    break;
                }
            }
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).update(f, n, f2);
            }
        }
    }

    public boolean isValid() {
        return this.boneTransforms != null && this.keyframeTime != null;
    }

    public int subanimationCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    public BoneAnimation getSubanimation(int n) {
        if (this.children == null) {
            return null;
        }
        if (n >= this.children.size() || n < 0) {
            return null;
        }
        return this.children.get(n);
    }

    public void setTimes(float[] fArray) {
        this.keyframeTime = fArray;
    }

    public void setInterpolationTypes(int[] nArray) {
        this.interpolationType = nArray;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public float getCurrentTime() {
        return this.currentTime;
    }

    public int getEndFrame() {
        return this.endFrame;
    }

    public void setEndFrame(int n) {
        if (n >= this.keyframeTime.length || n < 0) {
            logger.severe("Invalid endframe index (" + n + "). Intialized to only " + "have: " + this.keyframeTime.length + " keyframes.");
            return;
        }
        this.endFrame = n;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).setEndFrame(n);
            }
        }
    }

    public int getStartFrame() {
        return this.startFrame;
    }

    public void setStartFrame(int n) {
        if (n >= this.keyframeTime.length || n < 0) {
            logger.severe("Invalid endframe index (" + n + "). Intialized to only " + "have: " + this.keyframeTime.length + " keyframes.");
            return;
        }
        this.startFrame = n;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).setStartFrame(n);
            }
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean bl) {
        this.interpolate = bl;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).setInterpolate(bl);
            }
        }
    }

    public float getInterpolationRate() {
        return this.interpolationRate;
    }

    public void setInterpolationRate(float f) {
        this.interpolationRate = f;
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public float[] getKeyFrameTimes() {
        return this.keyframeTime;
    }

    public ArrayList<BoneTransform> getBoneTransforms() {
        return this.boneTransforms;
    }

    public void optimize(boolean bl) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            int n;
            int n2;
            if (this.children.get(i).hasChildren()) {
                this.children.get(i).optimize(bl);
                continue;
            }
            if (this.keyframeTime == null) {
                if (this.boneTransforms == null) {
                    this.boneTransforms = new ArrayList();
                }
                this.keyframeTime = this.children.get(i).getKeyFrameTimes();
                this.interpolationType = this.children.get(i).getInterpolationType();
                this.startFrame = this.children.get(i).getStartFrame();
                this.endFrame = this.children.get(i).getEndFrame();
                if (this.children.get(i).getBoneTransforms() != null) {
                    for (n2 = 0; n2 < this.children.get(i).getBoneTransforms().size(); ++n2) {
                        BoneTransform boneTransform = this.children.get(i).getBoneTransforms().get(n2);
                        if (boneTransform == null || boneTransform.getRotations() == null || boneTransform.getRotations().length <= 0) continue;
                        this.boneTransforms.add(this.children.get(i).getBoneTransforms().get(n2));
                    }
                }
                this.children.remove(i);
                --i;
                continue;
            }
            n2 = 1;
            if (this.keyframeTime.length != this.children.get(i).getKeyFrameTimes().length) continue;
            for (n = 0; n < this.keyframeTime.length; ++n) {
                if (this.keyframeTime[n] == this.children.get(i).getKeyFrameTimes()[n]) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            if (this.children.get(i).getBoneTransforms() != null) {
                for (n = 0; n < this.children.get(i).getBoneTransforms().size(); ++n) {
                    BoneTransform boneTransform = this.children.get(i).getBoneTransforms().get(n);
                    if (boneTransform.getRotations() == null || boneTransform.getRotations().length <= 0) continue;
                    this.boneTransforms.add(this.children.get(i).getBoneTransforms().get(n));
                }
            }
            this.children.remove(i);
            --i;
        }
        if (bl) {
            this.children.clear();
            this.children = null;
        }
    }

    private int[] getInterpolationType() {
        return this.interpolationType;
    }

    public String toString() {
        return this.name;
    }

    public boolean assignSkeleton(Bone bone) {
        int n;
        boolean bl = true;
        if (this.boneTransforms != null) {
            for (n = 0; n < this.boneTransforms.size(); ++n) {
                if (this.boneTransforms.get(n).findBone(bone)) continue;
                bl = false;
            }
        }
        if (this.children != null) {
            for (n = 0; n < this.children.size(); ++n) {
                if (this.children.get(n).assignSkeleton(bone)) continue;
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.name, "name", null);
        outputCapsule.write(this.keyframeTime, "keyframeTime", (float[])null);
        outputCapsule.write(this.interpolationType, "interpolationType", (int[])null);
        outputCapsule.writeSavableArrayList(this.boneTransforms, "boneTransforms", null);
        outputCapsule.write(this.currentTime, "currentTime", 0.0f);
        outputCapsule.write(this.currentFrame, "currentFrame", 1);
        outputCapsule.write(this.prevFrame, "prevFrame", 0);
        outputCapsule.write(this.endFrame, "endFrame", 0);
        outputCapsule.write(this.startFrame, "startFrame", 0);
        outputCapsule.write(this.interpolationRate, "interpolationRate", 0.05f);
        outputCapsule.write(this.lastTime, "lastTime", 0.0f);
        outputCapsule.write(this.cycleMode, "cycleMode", 1);
        outputCapsule.write(this.interpolate, "interpolate", true);
        outputCapsule.writeSavableArrayList(this.children, "children", null);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.name = inputCapsule.readString("name", null);
        this.keyframeTime = inputCapsule.readFloatArray("keyframeTime", null);
        this.interpolationType = inputCapsule.readIntArray("interpolationType", null);
        this.boneTransforms = inputCapsule.readSavableArrayList("boneTransforms", null);
        this.currentTime = inputCapsule.readFloat("currentTime", 0.0f);
        this.currentFrame = inputCapsule.readInt("currentFrame", 1);
        this.prevFrame = inputCapsule.readInt("prevFrame", 0);
        this.endFrame = inputCapsule.readInt("endFrame", 0);
        this.startFrame = inputCapsule.readInt("startFrame", 0);
        this.interpolationRate = inputCapsule.readFloat("interpolationRate", 0.05f);
        this.lastTime = inputCapsule.readFloat("lastTime", 0.0f);
        this.cycleMode = inputCapsule.readInt("cycleMode", 1);
        this.interpolate = inputCapsule.readBoolean("interpolate", true);
        this.children = inputCapsule.readSavableArrayList("children", null);
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    public void resetCurrentTime() {
        this.currentTime = 0.0f;
        this.lastTime = 0.0f;
    }

    public void reset() {
        this.currentFrame = this.startFrame + 1;
        this.prevFrame = this.startFrame;
        this.currentTime = this.keyframeTime[this.startFrame];
    }
}

