/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.util;

import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.FloatUtils;

public final class TupleUtils {
    private TupleUtils() {
    }

    public static float distanceSquared(Tuple3f a, Tuple3f b) {
        float dx = a.getX() - b.getX();
        float dy = a.getY() - b.getY();
        float dz = a.getZ() - b.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public static final float vectorLengthSquared(Tuple3f v) {
        return FloatUtils.vectorLengthSquared(v.getX(), v.getY(), v.getZ());
    }

    public static final float vectorLength(Tuple3f v) {
        return FloatUtils.vectorLength(v.getX(), v.getY(), v.getZ());
    }

    public static int compareTuple(Tuple3f ta, Tuple3f tb) {
        if (ta.getX() < tb.getX()) {
            return -1;
        }
        if (ta.getX() > tb.getX()) {
            return 1;
        }
        if (ta.getY() < tb.getY()) {
            return -1;
        }
        if (ta.getY() > tb.getY()) {
            return 1;
        }
        if (ta.getZ() < tb.getZ()) {
            return -1;
        }
        if (ta.getZ() > tb.getZ()) {
            return 1;
        }
        return 0;
    }

    public static boolean limit(Tuple3f tuple, float minx, float miny, float maxx, float maxy) {
        boolean outside = false;
        if (tuple.getX() < minx) {
            tuple.setX(minx);
            outside = true;
        } else if (tuple.getX() > maxx) {
            tuple.setX(maxx);
            outside = true;
        }
        if (tuple.getY() < miny) {
            tuple.setY(miny);
            outside = true;
        } else if (tuple.getY() > maxy) {
            tuple.setY(maxy);
            outside = true;
        }
        return outside;
    }

    public static boolean limit(Tuple3f tuple, float maxx, float maxy) {
        boolean outside = false;
        if (tuple.getX() < 0.0f) {
            tuple.setX(0.0f);
            outside = true;
        } else if (tuple.getX() > maxx) {
            tuple.setX(maxx);
            outside = true;
        }
        if (tuple.getY() < 0.0f) {
            tuple.setY(0.0f);
            outside = true;
        } else if (tuple.getY() > maxy) {
            tuple.setY(maxy);
            outside = true;
        }
        return outside;
    }
}

