/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2.pools;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    private List<T> objects;
    private int n;

    public int getSize() {
        return this.n;
    }

    protected abstract T newInstance();

    public synchronized T alloc() {
        if (this.n > 0) {
            T o = this.objects.remove(--this.n);
            return o;
        }
        return this.newInstance();
    }

    public synchronized void free(T o) {
        if (o == null) {
            return;
        }
        this.objects.add(o);
        ++this.n;
    }

    public ObjectPool(int initialSize) {
        this.objects = new ArrayList<T>(initialSize);
        this.n = 0;
    }
}

