/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.VectorInterface;
import org.openmali.vecmath2.pools.Vector3fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector3f
extends Tuple3f
implements Externalizable,
VectorInterface<Tuple3f, Vector3f> {
    private static final long serialVersionUID = -8110150970595936075L;
    public static final Vector3f ZERO = Vector3f.newReadOnly(0.0f, 0.0f, 0.0f);
    public static final Vector3f POSITIVE_X_AXIS = Vector3f.newReadOnly(1.0f, 0.0f, 0.0f);
    public static final Vector3f NEGATIVE_X_AXIS = Vector3f.newReadOnly(-1.0f, 0.0f, 0.0f);
    public static final Vector3f POSITIVE_Y_AXIS = Vector3f.newReadOnly(0.0f, 1.0f, 0.0f);
    public static final Vector3f NEGATIVE_Y_AXIS = Vector3f.newReadOnly(0.0f, -1.0f, 0.0f);
    public static final Vector3f POSITIVE_Z_AXIS = Vector3f.newReadOnly(0.0f, 0.0f, 1.0f);
    public static final Vector3f NEGATIVE_Z_AXIS = Vector3f.newReadOnly(0.0f, 0.0f, -1.0f);
    private static final Vector3fPool POOL = new Vector3fPool(128);

    @Override
    public final float lengthSquared() {
        float result = 0.0f;
        int i = 0;
        while (i < this.getSize()) {
            result += this.getValue(i) * this.getValue(i);
            ++i;
        }
        return result;
    }

    @Override
    public final float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public final Vector3f normalize() {
        float l = this.length();
        this.divX(l);
        this.divY(l);
        this.divZ(l);
        return this;
    }

    public final Vector3f normalize(Vector3f vector) {
        this.set((TupleNf)vector);
        this.normalize();
        return this;
    }

    public final Vector3f cross(Vector3f v1, Vector3f v2) {
        this.set(v1.getY() * v2.getZ() - v1.getZ() * v2.getY(), v1.getZ() * v2.getX() - v1.getX() * v2.getZ(), v1.getX() * v2.getY() - v1.getY() * v2.getX());
        return this;
    }

    @Override
    public final float dot(Vector3f v2) {
        return this.getX() * v2.getX() + this.getY() * v2.getY() + this.getZ() * v2.getZ();
    }

    @Override
    public final float angle(Vector3f v2) {
        float vDot = this.dot(v2) / (this.length() * v2.length());
        if (vDot < -1.0f) {
            vDot = -1.0f;
        }
        if (vDot > 1.0f) {
            vDot = 1.0f;
        }
        return FastMath.acos(vDot);
    }

    protected Vector3f(boolean readOnly, float x, float y, float z) {
        super(readOnly, x, y, z);
    }

    protected Vector3f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1], values[2]);
    }

    protected Vector3f(boolean readOnly, Tuple3f tuple) {
        this(readOnly, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    protected Vector3f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f);
    }

    public Vector3f(float x, float y, float z) {
        this(false, x, y, z);
    }

    public Vector3f(float[] values) {
        this(false, values);
    }

    public Vector3f(Tuple3f tuple) {
        this(false, tuple);
    }

    public Vector3f() {
        this(false);
    }

    public static Vector3f newReadOnly(float x, float y, float z) {
        return new Vector3f(true, x, y, z);
    }

    public static Vector3f newReadOnly(float[] values) {
        return new Vector3f(true, values);
    }

    public static Vector3f newReadOnly(Tuple3f tuple) {
        return new Vector3f(true, tuple);
    }

    public static Vector3f newReadOnly() {
        return new Vector3f(true);
    }

    public static Vector3f fromPool() {
        return POOL.alloc();
    }

    public static Vector3f fromPool(float x, float y, float z) {
        return POOL.alloc(x, y, z);
    }

    public static Vector3f fromPool(Tuple3f tuple) {
        return Vector3f.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Vector3f o) {
        POOL.free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly() {
        return Vector3f.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(Tuple3f tuple3f) {
        return Vector3f.newReadOnly(tuple3f);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(float[] fArray) {
        return Vector3f.newReadOnly(fArray);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(float f, float f2, float f3) {
        return Vector3f.newReadOnly(f, f2, f3);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool(Tuple3f tuple3f) {
        return Vector3f.fromPool(tuple3f);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool(float f, float f2, float f3) {
        return Vector3f.fromPool(f, f2, f3);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool() {
        return Vector3f.fromPool();
    }
}

