/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.vecmath2.util.SerializationUtils;

public class Tuple4i
implements Externalizable {
    private static final long serialVersionUID = 586023996166921455L;
    protected static final int N = 4;
    protected final int[] values;
    protected final int roTrick;
    private boolean isDirty = false;

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final int getSize() {
        return 4;
    }

    public final Tuple4i setValue(int i, int v) {
        this.values[this.roTrick + i] = v;
        this.isDirty = true;
        return this;
    }

    public final int getValue(int i) {
        return this.values[i];
    }

    public final Tuple4i setX(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple4i setY(int y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple4i setZ(int z) {
        this.setValue(2, z);
        return this;
    }

    public final Tuple4i setW(int w) {
        this.setValue(3, w);
        return this;
    }

    public final int getX() {
        return this.getValue(0);
    }

    public final int getY() {
        return this.getValue(1);
    }

    public final int getZ() {
        return this.getValue(2);
    }

    public final int getW() {
        return this.getValue(3);
    }

    public final Tuple4i setValues(int x, int y, int z, int w) {
        this.setX(x);
        this.setY(y);
        this.setY(z);
        this.setW(w);
        return this;
    }

    public final Tuple4i set(int[] values) {
        System.arraycopy(values, 0, this.values, this.roTrick + 0, 4);
        this.isDirty = true;
        return this;
    }

    public final Tuple4i set(Tuple4i tuple) {
        System.arraycopy(tuple.values, 0, this.values, this.roTrick + 0, 4);
        return this;
    }

    public final Tuple4i get(int[] buffer) {
        System.arraycopy(this.values, 0, buffer, 0, 4);
        return this;
    }

    public final Tuple4i get(Tuple4i buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, 4);
        return this;
    }

    public final Tuple4i setZero() {
        int i = 0;
        while (i < this.getSize()) {
            this.setValue(i, 0);
            ++i;
        }
        return this;
    }

    public final Tuple4i negate(Tuple4i tuple) {
        this.setX(-tuple.getX());
        this.setY(-tuple.getY());
        this.setZ(-tuple.getZ());
        this.setW(-tuple.getW());
        return this;
    }

    public final Tuple4i negate() {
        int i = 0;
        while (i < 4) {
            int n = this.roTrick + i;
            this.values[n] = (int)((float)this.values[n] * -1.0f);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i absolute() {
        int i = 0;
        while (i < 4) {
            this.values[this.roTrick + i] = Math.abs(this.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i absolute(Tuple4i tuple) {
        int i = 0;
        while (i < 4) {
            this.values[this.roTrick + i] = Math.abs(tuple.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i addX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i addY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i addZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i addW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i add(int x, int y, int z, int w) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + z;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] + w;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i subX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i subY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i subZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i subW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i sub(int x, int y, int z, int w) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - z;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] - w;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i mulX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i mulY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i mulZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i mulW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i mul(int vx, int vy, int vz, int vw) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vz;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] * vw;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i divX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i divY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i divZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i divW(int v) {
        int n = this.roTrick + 3;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i div(int vx, int vy, int vz, int vw) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vz;
        int n4 = this.roTrick + 3;
        this.values[n4] = this.values[n4] / vw;
        this.isDirty = true;
        return this;
    }

    public final Tuple4i add(Tuple4i tuple1, Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, tuple1.getValue(i) + tuple2.getValue(i));
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i add(Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, this.getValue(i) + tuple2.getValue(i));
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i sub(Tuple4i tuple1, Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, tuple1.values[i] - tuple2.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i sub(Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, this.values[i] - tuple2.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple4i scale(int factorX, int factorY, int factorZ, int factorW) {
        this.mul(factorX, factorY, factorZ, factorW);
        return this;
    }

    public final Tuple4i scale(int factor, Tuple4i tuple) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, factor * tuple.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple4i scale(int factor) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, this.getValue(i) * factor);
            ++i;
        }
        return this;
    }

    public final Tuple4i scaleAdd(int factor, Tuple4i tuple1, Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, factor * tuple1.values[i] + tuple2.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple4i scaleAdd(int factor, Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            this.setValue(i, factor * this.values[i] + tuple2.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple4i clampMin(int min) {
        int i = 0;
        while (i < 4) {
            if (this.getValue(i) < min) {
                this.setValue(i, min);
            }
            ++i;
        }
        return this;
    }

    public final Tuple4i clampMax(int max) {
        int i = 0;
        while (i < 4) {
            if (this.getValue(i) > max) {
                this.setValue(i, max);
            }
            ++i;
        }
        return this;
    }

    public final Tuple4i clamp(int min, int max) {
        this.clampMin(min);
        this.clampMax(max);
        return this;
    }

    public final Tuple4i clamp(int min, int max, Tuple4i tuple) {
        this.set(tuple);
        this.clamp(min, max);
        return this;
    }

    public final Tuple4i clampMin(int min, Tuple4i tuple) {
        this.set(tuple);
        this.clampMin(min);
        return this;
    }

    public final Tuple4i clampMax(int max, Tuple4i tuple) {
        this.set(tuple);
        this.clampMax(max);
        return this;
    }

    public int hashCode() {
        return this.values[0] ^ this.values[1] ^ this.values[2] ^ this.values[3];
    }

    public boolean equals(Tuple4i tuple2) {
        int i = 0;
        while (i < 4) {
            if (tuple2.getValue(i) != this.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple4i && this.equals((Tuple4i)tuple2);
    }

    public String toString() {
        return "(" + this.getValue(0) + ", " + this.getValue(1) + ", " + this.getValue(2) + ", " + this.getValue(3) + ")";
    }

    public Tuple4i clone() {
        try {
            return (Tuple4i)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < 4) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < 4) {
            this.values[i] = SerializationUtils.readIntFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 17;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected Tuple4i(boolean readOnly, int x, int y, int z, int w) {
        this.values = new int[]{x, y, z, w};
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    protected Tuple4i(boolean readOnly, int[] values) {
        this(readOnly, values[0], values[1], values[2], values[3]);
    }

    protected Tuple4i(boolean readOnly, Tuple4i that) {
        this(readOnly, that.values);
    }

    public Tuple4i(int x, int y, int z, int w) {
        this(false, x, y, z, w);
    }

    public Tuple4i(int[] values) {
        this(false, values);
    }

    public Tuple4i(Tuple4i that) {
        this(false, that);
    }
}

