/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.vecmath2.util.SerializationUtils;

public class Tuple3i
implements Externalizable {
    private static final long serialVersionUID = 586023996166921455L;
    protected static final int N = 3;
    protected final int[] values;
    protected final int roTrick;
    private boolean isDirty = false;

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final int getSize() {
        return 3;
    }

    public final Tuple3i setValue(int i, int v) {
        this.values[this.roTrick + i] = v;
        this.isDirty = true;
        return this;
    }

    public final int getValue(int i) {
        return this.values[i];
    }

    public final Tuple3i setX(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple3i setY(int y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple3i setZ(int z) {
        this.setValue(2, z);
        return this;
    }

    public final int getX() {
        return this.getValue(0);
    }

    public final int getY() {
        return this.getValue(1);
    }

    public final int getZ() {
        return this.getValue(2);
    }

    public final Tuple3i set(int x, int y, int z) {
        this.setX(x);
        this.setY(y);
        this.setY(z);
        return this;
    }

    public final Tuple3i set(int[] values) {
        System.arraycopy(values, 0, this.values, this.roTrick + 0, 3);
        this.isDirty = true;
        return this;
    }

    public final Tuple3i set(Tuple3i tuple) {
        System.arraycopy(tuple.values, 0, this.values, this.roTrick + 0, 3);
        return this;
    }

    public final void get(int[] buffer) {
        System.arraycopy(this.values, 0, buffer, 0, 3);
    }

    public final void get(Tuple3i buffer) {
        System.arraycopy(this.values, 0, buffer.values, 0, 3);
    }

    public final Tuple3i setZero() {
        int i = 0;
        while (i < this.getSize()) {
            this.setValue(i, 0);
            ++i;
        }
        return this;
    }

    public final Tuple3i negate(Tuple3i tuple) {
        this.setX(-tuple.getX());
        this.setY(-tuple.getY());
        this.setZ(-tuple.getZ());
        return this;
    }

    public final Tuple3i negate() {
        int i = 0;
        while (i < 3) {
            int n = this.roTrick + i;
            this.values[n] = (int)((float)this.values[n] * -1.0f);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i absolute() {
        int i = 0;
        while (i < 3) {
            this.values[this.roTrick + i] = Math.abs(this.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i absolute(Tuple3i tuple) {
        int i = 0;
        while (i < 3) {
            this.values[this.roTrick + i] = Math.abs(tuple.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i addX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i addY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i addZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i add(int x, int y, int z) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + z;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i subX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i subY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i subZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i sub(int x, int y, int z) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - z;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i mulX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i mulY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i mulZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i mul(int vx, int vy, int vz) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vz;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i divX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i divY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i divZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i div(int vx, int vy, int vz) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vz;
        this.isDirty = true;
        return this;
    }

    public final Tuple3i add(Tuple3i tuple1, Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, tuple1.getValue(i) + tuple2.getValue(i));
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i add(Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, this.getValue(i) + tuple2.getValue(i));
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i sub(Tuple3i tuple1, Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, tuple1.values[i] - tuple2.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i sub(Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, this.values[i] - tuple2.values[i]);
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final Tuple3i scale(int factorX, int factorY, int factorZ) {
        this.mul(factorX, factorY, factorZ);
        return this;
    }

    public final Tuple3i scale(int factor, Tuple3i tuple) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, factor * tuple.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple3i scale(int factor) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, this.getValue(i) * factor);
            ++i;
        }
        return this;
    }

    public final Tuple3i scaleAdd(int factor, Tuple3i tuple1, Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, factor * tuple1.values[i] + tuple2.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple3i scaleAdd(int factor, Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            this.setValue(i, factor * this.values[i] + tuple2.values[i]);
            ++i;
        }
        return this;
    }

    public final Tuple3i clampMin(int min) {
        int i = 0;
        while (i < 3) {
            if (this.getValue(i) < min) {
                this.setValue(i, min);
            }
            ++i;
        }
        return this;
    }

    public final Tuple3i clampMax(int max) {
        int i = 0;
        while (i < 3) {
            if (this.getValue(i) > max) {
                this.setValue(i, max);
            }
            ++i;
        }
        return this;
    }

    public final Tuple3i clamp(int min, int max) {
        this.clampMin(min);
        this.clampMax(max);
        return this;
    }

    public final Tuple3i clamp(int min, int max, Tuple3i tuple) {
        this.set(tuple);
        this.clamp(min, max);
        return this;
    }

    public final Tuple3i clampMin(int min, Tuple3i tuple) {
        this.set(tuple);
        this.clampMin(min);
        return this;
    }

    public final Tuple3i clampMax(int max, Tuple3i tuple) {
        this.set(tuple);
        this.clampMax(max);
        return this;
    }

    public int hashCode() {
        return this.values[0] ^ this.values[1] ^ this.values[2];
    }

    public boolean equals(Tuple3i tuple2) {
        int i = 0;
        while (i < 3) {
            if (tuple2.getValue(i) != this.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple3i && this.equals((Tuple3i)tuple2);
    }

    public String toString() {
        return "(" + this.getValue(0) + ", " + this.getValue(1) + ", " + this.getValue(2) + ")";
    }

    public Tuple3i clone() {
        try {
            return (Tuple3i)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < 3) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < 3) {
            this.values[i] = SerializationUtils.readIntFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 13;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    protected Tuple3i(boolean readOnly, int x, int y, int z) {
        this.values = new int[]{x, y, z};
        this.roTrick = readOnly ? -2147483647 + this.values.length : 0;
    }

    protected Tuple3i(boolean readOnly, int[] values) {
        this(readOnly, values[0], values[1], values[2]);
    }

    protected Tuple3i(boolean readOnly, Tuple3i that) {
        this(readOnly, that.values);
    }

    public Tuple3i(int x, int y, int z) {
        this(false, x, y, z);
    }

    public Tuple3i(int[] values) {
        this(false, values);
    }

    public Tuple3i(Tuple3i that) {
        this(false, that);
    }
}

