/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleInterface;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.pools.Tuple3fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple3f
extends TupleNf<Tuple3f>
implements Externalizable,
TupleInterface<Tuple3f> {
    private static final long serialVersionUID = 6808120658881162114L;
    private static final Tuple3fPool POOL = new Tuple3fPool(128);

    public final Tuple3f set(float x, float y, float z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    public final Tuple3f setX(float x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple3f setY(float y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple3f setZ(float z) {
        this.setValue(2, z);
        return this;
    }

    public final float getX() {
        return this.getValue(0);
    }

    public final float getY() {
        return this.getValue(1);
    }

    public final float getZ() {
        return this.getValue(2);
    }

    public final Tuple3f addX(float v) {
        this.addValue(0, v);
        return this;
    }

    public final Tuple3f addY(float v) {
        this.addValue(1, v);
        return this;
    }

    public final Tuple3f addZ(float v) {
        this.addValue(2, v);
        return this;
    }

    public final Tuple3f add(float x, float y, float z) {
        this.addValue(0, x);
        this.addValue(1, y);
        this.addValue(2, z);
        return this;
    }

    public final Tuple3f subX(float v) {
        this.subValue(0, v);
        return this;
    }

    public final Tuple3f subY(float v) {
        this.subValue(1, v);
        return this;
    }

    public final Tuple3f subZ(float v) {
        this.subValue(2, v);
        return this;
    }

    public final Tuple3f sub(float x, float y, float z) {
        this.subValue(0, x);
        this.subValue(1, y);
        this.subValue(2, z);
        return this;
    }

    public final Tuple3f mulX(float v) {
        this.mulValue(0, v);
        return this;
    }

    public final Tuple3f mulY(float v) {
        this.mulValue(1, v);
        return this;
    }

    public final Tuple3f mulZ(float v) {
        this.mulValue(2, v);
        return this;
    }

    public final Tuple3f mul(float vx, float vy, float vz) {
        this.mulValue(0, vx);
        this.mulValue(1, vy);
        this.mulValue(2, vz);
        return this;
    }

    public final Tuple3f divX(float v) {
        this.divValue(0, v);
        return this;
    }

    public final Tuple3f divY(float v) {
        this.divValue(1, v);
        return this;
    }

    public final Tuple3f divZ(float v) {
        this.divValue(2, v);
        return this;
    }

    public final Tuple3f div(float vx, float vy, float vz) {
        this.divValue(0, vx);
        this.divValue(1, vy);
        this.divValue(2, vz);
        return this;
    }

    public final Tuple3f scale(float factorX, float factorY, float factorZ) {
        this.mul(factorX, factorY, factorZ);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof Tuple3f && ((TupleNf)this).equals((Tuple3f)o);
    }

    public Tuple3f clone() {
        try {
            return (Tuple3f)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    protected Tuple3f(boolean readOnly, float x, float y, float z) {
        super(readOnly, 3);
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
    }

    protected Tuple3f(boolean readOnly, float[] values) {
        super(readOnly, values, 3, true);
    }

    protected Tuple3f(boolean readOnly, Tuple3f that) {
        super(readOnly, that);
    }

    protected Tuple3f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f);
    }

    public Tuple3f(float x, float y, float z) {
        this(false, x, y, z);
    }

    public Tuple3f(float[] values) {
        this(false, values);
    }

    public Tuple3f(Tuple3f that) {
        this(false, that);
    }

    public Tuple3f() {
        this(false, 0.0f, 0.0f, 0.0f);
    }

    public static Tuple3f newReadOnly(float x, float y, float z) {
        return new Point3f(true, x, y, z);
    }

    public static Tuple3f newReadOnly(float[] values) {
        return new Point3f(true, values);
    }

    public static Tuple3f newReadOnly(Tuple3f tuple) {
        return new Point3f(true, tuple);
    }

    public static Tuple3f newReadOnly() {
        return new Point3f(true);
    }

    public static Tuple3f fromPool() {
        return POOL.alloc();
    }

    public static Tuple3f fromPool(float x, float y, float z) {
        return POOL.alloc(x, y, z);
    }

    public static Tuple3f fromPool(Tuple3f tuple) {
        return Tuple3f.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Tuple3f o) {
        POOL.free(o);
    }
}

