/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.pools.TexCoord2fPool;

public class TexCoord2f
extends TexCoordf
implements Externalizable {
    private static final long serialVersionUID = 4961153246436722156L;
    private static final TexCoord2fPool POOL = new TexCoord2fPool(32);

    public final TexCoord2f set(float s, float t) {
        this.setS(s);
        this.setT(t);
        return this;
    }

    public final TexCoord2f setS(float s) {
        this.values[this.roTrick + 0] = s;
        this.isDirty = true;
        return this;
    }

    public final float getS() {
        return this.values[0];
    }

    public final TexCoord2f setT(float t) {
        this.values[this.roTrick + 1] = t;
        this.isDirty = true;
        return this;
    }

    public final float getT() {
        return this.values[1];
    }

    public final TexCoord2f addS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f addT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f subS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f subT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mulS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mulT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mul(float vs, float vt) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vt;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f mul(float factor) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] * factor;
            ++i;
        }
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f divS(float v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f divT(float v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f div(float vs, float vt) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vs;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vt;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f add(float s, float t) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + t;
        this.isDirty = true;
        return this;
    }

    public final TexCoord2f sub(float s, float t) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - s;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - t;
        this.isDirty = true;
        return this;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof TexCoord2f && this.equals((TexCoord2f)o);
    }

    public TexCoord2f clone() {
        try {
            return (TexCoord2f)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public TexCoord2f(boolean readOnly, float s, float t) {
        super(readOnly, new float[]{s, t});
    }

    public TexCoord2f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1]);
    }

    public TexCoord2f(boolean readOnly, TexCoordf texCoord) {
        super(readOnly, TexCoord2f.newArray(texCoord.values, 2));
    }

    public TexCoord2f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f);
    }

    public TexCoord2f(float s, float t) {
        this(false, s, t);
    }

    public TexCoord2f(float[] values) {
        this(false, values);
    }

    public TexCoord2f(TexCoordf texCoord) {
        this(false, texCoord);
    }

    public TexCoord2f() {
        this(false);
    }

    public static TexCoord2f fromPool() {
        return POOL.alloc();
    }

    public static TexCoord2f fromPool(float s, float t) {
        return POOL.alloc(s, t);
    }

    public static void toPool(TexCoord2f o) {
        POOL.free(o);
    }
}

