/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.PointInterface;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.pools.Point2fPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point2f
extends Tuple2f
implements Externalizable,
PointInterface<Tuple2f, Point2f> {
    private static final long serialVersionUID = -193058726611025895L;
    public static final Point2f ZERO = Point2f.newReadOnly(0.0f, 0.0f);
    private static final Point2fPool POOL = new Point2fPool(128);

    @Override
    public final float distanceSquared(Point2f point2) {
        float dx = this.getX() - point2.getX();
        float dy = this.getX() - point2.getY();
        return dx * dx + dy * dy;
    }

    @Override
    public final float distance(Point2f point2) {
        return FastMath.sqrt(this.distanceSquared(point2));
    }

    public final float distanceL1(Point2f point2) {
        return Math.abs(this.getX() - point2.getX()) + Math.abs(this.getY() - point2.getY());
    }

    public final float distanceLinf(Point2f point2) {
        return Math.max(Math.abs(this.getX() - point2.getY()), Math.abs(this.getY() - point2.getY()));
    }

    protected Point2f(boolean readOnly, float x, float y) {
        super(readOnly, x, y);
    }

    protected Point2f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1]);
    }

    protected Point2f(boolean readOnly, Tuple2f tuple) {
        this(readOnly, tuple.getX(), tuple.getY());
    }

    protected Point2f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f);
    }

    public Point2f(float x, float y) {
        this(false, x, y);
    }

    public Point2f(float[] values) {
        this(false, values);
    }

    public Point2f(Tuple2f tuple) {
        this(false, tuple);
    }

    public Point2f() {
        this(false);
    }

    public static Point2f newReadOnly(float x, float y) {
        return new Point2f(true, x, y);
    }

    public static Point2f newReadOnly(float[] values) {
        return new Point2f(true, values);
    }

    public static Point2f newReadOnly(Tuple2f tuple) {
        return new Point2f(true, tuple);
    }

    public static Point2f newReadOnly() {
        return new Point2f(true);
    }

    public static Point2f fromPool() {
        return POOL.alloc();
    }

    public static Point2f fromPool(float x, float y) {
        return POOL.alloc(x, y);
    }

    public static Point2f fromPool(Tuple2f tuple) {
        return Point2f.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Point2f o) {
        POOL.free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly() {
        return Point2f.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly(Tuple2f tuple2f) {
        return Point2f.newReadOnly(tuple2f);
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly(float[] fArray) {
        return Point2f.newReadOnly(fArray);
    }

    public static /* bridge */ /* synthetic */ Tuple2f newReadOnly(float f, float f2) {
        return Point2f.newReadOnly(f, f2);
    }

    public static /* bridge */ /* synthetic */ Tuple2f fromPool(Tuple2f tuple2f) {
        return Point2f.fromPool(tuple2f);
    }

    public static /* bridge */ /* synthetic */ Tuple2f fromPool(float f, float f2) {
        return Point2f.fromPool(f, f2);
    }

    public static /* bridge */ /* synthetic */ Tuple2f fromPool() {
        return Point2f.fromPool();
    }
}

