/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.spatial.SpatialCallback;
import org.openmali.spatial.SpatialHandle;
import org.openmali.spatial.octree.OcTree;
import org.openmali.vecmath2.Point3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcTest {
    private OcTree<TestObject> tree;

    public OcTest(OcTree<TestObject> tree) {
        this.tree = tree;
    }

    public TestCallback<TestObject> test(float x, float y, float z, float radius, float cx, float cy, float cz, float cradius) {
        TestObject o = new TestObject();
        this.tree.insert(x, y, z, radius, o);
        TestCallback<TestObject> callback = new TestCallback<TestObject>(o);
        this.tree.findWithinSphere(new Point3f(cx, cy, cz), cradius, callback);
        return callback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestCallback<T>
    implements SpatialCallback<T> {
        TestObject o;
        int hits = 0;
        boolean found = false;

        public TestCallback(TestObject object) {
            this.o = object;
            this.found = false;
        }

        @Override
        public void hit(SpatialHandle<T> handle) {
            if (handle.getObject() == this.o) {
                this.found = true;
            }
            ++this.hits;
        }
    }

    class TestObject {
        TestObject() {
        }
    }
}

