/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.FastMath;
import org.openmali.spatial.Visibility;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.spatial.octree.OcCell;
import org.openmali.spatial.octree.OcCuller;
import org.openmali.spatial.octree.OcNode;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcRadiusCuller<T>
implements OcCuller<T> {
    private Sphere s;
    private Sphere cellSphere;

    public OcRadiusCuller(Tuple3f center, float radius) {
        this.s = new Sphere(center, radius);
        this.cellSphere = new Sphere();
    }

    @Override
    public Visibility checkCell(OcCell<T> cell) {
        this.cellSphere.setCenter(cell.cx, cell.cy, cell.cz);
        float radius = FastMath.sqrt(cell.halfSize * cell.halfSize * 3.0f);
        this.cellSphere.setRadius(radius);
        Visibility val = this.cellSphere.containsPlus(this.s.getCenterX(), this.s.getCenterY(), this.s.getCenterZ(), this.s.getRadius()) ? Visibility.FULLY_VISIBLE : Visibility.NOT_VISIBLE;
        return val;
    }

    @Override
    public Visibility checkNode(OcNode<T> node) {
        Visibility val = node.containsPlus(this.s.getCenterX(), this.s.getCenterY(), this.s.getCenterZ(), this.s.getRadius()) ? Visibility.FULLY_VISIBLE : Visibility.NOT_VISIBLE;
        return val;
    }
}

