/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bounds;

import java.util.List;
import org.openmali.FastMath;
import org.openmali.errorhandling.UnsupportedFunction;
import org.openmali.spatial.VertexContainer;
import org.openmali.spatial.VertexList;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.ConvexHull;
import org.openmali.spatial.bodies.IntersectionFactory;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingSphere
extends Sphere
implements Bounds {
    private static final long serialVersionUID = 4408387188891021551L;
    private VertexList vertexList = new VertexList();
    private Point3f tmpP = new Point3f();

    @Override
    public final BoundsType getType() {
        return BoundsType.SPHERE;
    }

    @Override
    public final float getMaxSquaredDistance() {
        return this.getRadiusSquared();
    }

    @Override
    public final float getMaxDistance() {
        return this.getRadius();
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        return IntersectionFactory.sphereIntersectsRay(this, rayOrigin, rayDirection, intersection);
    }

    @Override
    public boolean intersects(Ray3f ray, Tuple3f intersection) {
        return this.intersects(ray.getOrigin(), ray.getDirection(), intersection);
    }

    @Override
    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return this.intersects(rayOrigin, rayDirection, null);
    }

    @Override
    public boolean intersects(Ray3f ray) {
        return this.intersects(ray, null);
    }

    @Override
    public boolean intersects(Bounds bo) {
        if (bo instanceof Box) {
            return IntersectionFactory.sphereIntersectsBox(this, (Box)((Object)bo));
        }
        if (bo instanceof Sphere) {
            return IntersectionFactory.sphereIntersectsSphere(this, (Sphere)((Object)bo));
        }
        if (bo instanceof ConvexHull) {
            throw new Error("ConvexHull not supported yet");
        }
        throw new Error("unknown bounds type");
    }

    @Override
    public boolean intersects(Bounds[] bos) {
        int i = 0;
        while (i < bos.length) {
            if (this.intersects(bos[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Bounds closestIntersection(Bounds[] boundsObjects) {
        throw new UnsupportedFunction();
    }

    @Override
    public void transform(Matrix4f trans) {
        this.tmpP.set((TupleNf)this.getCenter());
        trans.transform(this.tmpP);
        this.setCenter(this.tmpP);
        this.setRadius(this.getRadius() * trans.getScale());
    }

    @Override
    public void transform(Bounds bounds, Matrix4f trans) {
        this.set(bounds);
        this.transform(trans);
    }

    @Override
    public void set(Bounds boundsObject) {
        if (boundsObject instanceof Sphere) {
            Sphere s = (Sphere)((Object)boundsObject);
            this.setCenter(s.getCenter());
            this.setRadius(s.getRadius());
        } else if (boundsObject instanceof Box) {
            Box b2 = (Box)((Object)boundsObject);
            Point3f lower = b2.getLower();
            Point3f upper = b2.getUpper();
            this.setCenter((upper.getX() + lower.getX()) / 2.0f, (upper.getY() + lower.getY()) / 2.0f, (upper.getZ() + lower.getZ()) / 2.0f);
            this.setRadius(lower.distance(upper) / 2.0f);
        } else {
            if (boundsObject instanceof ConvexHull) {
                throw new Error("ConvexHull not supported yet");
            }
            throw new Error("unknown bounds type: " + boundsObject);
        }
    }

    @Override
    public void set(Bounds[] bos) {
        if (bos.length > 0) {
            this.set(bos[0]);
        }
        int i = 1;
        while (i < bos.length) {
            this.combine(bos[i]);
            ++i;
        }
    }

    private static final void computeByAABB(VertexContainer source, Sphere sphere) {
        int numVerts = source.getVertexCount();
        Point3f xmin = Point3f.fromPool(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f xmax = Point3f.fromPool(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        Point3f ymin = Point3f.fromPool(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f ymax = Point3f.fromPool(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        Point3f zmin = Point3f.fromPool(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f zmax = Point3f.fromPool(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        Point3f vertex = Point3f.fromPool();
        int i = 0;
        while (i < numVerts) {
            source.getVertex(i, vertex);
            if (vertex.getX() < xmin.getX()) {
                xmin.set((TupleNf)vertex);
            }
            if (vertex.getX() > xmax.getX()) {
                xmax.set((TupleNf)vertex);
            }
            if (vertex.getY() < ymin.getY()) {
                ymin.set((TupleNf)vertex);
            }
            if (vertex.getY() > ymax.getY()) {
                ymax.set((TupleNf)vertex);
            }
            if (vertex.getZ() < zmin.getZ()) {
                zmin.set((TupleNf)vertex);
            }
            if (vertex.getZ() > zmax.getZ()) {
                zmax.set((TupleNf)vertex);
            }
            ++i;
        }
        sphere.setCenter(xmin.getX() + (xmax.getX() - xmin.getX()) * 0.5f, ymin.getY() + (ymax.getY() - ymin.getY()) * 0.5f, zmin.getZ() + (zmax.getZ() - zmin.getZ()) * 0.5f);
        Vector3f radiusVec = Vector3f.fromPool();
        Point3f min = Point3f.fromPool();
        Point3f max = Point3f.fromPool();
        min.set(xmin.getX(), ymin.getY(), zmin.getZ());
        max.set(xmax.getX(), ymax.getY(), zmax.getZ());
        radiusVec.sub(max, min);
        sphere.setRadius(radiusVec.length() * 0.5f);
        Point3f.toPool(max);
        Point3f.toPool(min);
        Vector3f.toPool(radiusVec);
        Point3f.toPool(vertex);
        Point3f.toPool(xmin);
        Point3f.toPool(xmax);
        Point3f.toPool(ymin);
        Point3f.toPool(ymax);
        Point3f.toPool(zmin);
        Point3f.toPool(zmax);
    }

    private static final void computeExactly(VertexContainer source, Sphere sphere) {
        int numVerts = source.getVertexCount();
        Point3f vertex = Point3f.fromPool();
        Point3f avgVertex = Point3f.fromPool();
        Point3f sum = Point3f.fromPool();
        avgVertex.set(0.0f, 0.0f, 0.0f);
        sum.set(0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < numVerts) {
            source.getVertex(i, vertex);
            sum.add(vertex);
            if (i % 100 == 0) {
                sum.div(numVerts);
                avgVertex.add(sum);
                sum.set(0.0f, 0.0f, 0.0f);
            }
            ++i;
        }
        sum.div(numVerts);
        avgVertex.add(sum);
        sum.set(0.0f, 0.0f, 0.0f);
        sphere.setCenter(avgVertex);
        Point3f.toPool(sum);
        Point3f.toPool(avgVertex);
        Point3f center = sphere.getCenter();
        float maxDist_sq = 0.0f;
        int i2 = 0;
        while (i2 < numVerts) {
            source.getVertex(i2, vertex);
            float dist_sq = vertex.distanceSquared(center);
            if (dist_sq > maxDist_sq) {
                maxDist_sq = dist_sq;
            }
            ++i2;
        }
        sphere.setRadius(FastMath.sqrt(maxDist_sq));
        Point3f.toPool(vertex);
    }

    @Override
    public void compute(VertexContainer source) {
        BoundingSphere.computeExactly(source, this);
    }

    @Override
    public void compute(List<Tuple3f> coords) {
        this.vertexList.set(coords);
        this.compute(this.vertexList);
    }

    @Override
    public void compute(Tuple3f[] coords) {
        this.vertexList.set(coords);
        this.compute(this.vertexList);
    }

    @Override
    public String toString() {
        return "Bounding" + super.toString();
    }

    public BoundingSphere(float centerX, float centerY, float centerZ, float radius) {
        super(centerX, centerY, centerZ, radius);
    }

    public BoundingSphere(Tuple3f center, float radius) {
        this(center.getX(), center.getY(), center.getZ(), radius);
    }

    public BoundingSphere() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public BoundingSphere(Bounds bo) {
        this();
        this.set(bo);
    }

    public BoundingSphere(Bounds[] bos) {
        this();
        this.set(bos);
    }

    public static BoundingSphere newBoundingSphere(VertexContainer source) {
        BoundingSphere bs = new BoundingSphere();
        bs.compute(source);
        return bs;
    }

    public static BoundingSphere newBoundingSphere(List<Tuple3f> coords) {
        BoundingSphere bs = new BoundingSphere();
        bs.compute(coords);
        return bs;
    }

    public static BoundingSphere newBoundingSphere(Tuple3f[] coords) {
        BoundingSphere bs = new BoundingSphere();
        bs.compute(coords);
        return bs;
    }
}

