/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openmali.spatial.bodies.Line;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Ray3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public final class Plane
implements Externalizable {
    private static final long serialVersionUID = 9114612905166638720L;
    private static final float EPSILON = 1.0E-6f;
    private static final Vector3f temp = new Vector3f();
    private Vector3f normal = new Vector3f();
    private float d = 0.0f;

    public void setNormal(Vector3f normal) {
        this.normal.set((TupleNf)normal);
        this.normalize();
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setA(float a) {
        this.normal.setX(a);
        this.normalize();
    }

    public float getA() {
        return this.normal.getX();
    }

    public void setB(float b) {
        this.normal.setY(b);
        this.normalize();
    }

    public float getB() {
        return this.normal.getY();
    }

    public void setC(float c) {
        this.normal.setZ(c);
        this.normalize();
    }

    public float getC() {
        return this.normal.getZ();
    }

    public void setD(float d) {
        this.d = d;
        this.normalize();
    }

    public float getD() {
        return this.d;
    }

    public float distanceTo(float x, float y, float z) {
        return this.normal.getX() * x + this.normal.getY() * y + this.normal.getZ() * z + this.d;
    }

    public float distanceTo(Tuple3f v) {
        return this.distanceTo(v.getX(), v.getY(), v.getZ());
    }

    public boolean intersects(Plane rkPlane1, Line rkLine) {
        float fN00 = this.getNormal().lengthSquared();
        float fN01 = this.getNormal().dot(rkPlane1.getNormal());
        float fN11 = rkPlane1.getNormal().lengthSquared();
        float fDet = fN00 * fN11 - fN01 * fN01;
        if (Math.abs(fDet) < 1.0E-6f) {
            return false;
        }
        float fInvDet = 1.0f / fDet;
        float fC0 = (fN11 * this.d - fN01 * rkPlane1.d) * fInvDet;
        float fC1 = (fN00 * rkPlane1.d - fN01 * this.d) * fInvDet;
        rkLine.getDirection().cross(this.getNormal(), rkPlane1.getNormal());
        temp.set((TupleNf)this.getNormal());
        temp.scale(fC0);
        rkLine.getOrigin().set((TupleNf)temp);
        temp.set((TupleNf)rkPlane1.getNormal());
        temp.scale(fC1);
        rkLine.getOrigin().add(rkLine.getOrigin(), temp);
        return true;
    }

    public float rayIntersectionParametric(Point3f rayOrigin, Vector3f dir, Tuple3f intersection) {
        if (Math.abs(dir.dot(this.getNormal())) < 1.0E-6f) {
            return Float.NaN;
        }
        float t = -this.distanceTo(rayOrigin) / this.getNormal().dot(dir);
        if (intersection != null) {
            intersection.scaleAdd(t, dir, rayOrigin);
        }
        return t;
    }

    public float rayIntersectionParametric(Ray3f ray, Tuple3f intersection) {
        return this.rayIntersectionParametric(ray.getOrigin(), ray.getDirection(), intersection);
    }

    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection, Tuple3f intersection) {
        return this.rayIntersectionParametric(rayOrigin, rayDirection, intersection) >= 0.0f;
    }

    public boolean intersects(Ray3f ray, Tuple3f intersection) {
        return this.intersects(ray.getOrigin(), ray.getDirection(), intersection);
    }

    public boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return this.intersects(rayOrigin, rayDirection, null);
    }

    public boolean intersects(Ray3f ray) {
        return this.intersects(ray, null);
    }

    public boolean segmentIntersection(Point3f from, Point3f to, Tuple3f intersect) {
        Vector3f dir = Vector3f.fromPool();
        dir.sub(to, from);
        float t = this.rayIntersectionParametric(from, dir, intersect);
        Vector3f.toPool(dir);
        return Math.abs(t) <= 1.0f;
    }

    public float intersectsSegment(Tuple3f va, Tuple3f vb, Tuple3f intersection) {
        float da = va.getX() * this.normal.getX() + va.getY() * this.normal.getY() + va.getZ() * this.normal.getZ() + this.d;
        float db = vb.getX() * this.normal.getX() + vb.getY() * this.normal.getY() + vb.getZ() * this.normal.getZ() + this.d;
        if (da <= 0.0f && db >= 0.0f) {
            float s = da / (da - db);
            if (intersection != null) {
                intersection.setX(va.getX() + s * (vb.getX() - va.getX()));
                intersection.setY(va.getY() + s * (vb.getY() - va.getY()));
                intersection.setZ(va.getZ() + s * (vb.getZ() - va.getZ()));
            }
            return Math.abs(da);
        }
        if (db <= 0.0f && da >= 0.0f) {
            float s = da / (da - db);
            if (intersection != null) {
                intersection.setX(va.getX() + s * (vb.getX() - va.getX()));
                intersection.setY(va.getY() + s * (vb.getY() - va.getY()));
                intersection.setZ(va.getZ() + s * (vb.getZ() - va.getZ()));
            }
            return Math.abs(da);
        }
        return Float.NEGATIVE_INFINITY;
    }

    public boolean intersects(Plane rkPlane1) {
        temp.cross(this.getNormal(), rkPlane1.getNormal());
        float length_sq = temp.lengthSquared();
        return length_sq > 1.0E-6f;
    }

    public Plane normalize() {
        float t = this.normal.length();
        this.normal.div(t);
        this.d /= t;
        return this;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (this.normal == null) {
            this.normal = new Vector3f();
        }
        this.normal.setX(in.readFloat());
        this.normal.setY(in.readFloat());
        this.normal.setZ(in.readFloat());
        this.d = in.readFloat();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.normal.getX());
        out.writeFloat(this.normal.getY());
        out.writeFloat(this.normal.getZ());
        out.writeFloat(this.d);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Plane[ A:");
        sb.append(this.normal.getX());
        sb.append(", B:");
        sb.append(this.normal.getY());
        sb.append(", C:");
        sb.append(this.normal.getZ());
        sb.append(", D:");
        sb.append(this.d);
        sb.append(" ]");
        return sb.toString();
    }

    public void set(float a, float b, float c, float d) {
        this.normal.set(a, b, c);
        this.d = d;
        this.normalize();
    }

    public void set(Plane plane) {
        this.normal.set((TupleNf)plane.normal);
        this.d = plane.d;
    }

    public Plane(float a, float b, float c, float d) {
        this.normal.set(a, b, c);
        this.d = d;
        this.normalize();
    }

    public Plane(Vector3f normal, float d) {
        this(normal.getX(), normal.getY(), normal.getZ(), d);
    }

    public Plane(Plane plane) {
        this(plane.normal.getX(), plane.normal.getY(), plane.normal.getZ(), plane.d);
    }

    public Plane() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }
}

