/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Vector3f;

public class Frustum {
    public static float error = 0.0f;
    private final Plane[] planes = new Plane[6];
    private final Matrix4f matrix = new Matrix4f();

    public Matrix4f getMatrix() {
        return this.matrix;
    }

    public void setPlane(int i, Plane plane) {
        assert (i >= 0 && i < 6);
        this.planes[i].set(plane);
    }

    public Plane getPlane(int i) {
        assert (i >= 0 && i < 6);
        return this.planes[i];
    }

    public final Classifier.Classification quickClassify(Box box) {
        int i = 0;
        while (i < 6) {
            Plane p = this.planes[i];
            if (!(p.distanceTo(box.getLowerX(), box.getLowerY(), box.getLowerZ()) > 0.0f || p.distanceTo(box.getUpperX(), box.getLowerY(), box.getLowerZ()) > 0.0f || p.distanceTo(box.getLowerX(), box.getUpperY(), box.getLowerZ()) > 0.0f || p.distanceTo(box.getUpperX(), box.getUpperY(), box.getLowerZ()) > 0.0f || p.distanceTo(box.getLowerX(), box.getLowerY(), box.getUpperZ()) > 0.0f || p.distanceTo(box.getUpperX(), box.getLowerY(), box.getUpperZ()) > 0.0f || p.distanceTo(box.getLowerX(), box.getUpperY(), box.getUpperZ()) > 0.0f || p.distanceTo(box.getUpperX(), box.getUpperY(), box.getUpperZ()) > 0.0f)) {
                return Classifier.Classification.OUTSIDE;
            }
            ++i;
        }
        return Classifier.Classification.SPANNING;
    }

    public final boolean intersects(Plane p, Vector3f[] quad) {
        return false;
    }

    public final void compute(Matrix4f proj, Matrix4f modl) {
        this.matrix.mul(proj, modl);
        this.planes[0].set(this.matrix.m03() - this.matrix.m00(), this.matrix.m13() - this.matrix.m10(), this.matrix.m23() - this.matrix.m20(), this.matrix.m33() - this.matrix.m30());
        this.planes[1].set(this.matrix.m03() + this.matrix.m00(), this.matrix.m13() + this.matrix.m10(), this.matrix.m23() + this.matrix.m20(), this.matrix.m33() + this.matrix.m30());
        this.planes[2].set(this.matrix.m03() + this.matrix.m01(), this.matrix.m13() + this.matrix.m11(), this.matrix.m23() + this.matrix.m21(), this.matrix.m33() + this.matrix.m31());
        this.planes[3].set(this.matrix.m03() - this.matrix.m01(), this.matrix.m13() - this.matrix.m11(), this.matrix.m23() - this.matrix.m21(), this.matrix.m33() - this.matrix.m31());
        this.planes[4].set(this.matrix.m03() - this.matrix.m02(), this.matrix.m13() - this.matrix.m12(), this.matrix.m23() - this.matrix.m22(), this.matrix.m33() - this.matrix.m32());
        this.planes[5].set(this.matrix.m03() + this.matrix.m02(), this.matrix.m13() + this.matrix.m12(), this.matrix.m23() + this.matrix.m22(), this.matrix.m33() + this.matrix.m32());
    }

    public final Matrix4f computeInverse(Matrix4f proj) {
        this.matrix.m00((this.planes[1].getA() - this.planes[0].getA()) / 2.0f);
        this.matrix.m01((this.planes[2].getA() - this.planes[3].getA()) / 2.0f);
        this.matrix.m02((this.planes[5].getA() - this.planes[4].getA()) / 2.0f);
        this.matrix.m03(this.planes[0].getA() + this.matrix.m00());
        this.matrix.m10((this.planes[1].getB() - this.planes[0].getB()) / 2.0f);
        this.matrix.m11((this.planes[2].getB() - this.planes[3].getB()) / 2.0f);
        this.matrix.m12((this.planes[5].getB() - this.planes[4].getB()) / 2.0f);
        this.matrix.m13(this.planes[0].getB() + this.matrix.m10());
        this.matrix.m20((this.planes[1].getC() - this.planes[0].getC()) / 2.0f);
        this.matrix.m21((this.planes[2].getC() - this.planes[3].getC()) / 2.0f);
        this.matrix.m22((this.planes[5].getC() - this.planes[4].getC()) / 2.0f);
        this.matrix.m23(this.planes[0].getC() + this.matrix.m20());
        this.matrix.m30((this.planes[1].getD() - this.planes[0].getD()) / 2.0f);
        this.matrix.m31((this.planes[2].getD() - this.planes[3].getD()) / 2.0f);
        this.matrix.m32((this.planes[5].getD() - this.planes[4].getD()) / 2.0f);
        this.matrix.m33(this.planes[0].getD() + this.matrix.m30());
        if (proj != null) {
            proj.set(this.matrix);
        }
        return this.matrix;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("Frustum[ ");
        sb.append("Left: ");
        sb.append(this.planes[0]);
        sb.append(", Right: ");
        sb.append(this.planes[1]);
        sb.append(", Bottom:");
        sb.append(this.planes[2]);
        sb.append(", Top:");
        sb.append(this.planes[3]);
        sb.append(", Far:");
        sb.append(this.planes[4]);
        sb.append(", Near:");
        sb.append(this.planes[5]);
        sb.append(" ]");
        return sb.toString();
    }

    public Frustum() {
        int i = 0;
        while (i < 6) {
            this.planes[i] = new Plane();
            ++i;
        }
    }
}

