/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import org.openmali.FastMath;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.Frustum;
import org.openmali.spatial.bodies.IntersectionFactory;
import org.openmali.spatial.bodies.Plane;
import org.openmali.spatial.bodies.Sphere;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;

public final class Classifier {
    private static final float EPSILON = 1.0E-6f;

    public static Classification classifySpherePoint(float cx, float cy, float cz, float r, float px, float py, float pz) {
        float dx = cx - px;
        float dy = cy - py;
        float dz = cz - pz;
        if (dx * dx + dy * dy + dz * dz <= r * r) {
            return Classification.INSIDE;
        }
        return Classification.OUTSIDE;
    }

    public static Classification classifySpherePoint(Tuple3f sphereC, float sphereR, float px, float py, float pz) {
        return Classifier.classifySpherePoint(sphereC.getX(), sphereC.getY(), sphereC.getZ(), sphereR, px, py, pz);
    }

    public static Classification classifySpherePoint(Tuple3f sphereC, float sphereR, Point3f point) {
        return Classifier.classifySpherePoint(sphereC, sphereR, point.getX(), point.getY(), point.getZ());
    }

    public static Classification classifySpherePoint(Sphere sphere, Point3f point) {
        return Classifier.classifySpherePoint(sphere.getCenter(), sphere.getRadius(), point);
    }

    public static Classification classifySpherePoint(Sphere sphere, float px, float py, float pz) {
        return Classifier.classifySpherePoint(sphere.getCenterX(), sphere.getCenterY(), sphere.getCenterZ(), sphere.getRadius(), px, py, pz);
    }

    public static Classification classifySphereSphere(float cx1, float cy1, float cz1, float r1, float cx2, float cy2, float cz2, float r2) {
        float dx = cx1 - cx2;
        float dy = cy1 - cy2;
        float dz = cz1 - cz2;
        float d = FastMath.sqrt(dx * dx + dy * dy + dz * dz);
        if (d + r2 < r1) {
            return Classification.INSIDE;
        }
        if (d + r1 < r2) {
            return Classification.ENCLOSING;
        }
        if (d < r2 + r1) {
            return Classification.SPANNING;
        }
        if (d > r1 + r2) {
            return Classification.OUTSIDE;
        }
        return Classification.ENCLOSING;
    }

    public static Classification classifySphereSphere(Tuple3f center1, float radius1, Tuple3f center2, float radius2) {
        return Classifier.classifySphereSphere(center1.getX(), center1.getY(), center1.getZ(), radius1, center2.getX(), center2.getY(), center2.getZ(), radius2);
    }

    public static Classification classifySphereSphere(Sphere sphere1, Sphere sphere2) {
        return Classifier.classifySphereSphere(sphere1.getCenter(), sphere1.getRadius(), sphere2.getCenter(), sphere2.getRadius());
    }

    public static Classification classifySphereBox(Sphere sphere, float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ) {
        return Classifier.classifyBoxSphere(boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUpperY, boxUpperZ, sphere.getCenterX(), sphere.getCenterY(), sphere.getCenterZ(), sphere.getRadius()).invert();
    }

    public static Classification classifySphereBox(Sphere sphere, Tuple3f boxLower, Tuple3f boxUpper) {
        return Classifier.classifySphereBox(sphere, boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ());
    }

    public static Classification classifySphereBox(Sphere sphere, Box box) {
        return Classifier.classifyBoxSphere(box, sphere).invert();
    }

    public static PlaneClassification classifySpherePlane(Sphere sphere, Plane plane) {
        float d = plane.distanceTo(sphere.getCenter());
        if (d >= sphere.getRadius()) {
            return PlaneClassification.IN_FRONT_OF;
        }
        if (d <= -sphere.getRadius()) {
            return PlaneClassification.BEHIND;
        }
        return PlaneClassification.SPANNING;
    }

    public static Classification classifyBoxPoint(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, float px, float py, float pz) {
        if (px >= boxLowerX && py >= boxLowerY && pz >= boxLowerZ && px <= boxUpperX && py <= boxUpperY && pz <= boxUpperZ) {
            return Classification.INSIDE;
        }
        return Classification.OUTSIDE;
    }

    public static Classification classifyBoxPoint(Tuple3f boxLower, Tuple3f boxUpper, Point3f point) {
        return Classifier.classifyBoxPoint(boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ(), point.getX(), point.getY(), point.getZ());
    }

    public static Classification classifyBoxPoint(Box box, Point3f point) {
        return Classifier.classifyBoxPoint(box.getLower(), box.getUpper(), point);
    }

    public static Classification classifyBoxPoint(Box box, float px, float py, float pz) {
        return Classifier.classifyBoxPoint(box.getLowerX(), box.getLowerY(), box.getLowerZ(), box.getUpperX(), box.getUpperY(), box.getUpperZ(), px, py, pz);
    }

    private static final boolean boxEnclosesSphere(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, float x, float y, float z, float radius) {
        float centerX = (boxLowerX + boxUpperX) / 2.0f;
        float centerY = (boxLowerY + boxUpperY) / 2.0f;
        float centerZ = (boxLowerZ + boxUpperZ) / 2.0f;
        float sizeX = boxUpperX - boxLowerX;
        float sizeY = boxUpperY - boxLowerY;
        float sizeZ = boxUpperZ - boxLowerZ;
        float minSpan = sizeX < sizeY ? (sizeX < sizeZ ? sizeX : sizeZ) : (sizeY < sizeZ ? sizeY : sizeZ);
        float dx = centerX - x;
        float dy = centerY - y;
        float dz = centerZ - z;
        float d = FastMath.sqrt(dx * dx + dy * dy + dz * dz);
        return d + radius < minSpan;
    }

    public static Classification classifyBoxSphere(float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ, float x, float y, float z, float radius) {
        if (x >= boxLowerX - radius && y >= boxLowerY - radius && z >= boxLowerZ - radius && x <= boxUpperX + radius && y <= boxUpperY + radius && z <= boxUpperZ + radius) {
            return Classification.INSIDE;
        }
        if (Classifier.boxEnclosesSphere(boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUpperY, boxUpperZ, x, y, z, radius)) {
            return Classification.ENCLOSING;
        }
        if (IntersectionFactory.sphereIntersectsBox(boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUpperY, boxUpperZ, x, y, z, radius)) {
            return Classification.SPANNING;
        }
        return Classification.OUTSIDE;
    }

    public static Classification classifyBoxSphere(Tuple3f boxLower, Tuple3f boxUpper, Tuple3f sphereCenter, float radius) {
        return Classifier.classifyBoxSphere(boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ(), sphereCenter.getX(), sphereCenter.getY(), sphereCenter.getZ(), radius);
    }

    public static Classification classifyBoxSphere(Box box, Sphere sphere) {
        return Classifier.classifyBoxSphere(box.getLower(), box.getUpper(), sphere.getCenter(), sphere.getRadius());
    }

    public static Classification classifyBoxBox(float lowerX1, float lowerY1, float lowerZ1, float upperX1, float upperY1, float upperZ1, float lowerX2, float lowerY2, float lowerZ2, float upperX2, float upperY2, float upperZ2) {
        if ((lowerX1 <= lowerX2 && upperX1 >= upperX2 || lowerX1 >= lowerX2 && lowerX1 <= upperX2 || upperX1 >= lowerX2 && upperX1 <= upperX2) && (lowerY1 <= lowerY2 && upperY1 >= upperY2 || lowerY1 >= lowerY2 && lowerY1 <= upperY2 || upperY1 >= lowerY2 && upperY1 <= upperY2) && (lowerZ1 <= lowerZ2 && upperZ1 >= upperZ2 || lowerZ1 >= lowerZ2 && lowerZ1 <= upperZ2 || upperZ1 >= lowerZ2 && upperZ1 <= upperZ2)) {
            if (lowerX1 <= lowerX2 && lowerY1 <= lowerY2 && lowerZ1 <= lowerZ2 && upperX1 >= upperX2 && upperY1 >= upperY2 && upperZ1 >= upperZ2) {
                return Classification.INSIDE;
            }
            if (lowerX1 > lowerX2 && lowerY1 > lowerY2 && lowerZ1 > lowerZ2 && upperX1 < upperX2 && upperY1 < upperY2 && upperZ1 < upperZ2) {
                return Classification.ENCLOSING;
            }
            return Classification.SPANNING;
        }
        return Classification.OUTSIDE;
    }

    public static Classification classifyBoxBox(Tuple3f boxLower1, Tuple3f boxUpper1, Tuple3f boxLower2, Tuple3f boxUpper2) {
        return Classifier.classifyBoxBox(boxLower1.getX(), boxLower1.getY(), boxLower1.getZ(), boxUpper1.getX(), boxUpper1.getY(), boxUpper1.getZ(), boxLower2.getX(), boxLower2.getY(), boxLower2.getZ(), boxUpper2.getX(), boxUpper2.getY(), boxUpper2.getZ());
    }

    public static Classification classifyBoxBox(Box box1, Box box2) {
        return Classifier.classifyBoxBox(box1.getLower(), box1.getUpper(), box2.getLower(), box2.getUpper());
    }

    public static Classification classifySphereBounds(Sphere sphere1, Bounds bounds) {
        switch (bounds.getType()) {
            case SPHERE: {
                return Classifier.classifySphereSphere(sphere1, (Sphere)((Object)bounds));
            }
            case AABB: {
                return Classifier.classifySphereBox(sphere1, (Box)((Object)bounds));
            }
        }
        throw new IllegalArgumentException("Bounds type " + (Object)((Object)bounds.getType()) + " is not (yet) supported.");
    }

    public static Classification classifyBoxBounds(Box box1, Bounds bounds) {
        switch (bounds.getType()) {
            case SPHERE: {
                return Classifier.classifyBoxSphere(box1, (Sphere)((Object)bounds));
            }
            case AABB: {
                return Classifier.classifyBoxBox(box1, (Box)((Object)bounds));
            }
        }
        throw new IllegalArgumentException("Bounds type " + (Object)((Object)bounds.getType()) + " is not (yet) supported.");
    }

    public static Classification classifyBoundsBounds(Bounds bounds1, Bounds bounds2) {
        switch (bounds1.getType()) {
            case SPHERE: {
                switch (bounds2.getType()) {
                    case SPHERE: {
                        return Classifier.classifySphereSphere((Sphere)((Object)bounds1), (Sphere)((Object)bounds2));
                    }
                    case AABB: {
                        return Classifier.classifySphereBox((Sphere)((Object)bounds1), (Box)((Object)bounds2));
                    }
                }
            }
            case AABB: {
                switch (bounds2.getType()) {
                    case SPHERE: {
                        return Classifier.classifyBoxSphere((Box)((Object)bounds1), (Sphere)((Object)bounds2));
                    }
                    case AABB: {
                        return Classifier.classifyBoxBox((Box)((Object)bounds1), (Box)((Object)bounds2));
                    }
                }
            }
        }
        throw new IllegalArgumentException("Bounds type " + (Object)((Object)bounds2.getType()) + " is not (yet) supported.");
    }

    private static float distancePlanePoint(float planeNx, float planeNy, float planeNz, float planeD, float px, float py, float pz) {
        return planeNx * px + planeNy * py + planeNz * pz + planeD;
    }

    private static float distancePlanePoint(float planeNx, float planeNy, float planeNz, float planeD, Tuple3f point) {
        return Classifier.distancePlanePoint(planeNx, planeNy, planeNz, planeD, point.getX(), point.getY(), point.getZ());
    }

    public static PlaneClassification classifyPlanePoint(float planeNx, float planeNy, float planeNz, float planeD, float x, float y, float z) {
        float distance = Classifier.distancePlanePoint(planeNx, planeNy, planeNz, planeD, x, y, z);
        if (distance < -1.0E-6f) {
            return PlaneClassification.BEHIND;
        }
        if (distance > 1.0E-6f) {
            return PlaneClassification.IN_FRONT_OF;
        }
        return PlaneClassification.COINCIDENT;
    }

    public static PlaneClassification classifyPlanePoint(Plane plane, float px, float py, float pz) {
        float distance = plane.distanceTo(px, py, pz);
        if (distance < -1.0E-6f) {
            return PlaneClassification.BEHIND;
        }
        if (distance > 1.0E-6f) {
            return PlaneClassification.IN_FRONT_OF;
        }
        return PlaneClassification.COINCIDENT;
    }

    public static PlaneClassification classifyPlanePoint(Plane plane, Tuple3f point) {
        return Classifier.classifyPlanePoint(plane, point.getX(), point.getY(), point.getZ());
    }

    public static PlaneClassification classifyPlanePoints(Plane plane, Tuple3f[] points) {
        PlaneClassification c = PlaneClassification.COINCIDENT;
        int i = 0;
        while (i < points.length) {
            c = c.add(Classifier.classifyPlanePoint(plane, points[i]));
            ++i;
        }
        return c;
    }

    public static PlaneClassification classifyPlaneBox(Plane plane, float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUpperY, float boxUpperZ) {
        PlaneClassification classification = Classifier.classifyPlanePoint(plane, boxLowerX, boxLowerY, boxLowerZ);
        if ((classification = classification.add(Classifier.classifyPlanePoint(plane, boxLowerX, boxLowerY, boxUpperZ))) == PlaneClassification.SPANNING) {
            return PlaneClassification.SPANNING;
        }
        if ((classification = classification.add(Classifier.classifyPlanePoint(plane, boxLowerX, boxUpperY, boxLowerZ))) == PlaneClassification.SPANNING) {
            return PlaneClassification.SPANNING;
        }
        if ((classification = classification.add(Classifier.classifyPlanePoint(plane, boxLowerX, boxUpperY, boxUpperZ))) == PlaneClassification.SPANNING) {
            return PlaneClassification.SPANNING;
        }
        if ((classification = classification.add(Classifier.classifyPlanePoint(plane, boxUpperX, boxLowerY, boxLowerZ))) == PlaneClassification.SPANNING) {
            return PlaneClassification.SPANNING;
        }
        if ((classification = classification.add(Classifier.classifyPlanePoint(plane, boxUpperX, boxLowerY, boxUpperZ))) == PlaneClassification.SPANNING) {
            return PlaneClassification.SPANNING;
        }
        if ((classification = classification.add(Classifier.classifyPlanePoint(plane, boxUpperX, boxUpperY, boxLowerZ))) == PlaneClassification.SPANNING) {
            return PlaneClassification.SPANNING;
        }
        classification = classification.add(Classifier.classifyPlanePoint(plane, boxUpperX, boxUpperY, boxUpperZ));
        return classification;
    }

    public static PlaneClassification classifyPlaneBox(Plane plane, Tuple3f boxLower, Tuple3f boxUpper) {
        return Classifier.classifyPlaneBox(plane, boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ());
    }

    public static PlaneClassification classifyPlaneBox(Plane plane, Box box) {
        return Classifier.classifyPlaneBox(plane, box.getLower(), box.getUpper());
    }

    public static final Classification classifyFrustumPoint(Frustum frustum, float x, float y, float z) {
        int p = 0;
        while (p < 6) {
            if (Classifier.classifyPlanePoint(frustum.getPlane(p), x, y, z) == PlaneClassification.BEHIND) {
                return Classification.OUTSIDE;
            }
            ++p;
        }
        return Classification.INSIDE;
    }

    public static final Classification classifyFrustumPoint(Frustum frustum, Point3f point) {
        return Classifier.classifyFrustumPoint(frustum, point.getX(), point.getY(), point.getZ());
    }

    public static final Classification classifyFrustumSphere(Frustum frustum, float x, float y, float z, float radius) {
        int count = 0;
        int i = 0;
        while (i < 6) {
            float d = frustum.getPlane(i).distanceTo(x, y, z);
            if (d >= radius) {
                ++count;
            } else if (d <= -radius) {
                return Classification.OUTSIDE;
            }
            ++i;
        }
        if (count == 6) {
            return Classification.INSIDE;
        }
        return Classification.SPANNING;
    }

    public static final Classification classifyFrustumSphere(Frustum frustum, Tuple3f sphereCenter, float radius) {
        return Classifier.classifyFrustumSphere(frustum, sphereCenter.getX(), sphereCenter.getY(), sphereCenter.getZ(), radius);
    }

    public static final Classification classifyFrustumSphere(Frustum frustum, Sphere sphere) {
        int count = 0;
        int i = 0;
        while (i < 6) {
            PlaneClassification classification = Classifier.classifySpherePlane(sphere, frustum.getPlane(i));
            if (classification == PlaneClassification.BEHIND) {
                return Classification.OUTSIDE;
            }
            if (classification == PlaneClassification.IN_FRONT_OF) {
                ++count;
            }
            ++i;
        }
        if (count == 6) {
            return Classification.INSIDE;
        }
        return Classification.SPANNING;
    }

    public static Classification classifyFrustumBox(Frustum frustum, float boxLowerX, float boxLowerY, float boxLowerZ, float boxUpperX, float boxUupperY, float boxUupperZ) {
        int count = 0;
        int i = 0;
        while (i < 6) {
            PlaneClassification classification = Classifier.classifyPlaneBox(frustum.getPlane(i), boxLowerX, boxLowerY, boxLowerZ, boxUpperX, boxUupperY, boxUupperZ);
            if (classification == PlaneClassification.BEHIND) {
                return Classification.OUTSIDE;
            }
            if (classification == PlaneClassification.IN_FRONT_OF) {
                ++count;
            }
            ++i;
        }
        if (count == 6) {
            return Classification.INSIDE;
        }
        return Classification.SPANNING;
    }

    public static Classification classifyFrustumBox(Frustum frustum, Tuple3f boxLower, Tuple3f boxUpper) {
        return Classifier.classifyFrustumBox(frustum, boxLower.getX(), boxLower.getY(), boxLower.getZ(), boxUpper.getX(), boxUpper.getY(), boxUpper.getZ());
    }

    public static final Classification classifyFrustumBox(Frustum frustum, Box box) {
        return Classifier.classifyFrustumBox(frustum, box.getLower(), box.getUpper());
    }

    public static Classification classifyFrustumBounds(Frustum frustum, Bounds bounds) {
        switch (bounds.getType()) {
            case SPHERE: {
                return Classifier.classifyFrustumSphere(frustum, (Sphere)((Object)bounds));
            }
            case AABB: {
                return Classifier.classifyFrustumBox(frustum, (Box)((Object)bounds));
            }
        }
        throw new IllegalArgumentException("Bounds type " + (Object)((Object)bounds.getType()) + " is not (yet) supported.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Classification {
        INSIDE,
        OUTSIDE,
        SPANNING,
        ENCLOSING;


        public Classification add(Classification c) {
            switch (this) {
                case INSIDE: {
                    if (c == OUTSIDE) {
                        return SPANNING;
                    }
                    if (c == ENCLOSING) {
                        return c;
                    }
                    return this;
                }
                case OUTSIDE: {
                    if (c == INSIDE) {
                        return SPANNING;
                    }
                    if (c == ENCLOSING) {
                        return c;
                    }
                    return this;
                }
                case SPANNING: {
                    if (c == ENCLOSING) {
                        return c;
                    }
                    return this;
                }
                case ENCLOSING: {
                    return this;
                }
            }
            return this;
        }

        public Classification invert() {
            switch (this) {
                case INSIDE: {
                    return ENCLOSING;
                }
                case OUTSIDE: {
                    return this;
                }
                case SPANNING: {
                    return this;
                }
                case ENCLOSING: {
                    return INSIDE;
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlaneClassification {
        IN_FRONT_OF,
        BEHIND,
        SPANNING,
        COINCIDENT;


        public PlaneClassification add(PlaneClassification c) {
            switch (this) {
                case IN_FRONT_OF: {
                    if (c == BEHIND || c == SPANNING) {
                        return SPANNING;
                    }
                    return this;
                }
                case BEHIND: {
                    if (c == IN_FRONT_OF || c == SPANNING) {
                        return SPANNING;
                    }
                    return this;
                }
                case SPANNING: {
                    return SPANNING;
                }
                case COINCIDENT: {
                    return c;
                }
            }
            return this;
        }
    }
}

