/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.angle;

import java.util.Random;
import org.openmali.FastMath;
import org.openmali.angle.NumberUtil;
import org.openmali.test.Test;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector2f;

public abstract class Angle {
    public static float angle(float x, float y) {
        return FastMath.toDeg(FastMath.atan2(x, y));
    }

    public static float angle(Tuple2f t) {
        return FastMath.toDeg(FastMath.atan2(t.getX(), t.getY()));
    }

    public static Vector2f vec(float angle) {
        Vector2f vec = new Vector2f(FastMath.sin(FastMath.toRad(angle)), FastMath.cos(FastMath.toRad(angle)));
        return vec;
    }

    public static Vector2f vec(float angle, float length) {
        Vector2f vec = new Vector2f(FastMath.sin(FastMath.toRad(angle)), FastMath.cos(FastMath.toRad(angle)));
        vec.scale(length);
        return vec;
    }

    public static void main(String[] argv) {
        Random ran = new Random(1846506L);
        Vector2f vec = new Vector2f(ran.nextFloat(), ran.nextFloat());
        vec.normalize();
        float angle = Angle.angle(vec);
        System.out.println("Angle with vec " + vec + " = " + angle);
        Vector2f vec2 = Angle.vec(angle);
        System.out.println("Vec with angle " + angle + " = " + vec2);
        vec.round(3);
        vec2.round(3);
        if (((TupleNf)vec).equals(vec2)) {
            Test.passed((int)1);
        } else {
            Test.failed((int)1);
        }
        float len = ran.nextFloat();
        Vector2f vec3 = Angle.vec(angle, len);
        float len2 = vec3.length();
        System.out.println("Double-scaled vec = " + angle + " = " + vec3 + " of length " + len2 + " should be " + len);
        len = NumberUtil.round(len, 3);
        len2 = NumberUtil.round(len2, 3);
        if (len2 == len) {
            Test.passed((int)2);
        } else {
            Test.failed((int)2);
        }
    }
}

